<?php declare(strict_types=1);
/*
 * This file is part of PHPUnit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace PHPUnit\Event\Test;

use PHPUnit\Event\AbstractEventTestCase;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Small;

#[CoversClass(PreparationFailed::class)]
#[Small]
final class PreparationFailedTest extends AbstractEventTestCase
{
    public function testConstructorSetsValues(): void
    {
        $telemetryInfo = $this->telemetryInfo();
        $test          = $this->testValueObject();

        $event = new PreparationFailed(
            $telemetryInfo,
            $test,
        );

        $this->assertSame($telemetryInfo, $event->telemetryInfo());
        $this->assertSame($test, $event->test());
    }

    public function testCanBeRepresentedAsString(): void
    {
        $event = new PreparationFailed(
            $this->telemetryInfo(),
            $this->testValueObject(),
        );

        $this->assertSame('Test Preparation Failed (FooTest::testBar)', $event->asString());
    }
}
