/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui.typesafe;

import gr.zeus.ui.typesafe.CustomFocusTraversalPolicy;
import gr.zeus.ui.typesafe.SelectAllTextOnFocus;
import gr.zeus.ui.typesafe.SimpleEditorPaneTraversal;
import gr.zeus.ui.typesafe.SimpleTextAreaTraversal;
import gr.zeus.ui.typesafe.SimpleTextPaneTraversal;
import gr.zeus.ui.typesafe.TypeSafeTextDocumentFilter;
import gr.zeus.ui.typesafe.TypeSafeVerifier;
import java.awt.Component;
import java.awt.Container;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;

public final class SwingConfigurationManager {
    private static final String PROP_CUSTOMFOCUS = "customfocustraversalpolicy";
    private static final String PROP_SIMPLETEXTAREATRAVERSAL = "simpletextareatraversal";
    private static final String PROP_SIMPLETEXTPANETRAVERSAL = "simpletextpanetraversal";
    private static final String PROP_SIMPLEEDITORPANETRAVERSAL = "simpleeditorpanetraversal";
    private static final String PROP_CLASSTYPE = ".classtype";
    private static final String PROP_SELECTALL = ".selectall";
    private static final String PROP_TRIMSPACES = ".trimspaces";
    private static final String PROP_UPPERCASE = ".uppercase";
    private static final String PROP_LOWERCASE = ".lowercase";
    private static final String PROP_MAXCHARS = ".maxchars";
    private static final String PROP_MINCHARS = ".minchars";
    private static final String PROP_VALIDCHARS = ".validchars";
    private static final String PROP_INVALIDCHARS = ".invalidchars";
    private static final String PROP_REPLACABLECHARS = ".replacablechars";
    private static final String PROP_REPLACEDCHARS = ".replacedchars";
    private static final String PROP_DEFAULTSONERROR = ".defaultsonerror";
    private static final String PROP_DEFAULTNUM = ".defaultnum";
    private static final String PROP_MAXNUM = ".maxnum";
    private static final String PROP_MINNUM = ".minnum";
    private static final String PROP_DATEPATTERN = ".datepattern";
    private static final String PROP_DEFAULTDATE = ".defaultdate";
    private Properties m_props = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwingConfigurationManager(String propertyFile) {
        if (propertyFile == null) {
            System.err.println("Initialization failure for: SwingConfigurationManager; null filename!");
            return;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(propertyFile);
            this.m_props.load(fin);
        }
        catch (Exception e) {
            System.err.println("Initialization failure for: SwingConfigurationManager; Failed to load property file: " + propertyFile + " ; " + e.getMessage());
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public SwingConfigurationManager(ResourceBundle res) {
        if (res == null) {
            System.err.println("Initialization failure for: SwingConfigurationManager; null ResourceBundle!");
            return;
        }
        try {
            Enumeration<String> e = res.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                this.m_props.setProperty(key, res.getString(key));
            }
        }
        catch (Exception e) {
            System.err.println("Initialization failure for: SwingConfigurationManager; Failed reading ResourceBundle; " + e.getMessage());
        }
    }

    public void applyFocus(Container c, Component[] all) {
        if (this.get_prop(PROP_CUSTOMFOCUS).equalsIgnoreCase("true")) {
            c.setFocusTraversalPolicy(new CustomFocusTraversalPolicy(all));
        }
        if (all != null) {
            for (int i = 0; i < all.length; ++i) {
                Object trav;
                if (all[i] instanceof JTextArea && this.get_prop(PROP_SIMPLETEXTAREATRAVERSAL).equalsIgnoreCase("true")) {
                    trav = new SimpleTextAreaTraversal((JTextArea)all[i]);
                    ((SimpleTextAreaTraversal)trav).changeTraveralKeys();
                    continue;
                }
                if (all[i] instanceof JTextPane && this.get_prop(PROP_SIMPLETEXTPANETRAVERSAL).equalsIgnoreCase("true")) {
                    trav = new SimpleTextPaneTraversal((JTextPane)all[i]);
                    ((SimpleTextPaneTraversal)trav).changeTraveralKeys();
                    continue;
                }
                if (!(all[i] instanceof JEditorPane) || !this.get_prop(PROP_SIMPLEEDITORPANETRAVERSAL).equalsIgnoreCase("true")) continue;
                trav = new SimpleEditorPaneTraversal((JEditorPane)all[i]);
                ((SimpleEditorPaneTraversal)trav).changeTraveralKeys();
            }
        }
    }

    public void configComponent(String name, JTextComponent ... all) throws Exception {
        for (JTextComponent c : all) {
            this.config_component(name, c);
        }
    }

    private String get_prop(String p) {
        String s = this.m_props.getProperty(p);
        return s != null ? s : "";
    }

    private void config_component(String name, JTextComponent c) throws Exception {
        Class vclass;
        int i;
        String cls = this.get_prop(name + PROP_CLASSTYPE);
        if (cls.length() < 1) {
            cls = "java.lang.String";
        }
        TypeSafeTextDocumentFilter tstdf = new TypeSafeTextDocumentFilter();
        TypeSafeVerifier tsv = new TypeSafeVerifier(Class.forName(cls));
        SelectAllTextOnFocus satof = new SelectAllTextOnFocus();
        if (!(c instanceof JFormattedTextField)) {
            ((AbstractDocument)c.getDocument()).setDocumentFilter(tstdf);
        }
        c.setInputVerifier(tsv);
        c.addFocusListener(satof);
        if (this.get_prop(name + PROP_SELECTALL).equalsIgnoreCase("true")) {
            satof.setEnabled(true);
        } else if (this.get_prop(name + PROP_SELECTALL).equalsIgnoreCase("false")) {
            satof.setEnabled(false);
        }
        if (this.get_prop(name + PROP_TRIMSPACES).equalsIgnoreCase("true")) {
            tsv.setTrimSpaces(true);
        } else if (this.get_prop(name + PROP_TRIMSPACES).equalsIgnoreCase("false")) {
            tsv.setTrimSpaces(false);
        }
        if (this.get_prop(name + PROP_UPPERCASE).equalsIgnoreCase("true")) {
            tstdf.setUpperCase(true);
        } else if (this.get_prop(name + PROP_UPPERCASE).equalsIgnoreCase("false")) {
            tstdf.setUpperCase(false);
        }
        if (this.get_prop(name + PROP_LOWERCASE).equalsIgnoreCase("true")) {
            tstdf.setLowerCase(true);
        } else if (this.get_prop(name + PROP_LOWERCASE).equalsIgnoreCase("false")) {
            tstdf.setLowerCase(false);
        }
        String s = this.get_prop(name + PROP_MAXCHARS);
        if (s.length() > 0) {
            i = Integer.parseInt(s);
            tstdf.setMaxChars(i);
        }
        if ((s = this.get_prop(name + PROP_MINCHARS)).length() > 0) {
            i = Integer.parseInt(s);
            tsv.setMinChars(i);
        }
        if ((s = this.get_prop(name + PROP_VALIDCHARS)).length() > 0) {
            tstdf.setValidChars(s);
        }
        if ((s = this.get_prop(name + PROP_INVALIDCHARS)).length() > 0) {
            tstdf.setInvalidChars(s);
        }
        if ((s = this.get_prop(name + PROP_REPLACABLECHARS)).length() > 0) {
            tstdf.setReplacableChars(s);
        }
        if ((s = this.get_prop(name + PROP_REPLACEDCHARS)).length() > 0) {
            tstdf.setReplacedChars(s);
        }
        if (this.get_prop(name + PROP_DEFAULTSONERROR).equalsIgnoreCase("true")) {
            tsv.setDefaultsOnError(true);
        } else if (this.get_prop(name + PROP_DEFAULTSONERROR).equalsIgnoreCase("false")) {
            tsv.setDefaultsOnError(false);
        }
        s = this.get_prop(name + PROP_DEFAULTNUM);
        if (s.length() > 0 && !(vclass = tsv.getVerifierClassType()).equals(String.class)) {
            if (vclass.equals(Byte.class)) {
                tsv.setDefaultByteValue(Byte.parseByte(s));
            } else if (vclass.equals(Short.class)) {
                tsv.setDefaultShortValue(Short.parseShort(s));
            } else if (vclass.equals(Integer.class)) {
                tsv.setDefaultIntegerValue(Integer.parseInt(s));
            } else if (vclass.equals(Long.class)) {
                tsv.setDefaultLongValue(Long.parseLong(s));
            } else if (vclass.equals(Float.class)) {
                tsv.setDefaultFloatValue(Float.parseFloat(s));
            } else if (vclass.equals(Double.class)) {
                tsv.setDefaultDoubleValue(Double.parseDouble(s));
            }
        }
        if ((s = this.get_prop(name + PROP_MAXNUM)).length() > 0 && !(vclass = tsv.getVerifierClassType()).equals(String.class)) {
            if (vclass.equals(Byte.class)) {
                tsv.setMaxByteValue(Byte.parseByte(s));
            } else if (vclass.equals(Short.class)) {
                tsv.setMaxShortValue(Short.parseShort(s));
            } else if (vclass.equals(Integer.class)) {
                tsv.setMaxIntegerValue(Integer.parseInt(s));
            } else if (vclass.equals(Long.class)) {
                tsv.setMaxLongValue(Long.parseLong(s));
            } else if (vclass.equals(Float.class)) {
                tsv.setMaxFloatValue(Float.parseFloat(s));
            } else if (vclass.equals(Double.class)) {
                tsv.setMaxDoubleValue(Double.parseDouble(s));
            }
        }
        if ((s = this.get_prop(name + PROP_MINNUM)).length() > 0 && !(vclass = tsv.getVerifierClassType()).equals(String.class)) {
            if (vclass.equals(Byte.class)) {
                tsv.setMinByteValue(Byte.parseByte(s));
            } else if (vclass.equals(Short.class)) {
                tsv.setMinShortValue(Short.parseShort(s));
            } else if (vclass.equals(Integer.class)) {
                tsv.setMinIntegerValue(Integer.parseInt(s));
            } else if (vclass.equals(Long.class)) {
                tsv.setMinLongValue(Long.parseLong(s));
            } else if (vclass.equals(Float.class)) {
                tsv.setMinFloatValue(Float.parseFloat(s));
            } else if (vclass.equals(Double.class)) {
                tsv.setMinDoubleValue(Double.parseDouble(s));
            }
        }
        if ((s = this.get_prop(name + PROP_DATEPATTERN)).length() > 0) {
            tsv.setDatePattern(s);
        }
        if ((s = this.get_prop(name + PROP_DEFAULTDATE)).length() > 0) {
            try {
                SimpleDateFormat frm = new SimpleDateFormat(tsv.getDatePattern());
                Date dt = frm.parse(s);
                tsv.setDefaultDateValue(dt);
            }
            catch (Exception e) {
                System.err.println("Configuration failure for: SwingConfigurationManager; defaultdate is invalid!");
            }
        }
    }
}

