---
layout: post
title: Announcing Leaflet 1.0-rc3
description: Leaflet 1.0 Release Candidate 3 is out
author: Yohan Boniface
authorsite: http://yohanboniface.me
---

A regression in the way event listeners were called pushed the Leaflet team to freeze a new release candidate, so here is the third one.


### Bug fixing, bug fixing, bug fixing!

The previous release candidate landed an event refactoring and the new `L.Tooltip` class, and, how bizarre,
almost all the fixes in this release are related to those two changes!

The main regression affected the way Leaflet was calling the event listeners: the order we were calling the listeners was not the same they have been registered.

Before the rc2, Leaflet was handling differently listeners with and without explicit context. The former were always called before the later, no matter the order they were registered, but their order was unpredictable. In the meantime, listeners without explicit context, while always called after the other ones, were called in registration order.

While in the task of refactoring events for rc2, in order to make them faster, we also factorized those pieces of code. But we did it the wrong way!

This third release is then about making all the listeners behave in a predictable way. While this is a clear improvement, it may have side effects in corner cases. So be warry when upgrading!

Nothing more to highlight about this quick fixup release, check the [1.0.0-rc3 changelog](https://github.com/Leaflet/Leaflet/blob/master/CHANGELOG.md#10-rc3-august-3-2016) for the full list of changes.

### Summer hacking

Releasing during summer, while all the team is having a break, has some funny side effects. This release was mainly done while traveling, by train and airplane.
And partly in some small village in Iraq under 53° Celsius!

![Iraq hacking](/docs/images/2016-08-03-iraq-hacking.jpg)

### Get the release candidate

As with previous releases, you can use the CDN:


    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.0.0-rc.3/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.0.0-rc.3/dist/leaflet.js"></script>

A non-minified version of the javascript file is also available at:

    <script src="https://unpkg.com/leaflet@1.0.0-rc.3/dist/leaflet-src.js"></script>

The release is also available through NPM (`npm install leaflet@rc`), [GitHub download](https://github.com/Leaflet/Leaflet/archive/v1.0.0-rc.3.zip), and [CDN download](http://cdn.leafletjs.com/leaflet/v1.0.0-rc.3/leaflet.zip). We discourage using Bower.

Use it, enjoy it, and please report any [issue](https://github.com/Leaflet/Leaflet/issues) to help preparing the final Leaflet 1.0 release!


Best,

The "Leafteam"
