## Example
```
phpQuery::newDocumentFileXHTML('my-xhtml.html')->find('p');
$ul = pq('ul');
```
# Table of Contents
  * [Loading documents](#Loading_documents.md)
  * [pq() function](#pq_function.md)

## Loading documents
  * phpQuery::**newDocument**($html, $contentType = null) Creates new document from markup. If no $contentType, autodetection is made (based on markup). If it fails, text/html in utf-8 is used.
  * phpQuery::**newDocumentFile**($file, $contentType = null) Creates new document from file. Works like newDocument()
  * phpQuery::**newDocumentHTML**($html, $charset = 'utf-8')
  * phpQuery::**newDocumentXHTML**($html, $charset = 'utf-8')
  * phpQuery::**newDocumentXML**($html, $charset = 'utf-8')
  * phpQuery::**newDocumentPHP**($html, $contentType = null) Read more about it on [PHPSupport page](PHPSupport.md)
  * phpQuery::**newDocumentFileHTML**($file, $charset = 'utf-8')
  * phpQuery::**newDocumentFileXHTML**($file, $charset = 'utf-8')
  * phpQuery::**newDocumentFileXML**($file, $charset = 'utf-8')
  * phpQuery::**newDocumentFilePHP**($file, $contentType) Read more about it on [PHPSupport page](PHPSupport.md)
## pq function
**`pq($param, $context = null);`**

**pq();** function is equivalent of jQuery's **$();**. It's used for 3 type of things:
  1. Importing markup
```
// Import into selected document:
// doesn't accept text nodes at beginning of input string
pq('<div/>')
// Import into document with ID from $pq->getDocumentID():
pq('<div/>', $pq->getDocumentID())
// Import into same document as DOMNode belongs to:
pq('<div/>', DOMNode)
// Import into document from phpQuery object:
pq('<div/>', $pq)
```
  1. Running queries
```
// Run query on last selected document:
pq('div.myClass')
// Run query on document with ID from $pq->getDocumentID():
pq('div.myClass', $pq->getDocumentID())
// Run query on same document as DOMNode belongs to and use node(s)as root for query:
pq('div.myClass', DOMNode)
// Run query on document from phpQuery object 
// and use object's stack as root node(s) for query:
pq('div.myClass', $pq)
```
  1. Wrapping DOMNodes with phpQuery objects
```
foreach(pq('li') as $li)
  // $li is pure DOMNode, change it to phpQuery object
  pq($li);
```