# CiviCRM 5.47.0

Released March 4, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add created_date & modified_date to civicrm_relationship
  ([22480](https://github.com/civicrm/civicrm-core/pull/22480))**

  Adds created_date & modified_date to the civicrm_relationship table.

- **Add option to display money tokens without formatting
  ([22548](https://github.com/civicrm/civicrm-core/pull/22548))**

  Adds an option to display money tokens without formatting.

- **SearchKit - Improve field/operator/value selection UI
  ([22604](https://github.com/civicrm/civicrm-core/pull/22604))**

  Improves the SearchKit UI for selecting field/operator/value conditions.
  Affects various parts of the UI, like css conditions, link conditions,
  where/on/having clauses, etc.

- **SearchKit - Support operators in conditional css rules
  ([22552](https://github.com/civicrm/civicrm-core/pull/22552))**

  Allows operators other than = in SearchKit conditional style rules.

- **SearchKit - Allow Smarty in field rewrite
  ([22592](https://github.com/civicrm/civicrm-core/pull/22592))**

  Gives the ability to use Smarty syntax in the "rewrite" of SearchKit displays.

- **SearchKit: Relationship Description unavailable
  ([dev/core#3019](https://lab.civicrm.org/dev/core/-/issues/3019):
  [22606](https://github.com/civicrm/civicrm-core/pull/22606))**

  Exposes relationship description, created/modified_date & permissions fields
  in SearchKit.

- **SearchKit - add/remove tags action for all taggable entities
  ([21865](https://github.com/civicrm/civicrm-core/pull/21865))**

  Adds a new angular-based action to SearchKit for bulk adding/removing tags
  from contacts, cases, activities, etc.

- **SearchKit - Support conditional links
  ([22557](https://github.com/civicrm/civicrm-core/pull/22557))**

  Adds an advanced feature to conditionally show/hide links in a
  links/buttons/menu column, based on user permissions or row values.

- **SearchKit - Update operator labels
  ([22554](https://github.com/civicrm/civicrm-core/pull/22554))**

  Updates SearchKit labels to hopefully better describe ReGex.

- **SearchKit - Enable joins for custom fields and option groups
  ([22355](https://github.com/civicrm/civicrm-core/pull/22355))**

  Enables SearchKit to join custom groups to custom fields, and option groups to
  option values.

- **APIv4 - Add SubscriptionHistory entity
  ([22435](https://github.com/civicrm/civicrm-core/pull/22435))**

  Adds a SubscriptionHistory entity to APIv4.

- **APIv4 - Make Permission 'group' discoverable in API Explorer
  ([22559](https://github.com/civicrm/civicrm-core/pull/22559))**

  Makes `group` options for the `Permission` API discoverable.

- **Improve field accessibility in legacycustomsearches
  ([22710](https://github.com/civicrm/civicrm-core/pull/22710))**

  Improves accessibility of legacy custom searches.

- **Expose a REST end-point through standard routing (Work Towards
  [dev/core#2077](https://lab.civicrm.org/dev/core/-/issues/2077):
  [19727](https://github.com/civicrm/civicrm-core/pull/19727) and
  [22058](https://github.com/civicrm/civicrm-core/pull/22058))**

  Makes 'civicrm/ajax/rest' interoperable with 'extern/rest.php' parameters and
  adds an AuthX configuration screen.

- **Define more usable queue DX for multithreaded background work (Work Towards
  [dev/core#1304](https://lab.civicrm.org/dev/core/-/issues/1304):
  [22324](https://github.com/civicrm/civicrm-core/pull/22324) and
  [22657](https://github.com/civicrm/civicrm-core/pull/22657))**

  Adds a high-level queue tracking table and updates the programmatic APIs to
  make it easier to work with persistent queues.

- **Civi::pipe - Add support for background worker-processes with JSON pipes
  ([22262](https://github.com/civicrm/civicrm-core/pull/22262))**

  Add an entry-point for external scripts to send multiple API calls to a
  CiviCRM worker-process - while only bootstrapping one time.

- **Expose email on hold as filter for reports (Work towards
  [dev/core#3012](https://lab.civicrm.org/dev/core/-/issues/3012):
  [22368](https://github.com/civicrm/civicrm-core/pull/22368) and
  [22572](https://github.com/civicrm/civicrm-core/pull/22572))**

  Exposes email on hold as filter on contribution reports.

- **Extensions - Add dependency status check
  ([22464](https://github.com/civicrm/civicrm-core/pull/22464))**

  Adds a system status check to ensure extension dependencies are met, and warn
  the admin of missing dependencies.

- **Add metadata so Activity Created Date is available in Form Builder
  ([22320](https://github.com/civicrm/civicrm-core/pull/22320))**

  Makes the Activity Created date available in Form Builder.

- **Move permission access handling for
  civicrm/admin/financial/financialType?reset=1 to extension
  ([22685](https://github.com/civicrm/civicrm-core/pull/22685) and
  [22499](https://github.com/civicrm/civicrm-core/pull/22499))**

  Moves permission access handling for
  civicrm/admin/financial/financialType?reset=1 to extension.

- **Add setting "format_locale"
  ([dev/core#3095](https://lab.civicrm.org/dev/core/-/issues/3095):
  [22885](https://github.com/civicrm/civicrm-core/pull/22885))**

  Adds a new setting, "Formatting Locale", which specifies that dates and
  numbers should formatted according to designated localization rules.
  This setting may be useful for a locale (eg `en_NZ`) whose language closely
  resembles another (eg `en_US`) but which has a different currency.

### CiviContribute

- **Why are unique labels for price fields required?
  ([dev/event#66](https://lab.civicrm.org/dev/event/-/issues/66):
  [22508](https://github.com/civicrm/civicrm-core/pull/22508))**

  Makes it so duplicate price field labels are allowed.

- **Use tokens in offline contribution receipt (new installs)
  ([22560](https://github.com/civicrm/civicrm-core/pull/22560))**

  Use tokens instead of Smarty Variables in the offline contribution receipt
  template for new installs.

### CiviEvent

- **Event Registration: allow default Price Set values from the URL
  ([22313](https://github.com/civicrm/civicrm-core/pull/22313))**

  Makes it so one can set the default price field on event registration forms
  using URL parameters.

- **Account for time zone on event registration pages
  ([dev/core#2122](https://lab.civicrm.org/dev/core/-/issues/2122):
  [22620](https://github.com/civicrm/civicrm-core/pull/22620),
  [22622](https://github.com/civicrm/civicrm-core/pull/22622),
  [20476](https://github.com/civicrm/civicrm-core/pull/20476),
  [22619](https://github.com/civicrm/civicrm-core/pull/22619),
  [22645](https://github.com/civicrm/civicrm-core/pull/22645) and
  [22644](https://github.com/civicrm/civicrm-core/pull/22644))**

  Adds timezone support for events.

- **updating misleading labels on buttons to confirmation pages
  ([dev/core#1613](dev/core#1613):
  [20251](https://github.com/civicrm/civicrm-core/pull/20251))**

  Changes the event registration button text based on if there are additional
  participants.

### CiviGrant

- **CiviGrant - Use SearchKit for contact summary tab
  ([22467](https://github.com/civicrm/civicrm-core/pull/22467))**

  switches the Grants tab on the contact summary page to use a SearchKit Display.
  It looks nearly identical before and after, but is now easily customizable via
  the SearchKit & Form-Builder GUI.

- **Migrate CiviGrant component to an extension
  ([22064](https://github.com/civicrm/civicrm-core/pull/22064))**

  Moves the CiviGrant component to an extension.

### CiviMail

- **Start phasing out 'preferred_mail_format' (Work towards
  [dev/core#2866](https://lab.civicrm.org/dev/core/-/issues/2866):
  [22634](https://github.com/civicrm/civicrm-core/pull/22634) and
  [22632](https://github.com/civicrm/civicrm-core/pull/22632))**

  Generates text version of message at send time if one is not present.

### WordPress Integration

- **wp-cli/civicrm.php - Add 'civicrm pipe' subcommand
  ([270](https://github.com/civicrm/civicrm-wordpress/pull/270))**

  Adds support for subcommand `wp civicrm pipe`.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Only format Smarty aliases as money if specified
  ([22547](https://github.com/civicrm/civicrm-core/pull/22547))**

- **Avoid PHP notices on activity form
  ([22666](https://github.com/civicrm/civicrm-core/pull/22666))**

- **Fix typo preventing uninstalling ckeditor4
  ([22691](https://github.com/civicrm/civicrm-core/pull/22691))**

- **Fix return values for APIv3 Job.delete
  ([22561](https://github.com/civicrm/civicrm-core/pull/22561))**

- **enforce required fields on Contact.duplicatecheck
  ([22741](https://github.com/civicrm/civicrm-core/pull/22741))**

- **APIv4 SortableEntity - Fix sorting custom fields with option groups
  ([22716](https://github.com/civicrm/civicrm-core/pull/22716))**

- **APIv4 - Correctly return date-only custom field values without the time
  ([22649](https://github.com/civicrm/civicrm-core/pull/22649))**

- **APIv4 - Use empty string instead of 'null' to pass null values to the db
  ([22587](https://github.com/civicrm/civicrm-core/pull/22587))**

- **APIv4 - Fix incorrect placement of decodeRows in loop
  ([22413](https://github.com/civicrm/civicrm-core/pull/22413))**

- **SearchKit: In-place edit for custom dropdown field - can't blank it out
  ([dev/report#92](https://lab.civicrm.org/dev/report/-/issues/92):
  [22358](https://github.com/civicrm/civicrm-core/pull/22358))**

- **Minor SearchKit UI filtering annoyance
  ([dev/core#3032](https://lab.civicrm.org/dev/core/-/issues/3032):
  [22505](https://github.com/civicrm/civicrm-core/pull/22505))**

- **SearchKit - Fix selecting operators and values in clauses
  ([22653](https://github.com/civicrm/civicrm-core/pull/22653))**

- **SearchKit - Refresh contents after saving a popup when in a block/tab
  ([22809](https://github.com/civicrm/civicrm-core/pull/22809))**

- **Don't throw PHP notice when rendering dedupefind template.
  ([22709](https://github.com/civicrm/civicrm-core/pull/22709))**

- **Enotice fixes with datepicker
  ([22705](https://github.com/civicrm/civicrm-core/pull/22705))**

- **Enotice fix with priceset template
  ([22708](https://github.com/civicrm/civicrm-core/pull/22708))**

- **Enotice fixes
  ([22697](https://github.com/civicrm/civicrm-core/pull/22697))**

- **Enotice fix
  ([22436](https://github.com/civicrm/civicrm-core/pull/22436))**

- **Enotice fixes
  ([22471](https://github.com/civicrm/civicrm-core/pull/22471))**

- **CustomGroup - Ensure 'name' is always unique
  ([22675](https://github.com/civicrm/civicrm-core/pull/22675))**

- **Another set of PHPdoc corrections
  ([22658](https://github.com/civicrm/civicrm-core/pull/22658))**

- **Fix batch summary to use the api
  ([22618](https://github.com/civicrm/civicrm-core/pull/22618))**

- **Fix Smarty notices in footer files
  ([22613](https://github.com/civicrm/civicrm-core/pull/22613))**

- **Remove use of .font-size11pt and .font-size12pt
  ([22314](https://github.com/civicrm/civicrm-core/pull/22314))**

- **Don't pass redundent empty strings when instantiating
  CRM_Core_ShowHideBlocks
  ([22605](https://github.com/civicrm/civicrm-core/pull/22605))**

- **Fix call to log method warn (should be warning)
  ([22602](https://github.com/civicrm/civicrm-core/pull/22602))**

- **tpl notices and docblocks
  ([22449](https://github.com/civicrm/civicrm-core/pull/22449))**

- **Ensure assigned Smarty array has empty keys (not no keys)
  ([22379](https://github.com/civicrm/civicrm-core/pull/22379))**

- **Stop calling hook twice
  ([22404](https://github.com/civicrm/civicrm-core/pull/22404))**

- **Activity Details field on batch update via profile has wrong fieldname
  ([22568](https://github.com/civicrm/civicrm-core/pull/22568))**

- **Re-fix enotice on searchType to work with default modifiers
  ([22466](https://github.com/civicrm/civicrm-core/pull/22466))**

- **Unable to add new custom field set or new fields (to existing field set)
  after enabling multilingual setting.
  ([dev/translation#38](https://lab.civicrm.org/dev/translation/-/issues/38):
  [22647](https://github.com/civicrm/civicrm-core/pull/22647))**

- **System.check permissions changed in Civi 5.46
  ([dev/core#3055](https://lab.civicrm.org/dev/core/-/issues/3055):
  [22733](https://github.com/civicrm/civicrm-core/pull/22733))**

  Fixes the dedupe check to not require elevated permissions.

- **Search Builder crashes if you have admin access and CiviGrant is not enabled
  ([dev/core#3056](https://lab.civicrm.org/dev/core/-/issues/3056):
  [22714](https://github.com/civicrm/civicrm-core/pull/22714))**

- **CiviGrant info.xml update missing from 5.47 and
  CRM_Utils_VersioncheckTest::testGetSiteStats should have been failing for a
  while ([dev/core#3057](https://lab.civicrm.org/dev/core/-/issues/3057):
  [22717](https://github.com/civicrm/civicrm-core/pull/22717))**

- **Regression - fatal error when viewing custom fields with money > 1000
  ([dev/core#3059](https://lab.civicrm.org/dev/core/-/issues/3059):
  [22727](https://github.com/civicrm/civicrm-core/pull/22727))**

- **Fix broken function reference
  ([22474](https://github.com/civicrm/civicrm-core/pull/22474))**

- **Use rolling window for translating 2-digit years into 4-digit years
  ([22581](https://github.com/civicrm/civicrm-core/pull/22581))**

  Fixes outdated hard-coded import logic: translates 2-digit years to 4 using
  rolling -95yr to +5yr window

- **Rationalise relationship validation
  ([22491](https://github.com/civicrm/civicrm-core/pull/22491))**

- **Stop calling confusing function that doesn't do much .....
  ([22468](https://github.com/civicrm/civicrm-core/pull/22468))**

- **Navigation - Make required fields NOT NULL
  ([22430](https://github.com/civicrm/civicrm-core/pull/22430))**

- **Fight back against copy & paste gone wild
  ([22417](https://github.com/civicrm/civicrm-core/pull/22417))**

### CiviCampaign

- **'CiviCampaign: access CiviCampaign' permission missing
  ([dev/core#983](https://lab.civicrm.org/dev/core/-/issues/983):
  [22459](https://github.com/civicrm/civicrm-core/pull/22459))**

### CiviCase

- **CiviCase - Denote `created_date` as readonly
  ([22608](https://github.com/civicrm/civicrm-core/pull/22608))**

- **Remove category from case activity template
  ([22530](https://github.com/civicrm/civicrm-core/pull/22530))**

  Remove category from case activity template to fix e-notices.

### CiviContribute

- **Fix ContributionRecur.payment_processor_id pseudoconstant
  ([22750](https://github.com/civicrm/civicrm-core/pull/22750))**

- **Manage Contribution page, the link to "Online Contribution (Test-drive)" is
  an admin-only URL to register in the backend, should be a frontend URL
  ([22672](https://github.com/civicrm/civicrm-core/pull/22672))**

- **Avoid PHP notice on 'Manage Contribution Pages' screen
  ([22661](https://github.com/civicrm/civicrm-core/pull/22661))**

- **PCP is still active after contribution page is disabled.
  ([dev/core#899](https://lab.civicrm.org/dev/core/-/issues/899):
  [20845](https://github.com/civicrm/civicrm-core/pull/20845))**

- **don't allow multiple currencies in a batch
  ([20884](https://github.com/civicrm/civicrm-core/pull/20884))**

- **Foreign constraint violation on APIv3 contribution create if
  financial_type_id is numeric
  ([dev/core#3063](https://lab.civicrm.org/dev/core/-/issues/3063):
  [22740](https://github.com/civicrm/civicrm-core/pull/22740))**

- **Error cancelling a contribution if CiviPledge is disabled
  ([dev/core#3066](https://lab.civicrm.org/dev/core/-/issues/3066):
  [22779](https://github.com/civicrm/civicrm-core/pull/22779))**

- **Import of contribution fails when invalid campaign ID is provided
  ([dev/core#2989](https://lab.civicrm.org/dev/core/-/issues/2989):
  [22235](https://github.com/civicrm/civicrm-core/pull/22235))**

- **Simplify getting contact_id from recurring contribution when generating
  subscription URLs
  ([22448](https://github.com/civicrm/civicrm-core/pull/22448))**

- **Fix Fatal Error on contribution tab and user dashboard when recurring
  payment generated using extension get disabled
  ([22264](https://github.com/civicrm/civicrm-core/pull/22264))**

### CiviEvent

- **CiviCRM Event, the link to "On-line Registration (Test Drive)" is an
  admin-only URL to register in the backend, should be a frontend URL
  ([22669](https://github.com/civicrm/civicrm-core/pull/22669))**

- **Set default values to avoid notices when rendering (event templates screen)
  ([22663](https://github.com/civicrm/civicrm-core/pull/22663))**

### CiviGrant

- **Fix Grant::retrieve to meet full phpcs standard
  ([22558](https://github.com/civicrm/civicrm-core/pull/22558))**

- **CiviGrant - Fix installation of dependencies during upgrade
  ([22881](https://github.com/civicrm/civicrm-core/pull/22881))**

- **CiviGrant - Menu appears twice
  ([dev/core#3087](https://lab.civicrm.org/dev/core/-/issues/3087):
  [22855](https://github.com/civicrm/civicrm-core/pull/22855))**

- **CiviGrant - Don't return grant fields as contact fields
  ([dev/core#3069](https://lab.civicrm.org/dev/core/-/issues/3069):
  [22851](https://github.com/civicrm/civicrm-core/pull/22851))**

- **CiviGrant - Declare API permissions
  ([22791](https://github.com/civicrm/civicrm-core/pull/22791))**

### CiviMail

- **Editing a mailing triggers two autosaves instead of one
  ([dev/core#2587](https://lab.civicrm.org/dev/core/-/issues/2587):
  [20561](https://github.com/civicrm/civicrm-core/pull/20561))**

- **MailingEventQueue - Use consistent CamelCaseName. Prevent conflicts.
  ([22343](https://github.com/civicrm/civicrm-core/pull/22343))**

- **add `contact_id` to email params in `emailLetter` function
  ([22538](https://github.com/civicrm/civicrm-core/pull/22538))**

- **Fix syntax error in CRM_Mailing_Event_BAO_Reply
  ([22453](https://github.com/civicrm/civicrm-core/pull/22453))**

- **Smarty notice fix on Email help
  ([22470](https://github.com/civicrm/civicrm-core/pull/22470))**

- **CiviMail - Fix undeclared Javascript variables ([22879](https://github.com/civicrm/civicrm-core/pull/22879))**

### CiviMember

- **Fix spelling mistake in function name, addMembershipToRealtedContacts should
  be addMembershipToRelatedContacts
  ([22673](https://github.com/civicrm/civicrm-core/pull/22673))**

- **Fix Smarty notices in membership dashboard
  ([22660](https://github.com/civicrm/civicrm-core/pull/22660))**

- **Don't default membership type create to inactive
  ([22498](https://github.com/civicrm/civicrm-core/pull/22498))**

### WordPress Integration

- **404 Error when I use the APIv4 with WordPress Multisite -> because no "do
  not delete" post was generated for the subsite
  ([dev/wordpress#59](https://lab.civicrm.org/dev/wordpress/-/issues/59):
  [271](https://github.com/civicrm/civicrm-wordpress/pull/271))**

## <a name="misc"></a>Miscellany

- **Move permission checks from Query & BAO to financialacl extension
  ([22495](https://github.com/civicrm/civicrm-core/pull/22495))**

- **Add billingStateProvince and standardized property names
  ([21583](https://github.com/civicrm/civicrm-core/pull/21583))**

- **Extensions - Revise prose for status check
  ([22638](https://github.com/civicrm/civicrm-core/pull/22638))**

- **Add type to phpdoc comment for report statistic function
  ([22514](https://github.com/civicrm/civicrm-core/pull/22514))**

- **Update phpdoc references to $self to include type
  ([22513](https://github.com/civicrm/civicrm-core/pull/22513))**

- **Improve method phpdoc for CRM_Utils_System
  ([22492](https://github.com/civicrm/civicrm-core/pull/22492))**

- **Run 'full Drupal strictness' standard over api/v3/examples
  ([22528](https://github.com/civicrm/civicrm-core/pull/22528))**

- **Run stricter phpcs on Civi dir
  ([22527](https://github.com/civicrm/civicrm-core/pull/22527))**

- **Fixes to spaces from phpcs
  ([22535](https://github.com/civicrm/civicrm-core/pull/22535))**

- **Various phpdoc fixes
  ([22509](https://github.com/civicrm/civicrm-core/pull/22509))**

- **Clarify contents of ids for further fixes
  ([22402](https://github.com/civicrm/civicrm-core/pull/22402))**

- **Replace all isset checks on line.tax_rate
  ([22421](https://github.com/civicrm/civicrm-core/pull/22421))**

- **Move function to the class that 'owns' it
  ([22472](https://github.com/civicrm/civicrm-core/pull/22472))**

- **PHPCS standards on css....
  ([22529](https://github.com/civicrm/civicrm-core/pull/22529))**

- **More comments & style fixes
  ([22533](https://github.com/civicrm/civicrm-core/pull/22533))**

- **Re-run regen
  ([22536](https://github.com/civicrm/civicrm-core/pull/22536))**

- **Add consistency between checkTemplateFileExists functions,
  ([22586](https://github.com/civicrm/civicrm-core/pull/22586))**

- **Increase GroupContact:create deprecation
  ([22416](https://github.com/civicrm/civicrm-core/pull/22416))**

- **APIv4 - Docblock updates, mark BAO::create functions deprecated
  ([22415](https://github.com/civicrm/civicrm-core/pull/22415))**

- **DAO - Centralize logic to derive unique name from label
  ([22570](https://github.com/civicrm/civicrm-core/pull/22570))**

- **Pass remove-by-reference
  ([22593](https://github.com/civicrm/civicrm-core/pull/22593))**

- **Mark function as private
  ([22457](https://github.com/civicrm/civicrm-core/pull/22457))**

- **Stop returning unused parameters
  ([22410](https://github.com/civicrm/civicrm-core/pull/22410))**

- **Duplicate function from deprecated utils onto calling classes & remove
  ([22481](https://github.com/civicrm/civicrm-core/pull/22481))**

- **Fix phpdoc types for $_query in CRM_Core_Selector_Base subclasses
  ([22424](https://github.com/civicrm/civicrm-core/pull/22424))**

- **Correctly document types for class consts
  ([22659](https://github.com/civicrm/civicrm-core/pull/22659))**

- **Make phpType definitions in generated DAO objects more accurate.
  ([22607](https://github.com/civicrm/civicrm-core/pull/22607))**

- **Ensure all APIv3 functions have documented types
  ([22674](https://github.com/civicrm/civicrm-core/pull/22674))**

- **CRM_Core_Component (et al) - Deprecate unused functions
  ([22566](https://github.com/civicrm/civicrm-core/pull/22566))**

- **Move deprecated function back to the only class that calls it
  ([22517](https://github.com/civicrm/civicrm-core/pull/22517))**

- **Fix PHP comments
  ([22526](https://github.com/civicrm/civicrm-core/pull/22526))**

- **A whole bunch of phpdoc fixes
  ([22454](https://github.com/civicrm/civicrm-core/pull/22454))**

- **Another set of PHPDoc fixes
  ([22522](https://github.com/civicrm/civicrm-core/pull/22522))**

- **Fix more phpdoc comments in member links functions
  ([22521](https://github.com/civicrm/civicrm-core/pull/22521))**

- **Fix PHP comments
  ([22515](https://github.com/civicrm/civicrm-core/pull/22515))**

- **Merge function back into parent function
  ([22516](https://github.com/civicrm/civicrm-core/pull/22516))**

- **Simplify variables pass in & out of function
  ([22439](https://github.com/civicrm/civicrm-core/pull/22439))**

- **Clean up input and outputs
  ([22440](https://github.com/civicrm/civicrm-core/pull/22440))**

- **Tidy CRM_Report_Page_Options code
  ([22432](https://github.com/civicrm/civicrm-core/pull/22432))**

- **Refactor buildPremiumPreviewBlock function to make intended usage clearer
  ([22541](https://github.com/civicrm/civicrm-core/pull/22541))**

- **Fix class references in phpdoc comments
  ([22434](https://github.com/civicrm/civicrm-core/pull/22434))**

- **Contact BAO - Deprecate unused function
  ([22610](https://github.com/civicrm/civicrm-core/pull/22610))**

- **report cleanup - no functional change
  ([22611](https://github.com/civicrm/civicrm-core/pull/22611))**

- **Split View Relationship tpl ito own file
  ([22617](https://github.com/civicrm/civicrm-core/pull/22617))**

- **Fix inaccuracy in docblock for method calculateBaseScheduleDate
  ([22631](https://github.com/civicrm/civicrm-core/pull/22631))**

- **Resolve inaccuracies in CRM_Core_BAO_File::attachmentInfo docblock
  ([22629](https://github.com/civicrm/civicrm-core/pull/22629))**

- **Tidy up functions related to printing.
  ([22601](https://github.com/civicrm/civicrm-core/pull/22601))**

- **Do not pass in tablename
  ([22625](https://github.com/civicrm/civicrm-core/pull/22625))**

- **More phpcbs code cleanups
  ([22551](https://github.com/civicrm/civicrm-core/pull/22551))**

- **Resolve docblock inaccuracy in CRM_Contribute_Form_Task_TaskTrait
  ([22646](https://github.com/civicrm/civicrm-core/pull/22646))**

- **Contributor key: Add Ian Wilson
  ([22781](https://github.com/civicrm/civicrm-core/pull/22781))**

- **Bump follow-redirects from 1.11.0 to 1.14.7
  ([22696](https://github.com/civicrm/civicrm-core/pull/22696))**

- **Bump engine.io from 4.1.1 to 4.1.2
  ([22695](https://github.com/civicrm/civicrm-core/pull/22695))**

- **Bump ansi-regex from 5.0.0 to 5.0.1
  ([22693](https://github.com/civicrm/civicrm-core/pull/22693))**

- **Bump log4js from 6.3.0 to 6.4.1
  ([22694](https://github.com/civicrm/civicrm-core/pull/22694))**

- **Update composer.json for composer 2.2 allow-plugins
  ([22692](https://github.com/civicrm/civicrm-core/pull/22692))**

- **Follow up fn removal
  ([22556](https://github.com/civicrm/civicrm-core/pull/22556))**

- **Fully remove contactAB function
  ([22485](https://github.com/civicrm/civicrm-core/pull/22485))**

- **Remove support for deprecated key
  ([22443](https://github.com/civicrm/civicrm-core/pull/22443))**

- **Remove duplicate file
  ([22569](https://github.com/civicrm/civicrm-core/pull/22569))**

- **Remove obsolete scripts
  ([22549](https://github.com/civicrm/civicrm-core/pull/22549))**

- **Remove method getWordReplacement.
  ([22577](https://github.com/civicrm/civicrm-core/pull/22577))**

- **Remove unused variable
  ([22545](https://github.com/civicrm/civicrm-core/pull/22545))**

- **Remove some old scripts
  ([22534](https://github.com/civicrm/civicrm-core/pull/22534))**

- **Remove handling for impossible array
  ([22494](https://github.com/civicrm/civicrm-core/pull/22494))**

- **Remove obsolete postIPN script
  ([22550](https://github.com/civicrm/civicrm-core/pull/22550))**

- **Remove / deprecate case param handling
  ([22420](https://github.com/civicrm/civicrm-core/pull/22420))**

- **Remove useless function
  ([22585](https://github.com/civicrm/civicrm-core/pull/22585))**

- **Remove param default
  ([22590](https://github.com/civicrm/civicrm-core/pull/22590))**

- **Remove htmlFile validation rule, as it can't possibly work.
  ([22425](https://github.com/civicrm/civicrm-core/pull/22425))**

- **Remove broken script
  ([22473](https://github.com/civicrm/civicrm-core/pull/22473))**

- **Remove unreachable else
  ([22406](https://github.com/civicrm/civicrm-core/pull/22406))**

- **Remove & deprecate silly function
  ([22456](https://github.com/civicrm/civicrm-core/pull/22456))**

- **Remove always-true-if
  ([22486](https://github.com/civicrm/civicrm-core/pull/22486))**

- **Remove seemingly unreachable help text
  ([22469](https://github.com/civicrm/civicrm-core/pull/22469))**

- **Remove unused variable
  ([22462](https://github.com/civicrm/civicrm-core/pull/22462))**

- **Remove IF that only loops through one value
  ([22455](https://github.com/civicrm/civicrm-core/pull/22455))**

- **Remove if & foreach that no longer do anything
  ([22447](https://github.com/civicrm/civicrm-core/pull/22447))**

- **Remove call to PHP 4 function
  ([22446](https://github.com/civicrm/civicrm-core/pull/22446))**

- **Remove empty check
  ([22444](https://github.com/civicrm/civicrm-core/pull/22444))**

- **Remove unreachable, nonsensical code
  ([22518](https://github.com/civicrm/civicrm-core/pull/22518))**

- **Remove deprecated code
  ([22411](https://github.com/civicrm/civicrm-core/pull/22411))**

- **Remove check for contact_check as it is always an array here
  ([22407](https://github.com/civicrm/civicrm-core/pull/22407))**

- **Remove unreachable code
  ([22594](https://github.com/civicrm/civicrm-core/pull/22594))**

- **Remove unnecessary pass-by-ref
  ([22397](https://github.com/civicrm/civicrm-core/pull/22397))**

- **Remove always-true IF
  ([22399](https://github.com/civicrm/civicrm-core/pull/22399))**

- **Remove deprecated language construct
  ([22627](https://github.com/civicrm/civicrm-core/pull/22627))**

- **Remove isset from online contribution receipt
  ([22615](https://github.com/civicrm/civicrm-core/pull/22615))**

- **Remove unused invalidProfiles variable, and simplify template.
  ([22704](https://github.com/civicrm/civicrm-core/pull/22704))**

- **(REF) Switch to using new `CRM_Core_Component::isEnabled()`
  ([22687](https://github.com/civicrm/civicrm-core/pull/22687))**

- **(REF) Remove unused variable
  ([22398](https://github.com/civicrm/civicrm-core/pull/22398))**

- **(REF) Tidy up group.tpl
  ([22668](https://github.com/civicrm/civicrm-core/pull/22668))**

- **(REF) Switch OptionGroup BAO to use new centralized logic to make name from
  title ([22654](https://github.com/civicrm/civicrm-core/pull/22654))**

- **(REF) Rename variable to be meaningful
  ([22431](https://github.com/civicrm/civicrm-core/pull/22431))**

- **(REF) Improve APIv4 save functions
  ([22403](https://github.com/civicrm/civicrm-core/pull/22403))**

- **(REF) CRM_Core_Resources - Limit visibility of `getEntityRefMetadata`
  ([22511](https://github.com/civicrm/civicrm-core/pull/22511))**

- **(REF) ContactUtils - Rename local variables
  ([22510](https://github.com/civicrm/civicrm-core/pull/22510))**

- **(REF) CoreResources - Simplify disabled component check
  ([22506](https://github.com/civicrm/civicrm-core/pull/22506))**

- **(REF) Remove constructors that do nothing
  ([22544](https://github.com/civicrm/civicrm-core/pull/22544))**

- **(REF) Extract function `CRM_Core_Component::isEnabled()`
  ([22567](https://github.com/civicrm/civicrm-core/pull/22567))**

- **(REF) SearchKit docblock cleanup
  ([22603](https://github.com/civicrm/civicrm-core/pull/22603))**

- **(REF) SearchKit - Function extraction
  ([22598](https://github.com/civicrm/civicrm-core/pull/22598))**

- **(REF) SearchKit - Simplify import/export popup code
  ([22507](https://github.com/civicrm/civicrm-core/pull/22507))**

- **(REF) Upgrade jQuery UI to 1.13.0
  ([22576](https://github.com/civicrm/civicrm-core/pull/22576))**

- **(REF) Components - Use extracted function
  ([22573](https://github.com/civicrm/civicrm-core/pull/22573))**

- **(REF) SavedSearch - Deprecate/remove redundant/unused functions
  ([22542](https://github.com/civicrm/civicrm-core/pull/22542))**

- **(REF) Use CRM_Contact_BAO_ContactType::basicTypes()
  ([22520](https://github.com/civicrm/civicrm-core/pull/22520))**

- **(REF) Remove unused _colours property
  ([22525](https://github.com/civicrm/civicrm-core/pull/22525))**

- **(REF) Tidy up formatting in gotv.tpl, remove extra </div>
  ([22433](https://github.com/civicrm/civicrm-core/pull/22433))**

- **(REF) Stop returning unused variables
  ([22401](https://github.com/civicrm/civicrm-core/pull/22401))**

- **(REF) Centralize BAO handling of custom data
  ([22426](https://github.com/civicrm/civicrm-core/pull/22426))**

- **(REF) Remove handling for no organization being passed
  ([22395](https://github.com/civicrm/civicrm-core/pull/22395))**

- **(REF) APIv4 - Rename trait 'SoftDelete' to 'SoftDeleteEntity'
  ([22662](https://github.com/civicrm/civicrm-core/pull/22662))**

- **(REF) Cleanup Contact BAO variables
  ([22609](https://github.com/civicrm/civicrm-core/pull/22609))**

- **(REF) Queues - Expand docblocks. Extract SQL trait.
  ([22681](https://github.com/civicrm/civicrm-core/pull/22681))**

- **(REF) APIv4 - Deprecate and stop using PreSaveSubscriber
  ([22648](https://github.com/civicrm/civicrm-core/pull/22648))**

- **(REF) CustomField Admin - Decouple page code from form code
  ([22519](https://github.com/civicrm/civicrm-core/pull/22519))**

- **(NFC) Fix typo in docblock
  ([22409](https://github.com/civicrm/civicrm-core/pull/22409))**

- **(NFC) Tidy up phpdoc in CRM_Utils_QueryFormatter
  ([22423](https://github.com/civicrm/civicrm-core/pull/22423))**

- **(NFC) Update test example template and regenerate examples
  ([22531](https://github.com/civicrm/civicrm-core/pull/22531))**

- **(NFC) Correct type hints for bad null default values
  ([22600](https://github.com/civicrm/civicrm-core/pull/22600))**

- **(NFC) Minor phpdoc fixes to
  CRM_Mailing_Event_BAO_Unsubscribe::send_unsub_response
  ([22574](https://github.com/civicrm/civicrm-core/pull/22574))**

- **(NFC) CiviReport, etal - More phpdoc fixes
  ([22565](https://github.com/civicrm/civicrm-core/pull/22565))**

- **(NFC) Minor amends to getGroupByFromSelectColumns
  ([22575](https://github.com/civicrm/civicrm-core/pull/22575))**

- **(NFC) Correctly document CRM_Utils_Hook::pre to allow null ID
  ([22562](https://github.com/civicrm/civicrm-core/pull/22562))**

- **(NFC) Update PHPDoc for alterDeferredRevenueItems
  ([22563](https://github.com/civicrm/civicrm-core/pull/22563))**

- **(NFC) Comment fixes Stricter phpcs
  ([22555](https://github.com/civicrm/civicrm-core/pull/22555))**

- **(NFC) Remaining css phpcs fixes
  ([22553](https://github.com/civicrm/civicrm-core/pull/22553))**

- **(NFC) Fixes to the type definitions for contactType methods
  ([22524](https://github.com/civicrm/civicrm-core/pull/22524))**

- **(NFC) Civi::pipe - Swap various quotes
  ([22503](https://github.com/civicrm/civicrm-core/pull/22503))**

- **NFC: Clean up description for alterDisplayName hook
  ([22501](https://github.com/civicrm/civicrm-core/pull/22501))**

- **(NFC) Membership Tests - Update assertions to match behavior circa leap-day
  ([22871](https://github.com/civicrm/civicrm-core/pull/22871))**

- **(NFC) Update Contribution Recur DAO following regen
  ([22858](https://github.com/civicrm/civicrm-core/pull/22858))**

- **(NFC) RestTest - Skip testNotCMSUser_q when it's not supported
  ([22817](https://github.com/civicrm/civicrm-core/pull/22817))**

- **APIv4 - Fix test
  ([22414](https://github.com/civicrm/civicrm-core/pull/22414))**

- **Test cleanup - remove direct calls to BAO_Membership::add
  ([22497](https://github.com/civicrm/civicrm-core/pull/22497))**

- **Unit tests for 22429 and apply same treatment to other money format
  functions ([22442](https://github.com/civicrm/civicrm-core/pull/22442))**

- **Simplify APIv4 conformance test
  ([22579](https://github.com/civicrm/civicrm-core/pull/22579))**

- **Add unit test on updateGreeting & remove deprecated fn call
  ([22482](https://github.com/civicrm/civicrm-core/pull/22482))**

- **[test] - Add test coverage for adjusting custom group weights
  ([22512](https://github.com/civicrm/civicrm-core/pull/22512))**

- **Fix testMultipleMembershipsContribution to use order api
  ([22274](https://github.com/civicrm/civicrm-core/pull/22274))**

- **Port test form earlier PR
  ([22502](https://github.com/civicrm/civicrm-core/pull/22502))**

- **Test for APIv4 contact delete bug
  ([dev/core#2757](https://lab.civicrm.org/dev/core/-/issues/2757):
  [22458](https://github.com/civicrm/civicrm-core/pull/22458))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Francis Whittle, Justin Freeman;
BrightMinded Ltd - Bradley Taylor; Christian Wach; CiviCoop - Klaas Eikelboom;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC -
Mathieu Lutfy; Dave D; Freeform Solutions - Herb van den Dool; Jens Schuppe; JMA
Consulting - Seamus Lee; Joinery - Allen Shaw; Lemniscus - Noah Miller;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
PERORA SRL - Samuele Masetto; Registered Nurses' Association of Ontario - Ian
Wilson; Romain Thouvenin; Skvare - Sunil Pawar; Third Sector Design - Kurund
Jalmi; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Andy Burns; Artful Robot - Rich Lott; Betty Dolfing; Blackfly Solutions - Alan
Dixon; Circle Interactive - Pradeep Nayak; CiviCoop - Jaap Jansma; Coop
SymbioTIC - Shane Bill; Fuzion - Luke Stewart; in2part; JMA Consulting - Joe
Murray, Monish Deb; Korlon - Stuart Gaston; Mikey O'Toole; Peter Boling; Tadpole
Collective - Kevin Cristiano; Wildsight - Lars Sanders-Green
