# CiviCRM 5.18.0

Released October 2, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Enable view/revert delete action for detail logging
  ([15045](https://github.com/civicrm/civicrm-core/pull/15045))**

  If detailed logging is enabled, you can now view and revert deleted
  information.

- **Download Bower dependencies using Composer
  ([dev/drupal#8](https://lab.civicrm.org/dev/drupal/issues/8):
  [15044](https://github.com/civicrm/civicrm-core/pull/15044))**

  This improves performance and caching by downloading Javascript libraries
  using Composer with `composer-downloads-plugin` and specified zip files rather
  than Bower.

- **Add `hook_civicrm_pre` and `hook_civicrm_post` to Domain create and edit
  operations ([dev/core#1203](https://lab.civicrm.org/dev/core/issues/1203):
  [15104](https://github.com/civicrm/civicrm-core/pull/15104))**

  Makes it so one can detect when a new Domain has been created or when a Domain
  has been edited with the usual `hook_civicrm_pre` and `hook_civicrm_post`
  callbacks.

- **Api support for deduping
  (Work Towards [dev/core#1230](https://lab.civicrm.org/dev/core/issues/1230):
  [15196](https://github.com/civicrm/civicrm-core/pull/15196),
  [15188](https://github.com/civicrm/civicrm-core/pull/15188),
  [15187](https://github.com/civicrm/civicrm-core/pull/15187),
  [15227](https://github.com/civicrm/civicrm-core/pull/15227) and
  [15154](https://github.com/civicrm/civicrm-core/pull/15154))**

  Work toward improving the new API support for deduping including: not
  geocoding when merging for performance reasons, giving contacts with 'merge
  duplicate contacts' permission to get dedupe rules, ensuring the API call
  Dedupe.getstatistics requires "Access CiviCRM" and adds a check for 'force
  merge duplicate contacts' if mode is aggressive.

- **Add cid parameter in custom group form url & set it for Activity form
  ([dev/core#752](https://lab.civicrm.org/dev/core/issues/752):
  [15012](https://github.com/civicrm/civicrm-core/pull/15012))**

  Adds a contact id parameter (cid=) when loading custom data via back end forms
  so that hooks can modify behavior based on the `contact_id` being viewed.

- **Make report listing actions links hookable
  ([dev/core#1077](https://lab.civicrm.org/dev/core/issues/1077):
  [15074](https://github.com/civicrm/civicrm-core/pull/15074))**

  The actions list on the report listing screen can now be altered by developers
  using `hook_civicrm_links`.

- **Fixes inconsistency between constituency summary and constituency detail
  ([15222](https://github.com/civicrm/civicrm-core/pull/15222))**

  This improves the consistency of how the "Print Report" action link functions
  on the reports listing. Before this change, some "Print Report" links would
  take the user to the report in print view, and some would trigger a print
  pop-up.

- **Add index to civicrm_contact.created_date & modified_date
  ([15203](https://github.com/civicrm/civicrm-core/pull/15203))**

  This adds an index to the `created_date` and `modified_date` columns in the
  `civicrm_contact` table.

- **Added field title for Cache table
  ([15204](https://github.com/civicrm/civicrm-core/pull/15204))**

  The Data Access Object for the `civicrm_cache` table now stores titles for
  each field.

- **Allow Manual Geo Code flag to be exported
  ([14998](https://github.com/civicrm/civicrm-core/pull/14998))**

  The field denoting that an address has been manually geocoded can now be
  exported.

- **Use merge duplicate contacts as api permission for merging
  ([15155](https://github.com/civicrm/civicrm-core/pull/15155))**

  Changes the API call `Contact.merge` to require 'merge duplicate contacts'
  instead of 'Administer CiviCRM'.

- **Adjust permissions on dedupe exception api to 'merge duplicate contacts'
  ([15157](https://github.com/civicrm/civicrm-core/pull/15157))**

  The API for managing dedupe exceptions now requires the permission "merge
  duplicate contacts" instead of "Administer CiviCRM".

- **Open up permissions on Dedupe.getduplicates
  ([15152](https://github.com/civicrm/civicrm-core/pull/15152))**

  Less restrictive permissions on the `Dedupe.getduplicates` API (currently only
  used from unit tests) specifically moves from requiring the permission
  "Administer CiviCRM" to "Access CiviCRM".

- **Fix inconsistencies in duplicate retrieval
  ([15160](https://github.com/civicrm/civicrm-core/pull/15160))**

  Ensures the API call `Dedupe.getduplicates` respects both 'limit' and
  'search_limit' parameters.

- **Error log improvements: Provide priority level
  ([14995](https://github.com/civicrm/civicrm-core/pull/14995))**

  Improves error logging by adding the ability to pass a priority level argument
  to `CRM_Core_Error::debug_var()`.

- **Improve deadlock error handling
  ([258](https://github.com/civicrm/civicrm-packages/pull/258))**

  Improves deadlock error handling by capturing the error when the deadlock is
  first hit so the backtrace is retained.

- **Better error handling in CRM_Utils_JS::decode
  ([15145](https://github.com/civicrm/civicrm-core/pull/15145))**

  Improves handling of malformed Javascript so as to reduce PHP notices.

- **Replace some calls to CRM_Core_Error::fatal with exceptions
  ([15156](https://github.com/civicrm/civicrm-core/pull/15156))**

  Instead of exiting with a fatal error, certain dedupe error situations now
  throw an exception.

### CiviEvent

- **Creating an event clears the cache
  ([dev/event#14](https://lab.civicrm.org/dev/event/issues/14):
  [15140](https://github.com/civicrm/civicrm-core/pull/15140))**

  This change improves performance by not clearing caches every time an event is
  created.

### CiviMembership

- **Convert jcalendar date fields to date picker for membership fields to
  support date picker conversion
  ([15177](https://github.com/civicrm/civicrm-core/pull/15177),
  [15186](https://github.com/civicrm/civicrm-core/pull/15186),
  [15198](https://github.com/civicrm/civicrm-core/pull/15198) and
  [15200](https://github.com/civicrm/civicrm-core/pull/15200))**

  Date fields on membership search screens now use datepicker rather than
  jCalendar.

  The `join_date` column on the `civicrm_membership` table is now keyed as
  `membership_join_date` within the DAO in order to support the change to date
  picker format for Membership date fields.

- **Add default domain to membershiptype API
  ([15120](https://github.com/civicrm/civicrm-core/pull/15120))**

  The domain ID now defaults to the current domain when using the membership
  type API.

- **Fix readability & caching on
  CRM_Contact_BAO_Relationship::isInheritedMembershipInvalidated
  ([15061](https://github.com/civicrm/civicrm-core/pull/15061))**

  Improves caching and performance when calculating inherited memberships.

### CiviPledge

- **Update Pledge XML to support date picker conversion
  ([15180](https://github.com/civicrm/civicrm-core/pull/15180))**

  Updates the XML and associated files to support the change to date picker
  format for Pledge date fields.

### Backdrop Integration

- **Fail more gracefully when upgrading on PHP5.x
  ([98](https://github.com/civicrm/civicrm-backdrop/pull/98))**

  Provides a clearer error when someone tries to upgrade with PHP 5.x.

### Drupal Integration

- **Automatically tag the drupal-8 repository
  (Work Towards [dev/release#9](https://lab.civicrm.org/dev/release/issues/9):
  [15149](https://github.com/civicrm/civicrm-core/pull/15149))**

  Continues work to automatically tag a Drupal8 version when new CiviCRM
  versions are released as is done for other CMS's.

- **Error when upgrading to 5.16.0
  ([dev/drupal#79](https://lab.civicrm.org/dev/drupal/issues/79):
  [583](https://github.com/civicrm/civicrm-drupal/pull/583))**

  Provides a clearer error when someone tries to upgrade with PHP 5.x.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Warnings on importing contacts - PHP 7.2
  (Work Towards [dev/core#772](https://lab.civicrm.org/dev/core/issues/772):
  [262](https://github.com/civicrm/civicrm-packages/pull/262))**

  This fixes a PHP warning on PHP 7.2 using hierarchical select fields, such as
  selecting the matching fields for import columns.  Some fields have no fields
  nested below them, and those would trigger an error on the `count()` function.

- **Warnings on CRM_Contribute_Import_Parser re countable
  ([dev/core#1001](https://lab.civicrm.org/dev/core/issues/1001):
  [14989](https://github.com/civicrm/civicrm-core/pull/14989))**

  Fixes a few PHP 7.2 count warnings when importing.

- **Changing the label for the Inbound Email activity type lets you edit/delete
  them even if the permission disallows
  ([dev/core#1123](https://lab.civicrm.org/dev/core/issues/1123):
  [15240](https://github.com/civicrm/civicrm-core/pull/15240) and
  [15147](https://github.com/civicrm/civicrm-core/pull/15147))**

- **Regression: Can't use CiviCRM menu on 5.16.0
  ([dev/core#1182](https://lab.civicrm.org/dev/core/issues/1182):
  [15020](https://github.com/civicrm/civicrm-core/pull/15020) and
  [15019](https://github.com/civicrm/civicrm-core/pull/15019))**

  Fixes a bug in CiviCRM 5.16.0 where a race condition was causing the CiviCRM
  Admin Menu to break.

- **csv import only import one phone number
  ([dev/core#1187](https://lab.civicrm.org/dev/core/issues/1187):
  [15190](https://github.com/civicrm/civicrm-core/pull/15190))**

  Fixes a bug whereby one phone number is not imported if 2 of the same location
  type but different phone types are in an import.

- **Fix Psalm issue Class or interface CiviCRM_API3_Exception does not exist
  ([dev/core#1188](https://lab.civicrm.org/dev/core/issues/1188):
  [15043](https://github.com/civicrm/civicrm-core/pull/15043))**

  Ensures that the Psalm Autoloader can find `CRM_Core_Exception`.

- **File attachment uploads - pptx issue
  ([dev/core#1190](https://lab.civicrm.org/dev/core/issues/1190):
  [15239](https://github.com/civicrm/civicrm-core/pull/15239))**

  Fixes the upgrade function for adding ".pptx" to the list of safe file types.

- **ENOTICE when creating activity from contact search results / aka Repeat
  Activity accordion section missing when using Add Activity from contact search
  results ([dev/core#1192](https://lab.civicrm.org/dev/core/issues/1192):
  [15079](https://github.com/civicrm/civicrm-core/pull/15079))**

  Fixes a PHP notice when using the "Add Activity" action from the contact
  search results list.

- **CiviCRM Dashboard does not respect multiple domains
  ([dev/core#1200](https://lab.civicrm.org/dev/core/issues/1200):
  [15099](https://github.com/civicrm/civicrm-core/pull/15099))**

  For sites with multisite enabled ensures that the CiviCRM Dashboard respects
  multiple domains and shows unique dashlets depending on what domain you are
  using.

- **Contact subtype is removed after being cached incorrectly
  ([dev/core#1222](https://lab.civicrm.org/dev/core/issues/1222):
  [15171](https://github.com/civicrm/civicrm-core/pull/15171))**

  Ensures the static cache is cleared whenever updating or deleting a DAO
  object.

- **Regression: Searching on Email broken in advanced search
  ([dev/core#1244](https://lab.civicrm.org/dev/core/issues/1244):
  [15255](https://github.com/civicrm/civicrm-core/pull/15255))**

  This fixes a problem where attempting to search on email on the Advanced
  search form resulted in a warning and no results.

- **Trim form values when adding LIKE operator
  ([15275](https://github.com/civicrm/civicrm-core/pull/15275))**

  Fixes a 5.17 regression whereby the email string is no longer being trimmed
  when searching.

- **Ensure filtering on email via the api looks for an exact match
  ([15276](https://github.com/civicrm/civicrm-core/pull/15276))**

  Fixes a released regression whereby a wildcard was being added to API
  Contact.get requests with the email parameter.

- **Fix fatal when saving import mapping with a relationship but 'Primary'
  location type ([15115](https://github.com/civicrm/civicrm-core/pull/15115))**

  When an import column was mapped to a field with the "Primary" location type
  that was on a related contact, it would result in a fatal error.

- **Fix export header for 'Contact ID'
  ([15118](https://github.com/civicrm/civicrm-core/pull/15118))**

  This ensures when exporting a contact id column the header is "Contact ID" not
  "contact_id".

- **Changed ClassName for ACL cache
  ([15193](https://github.com/civicrm/civicrm-core/pull/15193))**

  Ensures `civicrm_acl_cache` and `civicrm_cache` use different entity names.

- **Set contact communication_style_id as importable
  ([15205](https://github.com/civicrm/civicrm-core/pull/15205))**

  Ensures the "Contact Communication Style" is visible in profile view mode.

- **Incorporate searchLimit in dedupe cacheKey
  ([15185](https://github.com/civicrm/civicrm-core/pull/15185))**

  When you change the search limit after a duplicate search has been performed,
  this ensures that a new search is run.

- **Allow for the deselection of sorting filters
  ([15029](https://github.com/civicrm/civicrm-core/pull/15029))**

  Fixes a bug where removing sorting filters on reports and refreshing the
  results would nevertheless retain the sorting filters.

- **CRM_Utils_Array::crmInArray() should recurse properly
  ([dev/core#1196](https://lab.civicrm.org/dev/core/issues/1196):
  [15092](https://github.com/civicrm/civicrm-core/pull/15092))**

- **Add ts() to deceased string
  ([15211](https://github.com/civicrm/civicrm-core/pull/15211))**

  The word "deceased" when appended to a contact's name is now translatable.

- **Fatal Error in "Search Builder" if "Household" Contact type is disabled.
  ([dev/core#1246](https://lab.civicrm.org/dev/core/issues/1246):
  [15289](https://github.com/civicrm/civicrm-core/pull/15289))**

- **Do not show Activity Separation on when viewing an Activity
  ([15046](https://github.com/civicrm/civicrm-core/pull/15046))**

  The option to create separate activities for each contact, only applicable
  when creating a new activity, would erroneously appear when viewing an
  activity.

- **Activity profile on Update multiple activities action displays duplicate
  assignees ([dev/core#1185](https://lab.civicrm.org/dev/core/issues/1185):
  [15035](https://github.com/civicrm/civicrm-core/pull/15035))**

  The list of assignees would display all of the assignees for each previous row
  in addition to the assignee(s) for that activity.

- **Ensure that civicrm_dashboard has a foreign key to civicrm_domain
  ([15119](https://github.com/civicrm/civicrm-core/pull/15119))**

- **Manage Group search message fix
  ([15052](https://github.com/civicrm/civicrm-core/pull/15052))**

  When no the group listing is filtered and no groups match the criteria, the
  message says that more clearly rather than stating there are no groups on the
  site.

### CiviCampaign

- **Actions in campaign dashboard not working with pop-up disabled
  ([dev/core#1233](https://lab.civicrm.org/dev/core/issues/1233):
  [15233](https://github.com/civicrm/civicrm-core/pull/15233))**

  Ensures users with pop ups deactivated can edit and delete campaigns.

### CiviCase

- **Proposal to fix longstanding name vs label problems for case roles (Work
  Towards [dev/core#1046](https://lab.civicrm.org/dev/core/issues/1046):
  [15192](https://github.com/civicrm/civicrm-core/pull/15192) and
  [15182](https://github.com/civicrm/civicrm-core/pull/15182))**

  These changes work towards fixing the label being used as the name in some
  places in CiviCase by allowing for an override tag in the xml to specify the
  actual "name".

- **Changing a civicase activity's label breaks the max_instances check
  (Work Towards [dev/core#1116](https://lab.civicrm.org/dev/core/issues/1116):
  [14999](https://github.com/civicrm/civicrm-core/pull/14999),
  [15002](https://github.com/civicrm/civicrm-core/pull/15002),
  [15000](https://github.com/civicrm/civicrm-core/pull/15000) and
  [15032](https://github.com/civicrm/civicrm-core/pull/15032))**

  Refactors and cleans up code in preparation for fixing a bug where CiviCase
  activity's label breaks the max_instances check.

- **Fix search for case tags that are part of tag sets
  ([15212](https://github.com/civicrm/civicrm-core/pull/15212))**

  Fixes a DB Error when searching for tags that are a part of a tag set.

- **Switch to relationship BAO when modifying relationships in change case
  status so we don't bypass hooks
  ([15030](https://github.com/civicrm/civicrm-core/pull/15030))**

- **Word Replacements not working on manage case Roles
  ([dev/core#1218](https://lab.civicrm.org/dev/core/issues/1218):
  [15161](https://github.com/civicrm/civicrm-core/pull/15161))**

### CiviContribute

- **Renaming a price option / fee level breaks event participant lists
  ([CRM-17182](https://issues.civicrm.org/jira/browse/CRM-17182):
  [15064](https://github.com/civicrm/civicrm-core/pull/15064) and
  [15350](https://github.com/civicrm/civicrm-core/pull/15350))**

  Fixes a bug where the `fee_amount` was being changed whenever a label was
  changed and moves from searching based on regex on the `fee_amount` column to
  searching based on the `price_field_value` id.

- **Add pre/post hooks for price set / field/option
  ([dev/core#870](https://lab.civicrm.org/dev/core/issues/870):
  [15076](https://github.com/civicrm/civicrm-core/pull/15076))**

  The `hook_civicrm_pre` and `hook_civicrm_post` hooks get invoked when adding
  price sets, fields, and options.

- **Event/Contribution amounts are duplicated when the form is saved
  ([dev/core#1240](https://lab.civicrm.org/dev/core/issues/1240):
  [15245](https://github.com/civicrm/civicrm-core/pull/15245))**

  Fixes a bug where saving the "amounts" tab of either an event or contribution
  page (when using that form to enter options, rather than a price set) results in the
  duplication of the amount options listed.

- **Fix PayPalImpl Contribution Status PseudoConstant for non-English
  ([15164](https://github.com/civicrm/civicrm-core/pull/15164))**

  Ensures contribution statuses are set correctly for sites using PayPal Express
  and a language other than English by switching to using the name property
  instead of the label.

- **Fix an HTML error in Calculate.tpl
  ([15102](https://github.com/civicrm/civicrm-core/pull/15102))**

  This resolves a `<span>` that was not closed correctly on the calculation of a
  price set's total amount due.

- **Use api to create activity and removed hardcoded status id
  ([14621](https://github.com/civicrm/civicrm-core/pull/14621))**

  When exporting an accounting batch, the activity that is created is now done
  so using the API, and it uses the status name `Completed` rather than a
  hard-coded status ID `2`.

- **Fix wrong variable in check for profiles on contributionpage
  ([15093](https://github.com/civicrm/civicrm-core/pull/15093))**

  Ensures the correct variable is being checked for pre profile types when
  configuring a Contribution Page.

- **Batch payment page breaks when an exported activity has no file to download
  ([dev/financial#58](https://lab.civicrm.org/dev/financial/issues/58):
  [14367](https://github.com/civicrm/civicrm-core/pull/14367))**

- **Stop adding a refund payment from creating extraneous financial items
  ([15143](https://github.com/civicrm/civicrm-core/pull/15143))**

### CiviEvent

- **Most recent contact note exposed in event confirmation emails
  ([dev/event#10](https://lab.civicrm.org/dev/event/issues/10):
  [15060](https://github.com/civicrm/civicrm-core/pull/15060))**

  Fixes a bug where when submitting an event registration which contains a
  profile which contains a note field.  If the note was left blank, then the
  confirmation/notification emails would contain the most recent note in the
  contact's record, potentially exposing confidential information.

- **Custom field values for a new Event based on an Event Template are not
  checked causing false validation message and Event not to
  save ([dev/core#1241](https://lab.civicrm.org/dev/core/issues/1241):
  [15296](https://github.com/civicrm/civicrm-core/pull/15296))**

- **Confirmation emails include flawed subtitle for post-profiles
  ([dev/event#15](https://lab.civicrm.org/dev/event/issues/15): [#15380](https://github.com/civicrm/civicrm-core/pull/15380))**

  Fixes a regression from 5.17.0 when sending a confirmation email.
  The confirmation email includes subsections to summarize any
  post-profile data, but the title was miscomputed. This manifested
  as either a page crash or an inaccurate title.

### CiviGrant

- **Grant in Edit mode doesn't show the associated contact
  ([dev/core#1065](https://lab.civicrm.org/dev/core/issues/1065):
  [15238](https://github.com/civicrm/civicrm-core/pull/15238) and
  [15209](https://github.com/civicrm/civicrm-core/pull/15209))**

  Ensures that the associated contact field is shown when editing a grant.

- **Fixes for taking dynamic form name in grant search
  ([15075](https://github.com/civicrm/civicrm-core/pull/15075))**

  This removes the hard-coded form name when retrieving the search results in
  preparation for a search action.

### CiviMail

- **SMTP help text is misleading - references the wrong admin screen
  ([dev/core#879](https://lab.civicrm.org/dev/core/issues/879):
  [15165](https://github.com/civicrm/civicrm-core/pull/15165))**

  Fixes up the help text displayed when testing the SMTP configuration fails.

- **Remove template field if using Mosaico in non shoreditch mode
  ([14927](https://github.com/civicrm/civicrm-core/pull/14927))**

### CiviMember

- **Fix metadata on member export
  ([14916](https://github.com/civicrm/civicrm-core/pull/14916))**

  Ensures when exporting memberships headings are set appropriately for the
  following columns: `member_is_override`, `membership_recur_id` and
  `max_related`.

- **Incorrect line item created for back-end membership sign-up using price set
  and CiviDiscount ([dev/core#860](https://lab.civicrm.org/dev/core/issues/860):
  [15004](https://github.com/civicrm/civicrm-core/pull/15004))**

- **[regression] Recurring contributions no longer properly update memberships
  (on PayPal Pro, maybe others)
  ([dev/membership#13](https://lab.civicrm.org/dev/membership/issues/13):
  [15053](https://github.com/civicrm/civicrm-core/pull/15053))**

- **Make sure inherited memberships are not themselves inherited
  ([15114](https://github.com/civicrm/civicrm-core/pull/15114))**

  This prevents contacts from inheriting memberships that were inherited from
  them.

- **{Membership.Fee} appears on Membership Renewal Reminder emails with 9
  decimal places ([dev/core#377](https://lab.civicrm.org/dev/core/issues/377):
  [14992](https://github.com/civicrm/civicrm-core/pull/14992))**

### Drupal Integration

- **Drupal8: getUrlPath: avoid relying on the deprecated 'q' variable
  (Work Towards [dev/drupal#52](https://lab.civicrm.org/dev/drupal/issues/52):
  [15268](https://github.com/civicrm/civicrm-core/pull/15268))**

  In Drupal8, the 'q' variable has been deprecated which has resulted in CiviCRM
  throwing a bunch of PHP notices. This PR silences those notices while a more
  long term fix is developed.

### Joomla Integration

- **Some error messages render a chunk of markup as plain text
  ([dev/joomla#10](https://lab.civicrm.org/dev/joomla/issues/10):
  [15159](https://github.com/civicrm/civicrm-core/pull/15159))**

  Removes Joomla-specific error display and use native CiviCRM display to avoid
  some error messages rendering as plain text.

- **PHP 7.2 countable warning after installation
  ([dev/joomla#15](https://lab.civicrm.org/dev/joomla/issues/15):
  [53](https://github.com/civicrm/civicrm-joomla/pull/53))**

- **[Joomla 4.0] CiviCRM's CSS interferes with Joomla's top header background
  colour ([dev/joomla#24](https://lab.civicrm.org/dev/joomla/issues/24):
  [15137](https://github.com/civicrm/civicrm-core/pull/15137))**

## <a name="misc"></a>Miscellany

- **Swap CRM_Utils_Array::value for empty() in conditionals
  ([15005](https://github.com/civicrm/civicrm-core/pull/15005))**

- **Possible timing issue with test phpunit/api/v3/AttachmentTest::testCreate
  ([dev/core#938](https://lab.civicrm.org/dev/core/issues/938):
  [15216](https://github.com/civicrm/civicrm-core/pull/15216))**

- **Change connection and results charsets to utf8mb4 on MySQL 5.5.3+
  ([241](https://github.com/civicrm/civicrm-packages/pull/241))**

- **Fix upgrade version for #13487
  ([15031](https://github.com/civicrm/civicrm-core/pull/15031))**

- **Update select2 to latest 3.x + patches
  ([15054](https://github.com/civicrm/civicrm-core/pull/15054))**

- **Further work on payment.create consolidation - always handle financials from
  payment.create ([14673](https://github.com/civicrm/civicrm-core/pull/14673))**

- **Extract function to create email activity when sending an email to contact
  ([15133](https://github.com/civicrm/civicrm-core/pull/15133))**

- **Extract cancelParticipant and cancelMembership functions in baseIPN
  ([15134](https://github.com/civicrm/civicrm-core/pull/15134))**

- **Rewrite subTypeInfo to use caching mechanism
  ([14715](https://github.com/civicrm/civicrm-core/pull/14715))**

- **providing clear indication that civicrm_engage module is deprecated.
  ([582](https://github.com/civicrm/civicrm-drupal/pull/582))**

- **distmaker - Finish migrating bower.json => composer.json
  ([15148](https://github.com/civicrm/civicrm-core/pull/15148))**

- **Switch recordAdditionalPayment fully over to api
  ([14408](https://github.com/civicrm/civicrm-core/pull/14408))**

- **Add note about testRenewMembership failing on certain days
  ([15167](https://github.com/civicrm/civicrm-core/pull/15167))**

- **Someimes ya just gotta say enough already
  ([15175](https://github.com/civicrm/civicrm-core/pull/15175))**

- **Extend loadSavedMapping to check defaults
  ([15179](https://github.com/civicrm/civicrm-core/pull/15179))**

- **Initial refactor of BaseIPN
  ([15129](https://github.com/civicrm/civicrm-core/pull/15129))**

- **Convert pledge date fields to use datepicker rather than jcalendar
  ([15170](https://github.com/civicrm/civicrm-core/pull/15170))**

- **Use metadata for pledgeDateRange fields
  ([15191](https://github.com/civicrm/civicrm-core/pull/15191))**

- **Add minimal test for testExportFinancialBatch
  ([15136](https://github.com/civicrm/civicrm-core/pull/15136))**

- **Code cleanup in CRM_Core_Permission::check
  ([15141](https://github.com/civicrm/civicrm-core/pull/15141))**

- **Event confirm - (very) minor cleanup + test
  ([15010](https://github.com/civicrm/civicrm-core/pull/15010))**

- **Stabalize Attachment API Test
  ([15066](https://github.com/civicrm/civicrm-core/pull/15066))**

- **Remove ?last? instances of ->free()
  ([dev/core#562](https://lab.civicrm.org/dev/core/issues/562):
  [14990](https://github.com/civicrm/civicrm-core/pull/14990))**

- **Add myself to the contributor list
  ([15036](https://github.com/civicrm/civicrm-core/pull/15036))**

- **Remove silly dumb unreachable lines
  ([15033](https://github.com/civicrm/civicrm-core/pull/15033))**

- **Deprecate CRM_Core_Config::addressSequence()
  ([15126](https://github.com/civicrm/civicrm-core/pull/15126))**

- **Deprecate CRM_Core_Config::defaultContactCountry and
  defaultContactCountryName
  ([15127](https://github.com/civicrm/civicrm-core/pull/15127))**

- **Use metadata for dataPatterns
  ([15224](https://github.com/civicrm/civicrm-core/pull/15224))**

- **SyntaxConformanceTest::testSqlOperators - Skip "Dedupe" entity on MySQL 5.5
  ([15234](https://github.com/civicrm/civicrm-core/pull/15234))**

- **Add in 5.17.1 Release notes and migrate .tpl file for 5.17.1 to 5.18 to
  support upgrade
  ([15253](https://github.com/civicrm/civicrm-core/pull/15253))**

- **(NFC) Add comments to relate to gitlab ticket
  ([dev/core#927](https://lab.civicrm.org/dev/core/issues/927):
  [15128](https://github.com/civicrm/civicrm-core/pull/15128))**

- **Remove unused method CRM_Contact_BAO_Contact_Utils::maxLocations
  ([15091](https://github.com/civicrm/civicrm-core/pull/15091))**

- **Remove unused Selenium binaries
  ([263](https://github.com/civicrm/civicrm-packages/pull/263))**

- **Remove a few unused scripts from tools/bin/scripts
  ([15078](https://github.com/civicrm/civicrm-core/pull/15078))**

- **Remove deprecated unused function.
  ([15070](https://github.com/civicrm/civicrm-core/pull/15070))**

- **Remove unused skipRedirect param
  ([15125](https://github.com/civicrm/civicrm-core/pull/15125))**

- **[clean up][ export] Remove membership_auto_renew from defaultReturn
  properties ([14980](https://github.com/civicrm/civicrm-core/pull/14980))**

- **[Ref] [Import] Use processor to determine website type, location type, test
  ([15116](https://github.com/civicrm/civicrm-core/pull/15116))**

- **[Import] [ref] - minor cleanup to reduce code complexity
  ([15097](https://github.com/civicrm/civicrm-core/pull/15097))**

- **[ref] [ import] Extend tests & simpler retrieval to relationship_type_id
  ([15130](https://github.com/civicrm/civicrm-core/pull/15130))**

- **[REF] Import - minor cleanup  - generate js on the processor class
  ([15183](https://github.com/civicrm/civicrm-core/pull/15183))**

- **[Import] Minor cleanup on membership import
  ([15013](https://github.com/civicrm/civicrm-core/pull/15013))**

- **[Import][ref] Minor code improvement -  move setDefaults to processor
  ([15189](https://github.com/civicrm/civicrm-core/pull/15189))**

- **[Ref] [Import] more code cleanup
  ([15219](https://github.com/civicrm/civicrm-core/pull/15219))**

- **[Ref] [Import] Final round in the cleanup Load Mapping form epic
  ([15226](https://github.com/civicrm/civicrm-core/pull/15226))**

- **[Import] [REF] code cleanup & test on the code to  'guess the intended
  field  from the column name'
  ([15220](https://github.com/civicrm/civicrm-core/pull/15220))**

- **[REF] [Import] Minor cleanup on status setting.
  ([15015](https://github.com/civicrm/civicrm-core/pull/15015))**

- **[REF] [Import] extract saved mapping code to parent class
  ([15017](https://github.com/civicrm/civicrm-core/pull/15017))**

- **[Import] [Cleanup] remove unused parameters
  ([14981](https://github.com/civicrm/civicrm-core/pull/14981))**

- **[Ref] [Import] move metadata calculations to a trait
  ([15018](https://github.com/civicrm/civicrm-core/pull/15018))**

- **[Test] [Ref] [Import]Add wrapper class for importProcessor
  ([15028](https://github.com/civicrm/civicrm-core/pull/15028))**

- **Refactor CRM_Contact_BAO_Relationship::add to autoload missing params from
  existing record ([15103](https://github.com/civicrm/civicrm-core/pull/15103)
  and [15123](https://github.com/civicrm/civicrm-core/pull/15123))**

- **[Ref] Extract addInheritedMembership
  ([15113](https://github.com/civicrm/civicrm-core/pull/15113))**

- **[REF] minor code refactor on import - Pass ProcessorObject into
  loadSavedMapping & use it to load the formName
  ([15068](https://github.com/civicrm/civicrm-core/pull/15068))**

- **Minor refactor of 'Pending' parameter for processMembership
  ([15124](https://github.com/civicrm/civicrm-core/pull/15124))**

- **[REF] Very minor code cleanup on import code with good test cover
  ([15173](https://github.com/civicrm/civicrm-core/pull/15173))**

- **[REF] Move clone template functionality from api to bao
  ([15163](https://github.com/civicrm/civicrm-core/pull/15163))**

- **[REF] Extract chunk of code relating to whether to disabled an inherited
  relationship ([14955](https://github.com/civicrm/civicrm-core/pull/14955))**

- **[REF] Move calculation of js for import fields WITH relationship keys to
  processor. ([15218](https://github.com/civicrm/civicrm-core/pull/15218))**

- **[Datepicker][REF] Convert mailing date field on mailing search screen…
  ([15181](https://github.com/civicrm/civicrm-core/pull/15181))**

- **[Ref] Import use process for relationship defaults, add test
  ([15215](https://github.com/civicrm/civicrm-core/pull/15215))**

- **[REF] extract send receipt in MembershipRenewal fn
  ([15117](https://github.com/civicrm/civicrm-core/pull/15117))**

- **[NFC] Fix test syntax
  ([15067](https://github.com/civicrm/civicrm-core/pull/15067))**

- **[NFC] swap instances where double = is used but it should be triple =
  ([15049](https://github.com/civicrm/civicrm-core/pull/15049))**

- **[NFC] Update Upgrade Template to use short array syntax
  ([15057](https://github.com/civicrm/civicrm-core/pull/15057))**

- **[NFC] Remove redundant annotation
  ([15172](https://github.com/civicrm/civicrm-core/pull/15172))**

- **(NFC) assertPhpSupport - Code cleanup
  ([164](https://github.com/civicrm/civicrm-wordpress/pull/164))**

- **(NFC) civicrm.drush.inc - Cleanup style
  ([99](https://github.com/civicrm/civicrm-backdrop/pull/99))**

- **[NFC] Update Default report instances that filter on join date to be …
  ([15247](https://github.com/civicrm/civicrm-core/pull/15247))**

- **[NFC] Add ImportProcessor class & unit tests + extend existing cover
  ([15072](https://github.com/civicrm/civicrm-core/pull/15072))**

- **[NFC] Update the APIv3 documentation links.
  ([15077](https://github.com/civicrm/civicrm-core/pull/15077))**

- **(NFC) GenericAssertionsTrait - Improve docblocks
  ([15071](https://github.com/civicrm/civicrm-core/pull/15071))**

- **[NFC] Update Examples
  ([15085](https://github.com/civicrm/civicrm-core/pull/15085))**

- **[Test] [NFC] upgrade remaining export tests
  ([15095](https://github.com/civicrm/civicrm-core/pull/15095))**

- **[Test] Bring to life dormant test
  ([15150](https://github.com/civicrm/civicrm-core/pull/15150))**

- **[TEST] Enable apiv4 testing for GroupNesting and GroupOrganization entities
  ([15217](https://github.com/civicrm/civicrm-core/pull/15217))**

- **[Test] Demonstrate the truthiness of CRM_Utils_System::isNull
  ([15027](https://github.com/civicrm/civicrm-core/pull/15027))**

- **Unit test for custom date parsing
  ([14988](https://github.com/civicrm/civicrm-core/pull/14988))**

- **[NFC] [Test] dev/core#1098 Add unit test & code comments relating to the
  slow activity search
  ([15016](https://github.com/civicrm/civicrm-core/pull/15016))**

- **[Import] [Test] Initial test on loadSavedMapping function.
  ([15050](https://github.com/civicrm/civicrm-core/pull/15050))**

- **[Test] Tolerance parameter in attachmenttest needs to be one higher for
  integers ([15069](https://github.com/civicrm/civicrm-core/pull/15069))**

- **[Test] Fix Last_name in CiviUnitTestCase::activityCreate
  ([15112](https://github.com/civicrm/civicrm-core/pull/15112))**

- **test for PR
  ([15121](https://github.com/civicrm/civicrm-core/pull/15121))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

19ATF77; AGH Strategies - Andie Hunt; Agileware - Justin Freeman; Andrew
Thompson; Australian Greens - Seamus Lee; Caltha - Tomasz Pietrzkowski;
Christian Wach; Circle Interactive - Dave Jenkins, Pradeep Nayak, Reece Benson;
CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha
Chaku; Coop SymbioTIC - Mathieu Lutfy; Dave D; Electronic Frontier Foundation -
Mark Burdett; Florian Kohrt; Greenpeace CEE - Patrick Figel; JMA Consulting -
Monish Deb; John Kingsnorth; Megaphone Technology Consulting - Jon Goldberg; MJW
Consulting - Matthew Wire; mmyriam; Onyemenam Ndubuisi; Progressive Technology
Project - Jamie McClelland; Tadpole Collective - Kevin Cristiano; Wikimedia
Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin; Agileware - Francis Whittle, Pengyi Zhang;
don-alejandro-z; Fuzion - Jitendra Purohit; iXiam - Luciano Spiegel; JMA
Consulting - Joe Murray; Nicol Wistreich; Semper IT - Karin Gerritsen; Squiffle
Consulting - Aidan Saunders

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
