-- +--------------------------------------------------------------------+
-- | Copyright CiviCRM LLC. All rights reserved.                        |
-- |                                                                    |
-- | This work is published under the GNU AGPLv3 license with some      |
-- | permitted exceptions and without any warranty. For full license    |
-- | and copyright information, see https://civicrm.org/licensing       |
-- +--------------------------------------------------------------------+
--
-- Generated from schema.tpl
-- DO NOT EDIT.  Generated by CRM_Core_CodeGen
--

-- +--------------------------------------------------------------------+
-- | Copyright CiviCRM LLC. All rights reserved.                        |
-- |                                                                    |
-- | This work is published under the GNU AGPLv3 license with some      |
-- | permitted exceptions and without any warranty. For full license    |
-- | and copyright information, see https://civicrm.org/licensing       |
-- +--------------------------------------------------------------------+
--
-- Generated from drop.tpl
-- DO NOT EDIT.  Generated by CRM_Core_CodeGen
--
-- /*******************************************************
-- *
-- * Clean up the existing tables
-- *
-- *******************************************************/

SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `civicrm_oauth_contact_token`;

SET FOREIGN_KEY_CHECKS=1;
-- /*******************************************************
-- *
-- * Create new tables
-- *
-- *******************************************************/

-- /*******************************************************
-- *
-- * civicrm_oauth_contact_token
-- *
-- *******************************************************/
CREATE TABLE `civicrm_oauth_contact_token` (


     `id` int unsigned NOT NULL AUTO_INCREMENT  COMMENT 'Token ID',
     `tag` varchar(128)    COMMENT 'The tag specifies how this token will be used.',
     `client_id` int unsigned    COMMENT 'Client ID',
     `contact_id` int unsigned    COMMENT 'Contact ID',
     `grant_type` varchar(31)    COMMENT 'Ex: authorization_code',
     `scopes` text    COMMENT 'List of scopes addressed by this token',
     `token_type` varchar(128)    COMMENT 'Ex: Bearer or MAC',
     `access_token` text    COMMENT 'Token to present when accessing resources',
     `expires` int unsigned   DEFAULT 0 COMMENT 'Expiration time for the access_token (seconds since epoch)',
     `refresh_token` text    COMMENT 'Token to present when refreshing the access_token',
     `resource_owner_name` varchar(128)    COMMENT 'Identifier for the resource owner. Structure varies by service.',
     `resource_owner` text    COMMENT 'Cached details describing the resource owner',
     `error` text    COMMENT '?? copied from OAuthSysToken',
     `raw` text    COMMENT 'The token response data, per AccessToken::jsonSerialize',
     `created_date` timestamp NULL  DEFAULT CURRENT_TIMESTAMP COMMENT 'When the token was created.',
     `modified_date` timestamp NULL  DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'When the token was created or modified.'
,
        PRIMARY KEY (`id`)

    ,     INDEX `UI_tag`(
        tag
  )

,          CONSTRAINT FK_civicrm_oauth_contact_token_client_id FOREIGN KEY (`client_id`) REFERENCES `civicrm_oauth_client`(`id`) ON DELETE CASCADE,          CONSTRAINT FK_civicrm_oauth_contact_token_contact_id FOREIGN KEY (`contact_id`) REFERENCES `civicrm_contact`(`id`) ON DELETE CASCADE
)  ENGINE=InnoDB  ;
