<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Core/Translation.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:50d8cca3198bc1c9d4616308f2e5c462)
 */

/**
 * Database access object for the Translation entity.
 */
class CRM_Core_DAO_Translation extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '5.39';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_translation';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Unique String ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Table where referenced item is stored
   *
   * @var string
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $entity_table;

  /**
   * Field where referenced item is stored
   *
   * @var string
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $entity_field;

  /**
   * ID of the relevant entity.
   *
   * @var int|string
   *   (SQL type: int)
   *   Note that values will be retrieved from the database as a string.
   */
  public $entity_id;

  /**
   * Relevant language
   *
   * @var string
   *   (SQL type: varchar(5))
   *   Note that values will be retrieved from the database as a string.
   */
  public $language;

  /**
   * Specify whether the string is active, draft, etc
   *
   * @var int|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $status_id;

  /**
   * Translated string
   *
   * @var string
   *   (SQL type: longtext)
   *   Note that values will be retrieved from the database as a string.
   */
  public $string;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_translation';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Translated Strings') : ts('Translated String');
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Dynamic(self::getTableName(), 'entity_id', NULL, 'id', 'entity_table');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Translated String ID'),
          'description' => ts('Unique String ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_translation.id',
          'table_name' => 'civicrm_translation',
          'entity' => 'Translation',
          'bao' => 'CRM_Core_BAO_Translation',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => '5.39',
        ],
        'entity_table' => [
          'name' => 'entity_table',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Translated Entity'),
          'description' => ts('Table where referenced item is stored'),
          'required' => TRUE,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_translation.entity_table',
          'table_name' => 'civicrm_translation',
          'entity' => 'Translation',
          'bao' => 'CRM_Core_BAO_Translation',
          'localizable' => 0,
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_Translation::getEntityTables',
          ],
          'add' => '5.39',
        ],
        'entity_field' => [
          'name' => 'entity_field',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Translated Field'),
          'description' => ts('Field where referenced item is stored'),
          'required' => TRUE,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_translation.entity_field',
          'table_name' => 'civicrm_translation',
          'entity' => 'Translation',
          'bao' => 'CRM_Core_BAO_Translation',
          'localizable' => 0,
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_Translation::getEntityFields',
          ],
          'add' => '5.39',
        ],
        'entity_id' => [
          'name' => 'entity_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Translated Entity ID'),
          'description' => ts('ID of the relevant entity.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_translation.entity_id',
          'table_name' => 'civicrm_translation',
          'entity' => 'Translation',
          'bao' => 'CRM_Core_BAO_Translation',
          'localizable' => 0,
          'add' => '5.39',
        ],
        'language' => [
          'name' => 'language',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Language'),
          'description' => ts('Relevant language'),
          'required' => TRUE,
          'maxlength' => 5,
          'size' => CRM_Utils_Type::SIX,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_translation.language',
          'table_name' => 'civicrm_translation',
          'entity' => 'Translation',
          'bao' => 'CRM_Core_BAO_Translation',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'languages',
            'keyColumn' => 'name',
            'optionEditPath' => 'civicrm/admin/options/languages',
          ],
          'add' => '5.39',
        ],
        'status_id' => [
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Status'),
          'description' => ts('Specify whether the string is active, draft, etc'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_translation.status_id',
          'default' => '1',
          'table_name' => 'civicrm_translation',
          'entity' => 'Translation',
          'bao' => 'CRM_Core_BAO_Translation',
          'localizable' => 0,
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_Translation::getStatuses',
          ],
          'add' => '5.39',
        ],
        'string' => [
          'name' => 'string',
          'type' => CRM_Utils_Type::T_LONGTEXT,
          'title' => ts('Translated String'),
          'description' => ts('Translated string'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_translation.string',
          'table_name' => 'civicrm_translation',
          'entity' => 'Translation',
          'bao' => 'CRM_Core_BAO_Translation',
          'localizable' => 0,
          'add' => '5.39',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'translation', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'translation', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'index_entity_lang' => [
        'name' => 'index_entity_lang',
        'field' => [
          0 => 'entity_id',
          1 => 'entity_table',
          2 => 'language',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_translation::0::entity_id::entity_table::language',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
