//
// Created by uos on 2022/2/21.
//

#ifndef UOS_RECOVERY_FSTAB_H
#define UOS_RECOVERY_FSTAB_H

#include "Device.h"
#include <QSharedPointer>
#include <QList>
#include <QMap>

struct FSTabInfo {
    bool isComment = false;
    bool isEmptyLine = false;
    QString device = "";
    QString mountPoint = "";
    QString type = "";
    QString options = "";
    QString dump = "0";
    QString pass = "0";
    QString line = "";
};
typedef QSharedPointer<FSTabInfo> FSTabInfoPtr;
typedef QList<FSTabInfoPtr> FSTabInfoList;

class FSTab
{
public:
    FSTab();
    virtual ~FSTab();
    static FSTabInfoList getFSTabFromFile(const QString &filename);
    static QString getDeviceUUID(const FSTabInfoPtr &fsTabInfo);
    static void saveFSTab2File(FSTabInfoList &fstab, const QString &filename);
    static QString subVolumeName(FSTabInfoPtr &fstabInfo);
    static bool isSystemDirectory(const QString &uuid, const QString &dir);
    static FSTabInfoPtr findFSTabByMountPoint(const FSTabInfoList &fstab, const QString &mountPoint);
    static FSTabInfoPtr findFSTabByUUID(const FSTabInfoList &fstab, const QString &uuid);
    static void getFstabBindDir(const FSTabInfoList &fstabList, QMap<QString, QString> &bindDirMap);
    static bool isUuidInFstab(const QString &uuid, const FSTabInfoList &fstabList);
    static QStringList getUuidListFromFstab(const FSTabInfoList &fstabList);
};


#endif //UOS_RECOVERY_FSTAB_H
