#include "UImgRecovery.h"
#include "utils/data-collection/EventLogMgr.h"

UImgRecovery::UImgRecovery()
{

}

UImgRecovery::~UImgRecovery()
{

}

void UImgRecovery::reportEventLog(const ResultInfo &resultInfo, OperateType opType, RecoveryType recoveryType)
{
    if (opType != OperateType::GhostBackup) {
        return;
    }

    GhostEventData ghostData;
    ghostData.tid = EventTid::TID_ADVANCED_GHOST;
    ghostData.resInfo = resultInfo;
    ghostData.operateType = "GhostBackup";
    QJsonObject dataObj = ghostData.marshal();

    EventLogMgr *eventLogMgr = EventLogMgr::getInstance();
    if (eventLogMgr->isInited()) {
        eventLogMgr->writeEventLog(dataObj);
    }
}
