//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/11/19.
//

#ifndef UOS_RECOVERY_IMMU_BACKUP_WIDGET_H
#define UOS_RECOVERY_IMMU_BACKUP_WIDGET_H

#include <DGuiApplicationHelper>
#include <DWidget>
#include <QStandardItemModel>
#include <DListView>
#include <DLabel>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class ImmuBackupWidget : public DWidget
{
    Q_OBJECT
public:
    explicit ImmuBackupWidget(DWidget *parent = nullptr);
    void initUI();
    void setLVM(bool isLVM);
    void setEncrypted(bool isEncrypted);
    void setImmutable(bool isImmutable);
    void setUserDataSyncType(int type);

Q_SIGNALS:
    void notifySystemBackup();
    void notifyDataBackup();
    void notifySystemClone();

protected:
    //bool eventFilter(QObject* watched, QEvent* event);

private Q_SLOTS:
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);
    void onItemChanged(bool checked);
    void systemCloneItemClicked();

private:
    void uiHorizontalLayout();
    void uiVerticalLayout();
    void showNotSupportDlg(const QString &msg);
private:
    QStringList m_iconList;
    DListView *m_backupView = nullptr;
    QStandardItemModel *m_model = nullptr;
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
   // ProgressWidget *m_progressWidget = nullptr;
    DLabel *m_title = nullptr;
    DPushButton *m_nextBtn = nullptr;
    bool m_bDirectionRTL = true;
    bool m_isEncrypted = false;
    bool m_isLVMOnly = false;
    bool m_isCommunity = false;
    bool m_isImmutable = false;
    int m_userDataSyncType = -1;
};

#endif //UOS_RECOVERY_IMMU_BACKUP_WIDGET_H
