#ifndef HELPDIALOG_H
#define HELPDIALOG_H

#include <DBlurEffectWidget>
#include <DLabel>
#include <QList>
#include <QPair>
#include <QColor>
#include <DGuiApplicationHelper>

DWIDGET_USE_NAMESPACE

class QVBoxLayout;

struct HelpInfoItem {
    QString title;
    QString subTitle;
};

class HelpDialog : public DBlurEffectWidget
{
    Q_OBJECT
public:
    explicit HelpDialog(QWidget *parent = Q_NULLPTR);
    void setContentText(const QList<HelpInfoItem> &texts);
    void tipsPairList2HelpInfoItemList(const QList<QPair<QString, QString>> &tipsPairList, QList<HelpInfoItem> &itemList);
    static QPixmap getPixMapByThemeType(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);

private:
    void deleteLayout(QLayout* layout);

private:
    QVBoxLayout *m_mainLayout = nullptr;
};

#endif // HELPDIALOG_H
