//
// Created by uos on 2022/3/28.
//

#ifndef UOS_RECOVERY_SYSTEMBACKUPWIDGET_H
#define UOS_RECOVERY_SYSTEMBACKUPWIDGET_H

#include <DWidget>
#include <DGuiApplicationHelper>
#include <DLabel>
#include <DPushButton>
#include <DProgressBar>
#include <DLineEdit>
#include <DSuggestButton>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE
class SystemBackupWidget : public DWidget
{
    Q_OBJECT
public:
    explicit SystemBackupWidget(DWidget *parent = nullptr);
    void initUI();
    void setDestPartitionText(const QJsonObject &jsonObject);
    void setDestBtnEnabled(bool enable);
    void setTips(const QString &tips);
    void setNotes(const QString &txt);
    void setTipsStyleSheet(const QString &styleSheet);

Q_SIGNALS:
    void cancel();
    void start(const QString &remark);
    void notifySetDestPartition(QWidget *parent);
    void notifyBackupManage();

private Q_SLOTS:
    void onThemeChange();
    void onNoteTextChanged();

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    DPushButton *m_destBtn = nullptr;
    DProgressBar *m_storeUsed = nullptr;
    DLabel *m_labelDest = nullptr;
    DLabel *m_curPartitionText = nullptr;
    DLabel *m_storeText = nullptr;
    DPushButton *m_spaceManageBtn = nullptr;
    DLineEdit *m_lineEdit = nullptr;
    DLabel *m_ostreeTips = nullptr;
    DLabel *m_tips = nullptr;
    DPushButton *m_cancel = nullptr;
    DSuggestButton *m_start = nullptr;
};


#endif //UOS_RECOVERY_SYSTEMBACKUPWIDGET_H
