/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree;

import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.Node;
import org.apache.wicket.extensions.markup.html.repeater.util.ProviderSubset;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;

public abstract class AbstractTree<T>
extends Panel
implements IGenericComponent<Set<T>, AbstractTree<T>> {
    private static final long serialVersionUID = 1L;
    private ITreeProvider<T> provider;
    private IItemReuseStrategy itemReuseStrategy;

    protected AbstractTree(String id, ITreeProvider<T> provider) {
        this(id, provider, null);
    }

    protected AbstractTree(String id, ITreeProvider<T> provider, IModel<? extends Set<T>> state) {
        super(id, state);
        if (provider == null) {
            throw new IllegalArgumentException("argument [provider] cannot be null");
        }
        this.provider = provider;
    }

    public AbstractTree<T> setItemReuseStrategy(IItemReuseStrategy strategy) {
        this.itemReuseStrategy = strategy;
        return this;
    }

    public IItemReuseStrategy getItemReuseStrategy() {
        if (this.itemReuseStrategy == null) {
            return DefaultItemReuseStrategy.getInstance();
        }
        return this.itemReuseStrategy;
    }

    public ITreeProvider<T> getProvider() {
        return this.provider;
    }

    protected IModel<?> initModel() {
        IModel<Set<T>> model = super.initModel();
        if (model == null) {
            model = this.newModel();
        }
        return model;
    }

    protected IModel<Set<T>> newModel() {
        return new ProviderSubset<T>(this.provider).createModel();
    }

    public void expand(T t) {
        this.modelChanging();
        ((Set)this.getModelObject()).add(t);
        this.modelChanged();
        this.getRequestCycle().find(IPartialPageRequestHandler.class).ifPresent(target -> this.updateBranch(t, (IPartialPageRequestHandler)target));
    }

    public void collapse(T t) {
        this.modelChanging();
        ((Set)this.getModelObject()).remove(t);
        this.modelChanged();
        this.getRequestCycle().find(IPartialPageRequestHandler.class).ifPresent(target -> this.updateBranch(t, (IPartialPageRequestHandler)target));
    }

    public State getState(T t) {
        if (((Set)this.getModelObject()).contains(t)) {
            return State.EXPANDED;
        }
        return State.COLLAPSED;
    }

    protected void onDetach() {
        this.provider.detach();
        super.onDetach();
    }

    public Component newNodeComponent(String id, IModel<T> model) {
        return new Node<T>(id, this, model){
            private static final long serialVersionUID = 1L;

            @Override
            protected Component createContent(String id, IModel<T> model) {
                return AbstractTree.this.newContentComponent(id, model);
            }
        };
    }

    protected abstract Component newContentComponent(String var1, IModel<T> var2);

    public abstract void updateBranch(T var1, IPartialPageRequestHandler var2);

    public abstract void updateNode(T var1, IPartialPageRequestHandler var2);

    public static enum State {
        COLLAPSED,
        EXPANDED;

    }
}

