/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.Token;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaRule;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;

public class RutaRuleElement
extends Expression {
    protected List<RutaCondition> conditions;
    protected List<RutaAction> actions;
    protected Expression head;
    protected List<Expression> quantifierExpressions;
    private List<List<RutaRule>> inlinedRuleBlocks = new ArrayList<List<RutaRule>>();
    private String inlineMode;
    private boolean afterConcat;
    private boolean wildcard;
    private String label;

    public RutaRuleElement(int start, int end) {
        super(start, end);
    }

    public RutaRuleElement(int start, int end, Expression head, List<Expression> quantifierPartExpressions, List<RutaCondition> conditions, List<RutaAction> actions) {
        super(start, end);
        this.conditions = conditions != null ? conditions : new ArrayList<RutaCondition>();
        this.actions = actions != null ? actions : new ArrayList<RutaAction>();
        this.quantifierExpressions = quantifierPartExpressions != null ? quantifierPartExpressions : new ArrayList<Expression>();
        this.head = head;
    }

    public int getKind() {
        return 1067;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            if (this.head != null) {
                this.head.traverse(visitor);
            }
            if (this.quantifierExpressions != null) {
                for (Expression expression : this.quantifierExpressions) {
                    expression.traverse(visitor);
                }
            }
            if (this.conditions != null) {
                for (Expression expression : this.conditions) {
                    expression.traverse(visitor);
                }
            }
            if (this.actions != null) {
                for (Expression expression : this.actions) {
                    expression.traverse(visitor);
                }
            }
            if (this.inlinedRuleBlocks != null) {
                for (List list : this.inlinedRuleBlocks) {
                    for (RutaRule rule : list) {
                        rule.traverse(visitor);
                    }
                }
            }
            visitor.endvisit((Expression)this);
        }
    }

    public Expression getHead() {
        return this.head;
    }

    public List<RutaAction> getActions() {
        return this.actions;
    }

    public List<RutaCondition> getConditions() {
        return this.conditions;
    }

    public List<Expression> getQuantifierExpressions() {
        return this.quantifierExpressions;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " : " + super.toString();
    }

    public void addInlinedRules(List<RutaRule> inlinedRules) {
        RutaRule last;
        if (inlinedRules != null && !inlinedRules.isEmpty() && (last = inlinedRules.get(inlinedRules.size() - 1)) != null) {
            this.setEnd(last.sourceEnd());
        }
        this.inlinedRuleBlocks.add(inlinedRules);
    }

    public void setInlineMode(String mode) {
        this.inlineMode = mode;
    }

    public String getInlineMode() {
        return this.inlineMode;
    }

    public void setAfterConcat(Token p) {
        this.afterConcat = p != null;
    }

    public boolean isAfterConcat() {
        return this.afterConcat;
    }

    public void setAfterConcat(boolean afterConcat) {
        this.afterConcat = afterConcat;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public List<List<RutaRule>> getInlinedRuleBlocks() {
        return this.inlinedRuleBlocks;
    }

    public void setInlinedRuleBlocks(List<List<RutaRule>> inlinedRuleBlocks) {
        this.inlinedRuleBlocks = inlinedRuleBlocks;
    }
}

