/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.lookup;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.basjes.collections.PrefixMap;
import nl.basjes.collections.prefixmap.StringPrefixMap;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.yauaa.shaded.org.antlr.v4.runtime.tree.ParseTree;

public class StepLookupPrefix
extends Step {
    private final String lookupName;
    private final String defaultValue;
    private final PrefixMap<String> prefixMap;
    private final boolean canFail;

    private StepLookupPrefix() {
        this.lookupName = null;
        this.defaultValue = null;
        this.prefixMap = null;
        this.canFail = true;
    }

    public StepLookupPrefix(String lookupName, Map<String, String> prefixList, String defaultValue) {
        this.lookupName = lookupName;
        this.defaultValue = defaultValue;
        this.prefixMap = new StringPrefixMap(false);
        this.prefixMap.putAll(prefixList);
        this.canFail = defaultValue == null;
    }

    @Override
    public boolean canFail() {
        return this.canFail;
    }

    @Override
    public WalkList.WalkResult walk(@Nonnull ParseTree tree, @Nullable String value) {
        String actualValue = this.getActualValue(tree, value);
        String result = (String)((Object)this.prefixMap.getLongestMatch(actualValue));
        if (result == null) {
            if (this.defaultValue == null) {
                return null;
            }
            return this.walkNextStep(tree, this.defaultValue);
        }
        return this.walkNextStep(tree, result);
    }

    public String toString() {
        return "LookupPrefix(@" + this.lookupName + " ; default=" + this.defaultValue + ")";
    }
}

