/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.configuration2.Configuration;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.modules.Action;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;

public class InitContextsAction
implements Action {
    @TurbineConfiguration
    private Configuration conf;

    @Override
    public void doPerform(PipelineData pipelineData) throws NamingException {
        RunData data = pipelineData.getRunData();
        Hashtable<String, Properties> contextPropsList = new Hashtable<String, Properties>();
        Iterator contextKeys = this.conf.getKeys("context.");
        while (contextKeys.hasNext()) {
            String key = (String)contextKeys.next();
            int start = key.indexOf(".") + 1;
            int end = key.indexOf(".", start);
            String contextName = key.substring(start, end);
            Properties contextProps = null;
            contextProps = contextPropsList.containsKey(contextName) ? (Properties)contextPropsList.get(contextName) : new Properties();
            contextProps.put(key.substring(end + 1), this.conf.getString(key));
            contextPropsList.put(contextName, contextProps);
        }
        for (Map.Entry contextProps : contextPropsList.entrySet()) {
            InitialContext context = new InitialContext((Hashtable)contextProps.getValue());
            data.getJNDIContexts().put((String)contextProps.getKey(), context);
        }
    }
}

