/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto.cli;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.fulcrum.jce.crypto.CryptoUtil;
import org.apache.fulcrum.jce.crypto.StreamUtil;

public class CLI {
    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                CLI.printHelp();
                throw new IllegalArgumentException("Invalid command line");
            }
            String operationMode = args[0];
            if (operationMode.equals("file")) {
                CLI.processFiles(args);
            } else if (operationMode.equals("string")) {
                CLI.processString(args);
            }
        }
        catch (Exception e) {
            System.out.println("Error : " + e.getMessage());
        }
    }

    public static void printHelp() {
        System.out.println("Main file [enc|dec] passwd source [target]");
        System.out.println("Main string [enc|dec] passwd source");
    }

    public static void processFiles(String[] args) throws Exception {
        String cipherMode = args[1];
        char[] password = args[2].toCharArray();
        File sourceFile = new File(args[3]);
        File targetFile = null;
        if (args.length == 4) {
            targetFile = sourceFile;
        } else {
            boolean success;
            targetFile = new File(args[4]);
            File parentFile = targetFile.getParentFile();
            if (parentFile != null && !(success = parentFile.mkdirs())) {
                System.err.println("Failed to create directory");
            }
        }
        CLI.processFile(cipherMode, password, sourceFile, targetFile);
    }

    public static void processFile(String cipherMode, char[] password, File sourceFile, File targetFile) throws Exception {
        block7: {
            try (FileInputStream fis = new FileInputStream(sourceFile);){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (cipherMode.equals("dec")) {
                    System.out.println("Decrypting " + sourceFile.getAbsolutePath());
                    CryptoUtil.getInstance().decrypt(fis, baos, password);
                    fis.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    FileOutputStream fos = new FileOutputStream(targetFile);
                    StreamUtil.copy(bais, fos);
                    bais.close();
                    fos.close();
                    break block7;
                }
                if (cipherMode.equals("enc")) {
                    System.out.println("Encrypting " + sourceFile.getAbsolutePath());
                    CryptoUtil.getInstance().encrypt(fis, baos, password);
                    fis.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    FileOutputStream fos = new FileOutputStream(targetFile);
                    StreamUtil.copy(bais, fos);
                    bais.close();
                    fos.close();
                    break block7;
                }
                String msg = "Don't know what to do with : " + cipherMode;
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public static void processString(String[] args) throws Exception {
        String cipherMode = args[1];
        char[] password = args[2].toCharArray();
        String value = args[3];
        String result = null;
        result = cipherMode.equals("dec") ? CryptoUtil.getInstance().decryptString(value, password) : CryptoUtil.getInstance().encryptString(value, password);
        System.out.println(result);
    }
}

