/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.dynamic;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicPermission;
import org.apache.fulcrum.security.torque.om.TorqueDynamicPermissionPeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicRolePermission;
import org.apache.fulcrum.security.torque.om.TorqueDynamicRolePermissionPeer;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;

public abstract class TorqueAbstractDynamicPermission
extends TorqueAbstractSecurityEntity
implements DynamicPermission {
    private static final long serialVersionUID = -6857144824327889029L;
    private Set<Role> roleSet = null;

    protected List<TorqueDynamicRolePermission> getTorqueDynamicRolePermissionsJoinTorqueDynamicRole(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueDynamicRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
        return TorqueDynamicRolePermissionPeer.doSelectJoinTorqueDynamicRole(criteria, con);
    }

    public void addRole(Role role) {
        this.getRoles().add((SecurityEntity)role);
    }

    public RoleSet getRoles() {
        if (this.roleSet == null) {
            this.roleSet = new RoleSet();
        } else if (!(this.roleSet instanceof RoleSet)) {
            this.roleSet = new RoleSet(this.roleSet);
        }
        return (RoleSet)this.roleSet;
    }

    public <T extends Role> Set<T> getRolesAsSet() {
        return this.roleSet;
    }

    public void removeRole(Role role) {
        this.getRoles().remove((Object)role);
    }

    public void setRoles(RoleSet roleSet) {
        this.roleSet = roleSet != null ? roleSet : new RoleSet();
    }

    public <T extends Role> void setRolesAsSet(Set<T> roles) {
        this.setRoles(new RoleSet(roles));
    }

    public String getDatabaseName() {
        return TorqueDynamicPermissionPeer.DATABASE_NAME;
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        this.roleSet = new RoleSet();
        try {
            List<TorqueDynamicRolePermission> rolepermissions = this.getTorqueDynamicRolePermissionsJoinTorqueDynamicRole(new Criteria(), con);
            for (TorqueDynamicRolePermission tdrp : rolepermissions) {
                this.roleSet.add((Role)tdrp.getTorqueDynamicRole());
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(Connection con) throws TorqueException {
        if (this.roleSet != null) {
            Criteria criteria = new Criteria();
            criteria.where((Object)TorqueDynamicRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
            TorqueDynamicRolePermissionPeer.doDelete(criteria, con);
            for (Role r : this.roleSet) {
                TorqueDynamicRolePermission rp = new TorqueDynamicRolePermission();
                rp.setRoleId((Integer)r.getId());
                rp.setPermissionId(this.getEntityId());
                rp.save(con);
            }
        }
        try {
            this.save(con);
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    @Override
    public void delete() throws TorqueException {
        TorqueDynamicPermissionPeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

