/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.core.api.shared.CommonHtmlEvents;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;

public class CommonHtmlEventsUtil {
    public static long getMarkedEvents(UIComponent component) {
        return CommonHtmlEvents.getMarkedEvents((UIComponent)component);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String sourceId, String eventName, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName) throws IOException {
        return CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, sourceId, eventName, null, clientBehaviors, htmlAttrName, (String)component.getAttributes().get(componentProperty));
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue) throws IOException {
        return CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, null, eventName, eventParameters, clientBehaviors, htmlAttrName, attributeValue);
    }

    public static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent component, String sourceId, String eventName, Collection<ClientBehaviorContext.Parameter> eventParameters, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName, String attributeValue) throws IOException {
        List<ClientBehavior> cbl;
        List<ClientBehavior> list = cbl = clientBehaviors != null ? clientBehaviors.get(eventName) : null;
        if (cbl == null || cbl.isEmpty()) {
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, attributeValue);
        }
        if (cbl.size() > 1 || cbl.size() == 1 && attributeValue != null) {
            return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, component, sourceId, eventName, eventParameters, clientBehaviors, attributeValue, ""));
        }
        ClientBehaviorContext ctx = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)component, (String)eventName, (String)sourceId, eventParameters);
        return HtmlRendererUtils.renderHTMLStringAttribute(writer, componentProperty, htmlAttrName, cbl.get(0).getScript(ctx));
    }

    public static void renderBehaviorizedEventHandlers(FacesContext facesContext, ResponseWriter writer, long commonAttributesMarked, long commonEventsMarked, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, commonAttributesMarked, commonEventsMarked, uiComponent, null, clientBehaviors);
    }

    public static void renderBehaviorizedEventHandlers(FacesContext facesContext, ResponseWriter writer, long commonAttributesMarked, long commonEventsMarked, UIComponent uiComponent, String sourceId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if (commonAttributesMarked == 0L && commonEventsMarked == 0L) {
            return;
        }
        if ((commonAttributesMarked & 0x2000L) != 0L || (commonEventsMarked & 2L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onclick", uiComponent, sourceId, "click", clientBehaviors, "onclick");
        }
        if ((commonAttributesMarked & 0x4000L) != 0L || (commonEventsMarked & 4L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, sourceId, "dblclick", clientBehaviors, "ondblclick");
        }
        if ((commonAttributesMarked & 0x8000L) != 0L || (commonEventsMarked & 8L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, sourceId, "mousedown", clientBehaviors, "onmousedown");
        }
        if ((commonAttributesMarked & 0x10000L) != 0L || (commonEventsMarked & 0x10L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, sourceId, "mouseup", clientBehaviors, "onmouseup");
        }
        if ((commonAttributesMarked & 0x20000L) != 0L || (commonEventsMarked & 0x20L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, sourceId, "mouseover", clientBehaviors, "onmouseover");
        }
        if ((commonAttributesMarked & 0x40000L) != 0L || (commonEventsMarked & 0x40L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, sourceId, "mousemove", clientBehaviors, "onmousemove");
        }
        if ((commonAttributesMarked & 0x80000L) != 0L || (commonEventsMarked & 0x80L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, sourceId, "mouseout", clientBehaviors, "onmouseout");
        }
        if ((commonAttributesMarked & 0x100000L) != 0L || (commonEventsMarked & 0x100L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, sourceId, "keypress", clientBehaviors, "onkeypress");
        }
        if ((commonAttributesMarked & 0x200000L) != 0L || (commonEventsMarked & 0x200L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, sourceId, "keydown", clientBehaviors, "onkeydown");
        }
        if ((commonAttributesMarked & 0x400000L) != 0L || (commonEventsMarked & 0x400L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, sourceId, "keyup", clientBehaviors, "onkeyup");
        }
    }

    public static void renderBehaviorizedEventHandlersWithoutOnclick(FacesContext facesContext, ResponseWriter writer, long commonAttributesMarked, long commonEventsMarked, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        CommonHtmlEventsUtil.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, commonAttributesMarked, commonEventsMarked, uiComponent, null, clientBehaviors);
    }

    public static void renderBehaviorizedEventHandlersWithoutOnclick(FacesContext facesContext, ResponseWriter writer, long commonAttributesMarked, long commonEventsMarked, UIComponent uiComponent, String sourceId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if (commonAttributesMarked == 0L && commonEventsMarked == 0L) {
            return;
        }
        if ((commonAttributesMarked & 0x4000L) != 0L || (commonEventsMarked & 4L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", uiComponent, sourceId, "dblclick", clientBehaviors, "ondblclick");
        }
        if ((commonAttributesMarked & 0x8000L) != 0L || (commonEventsMarked & 8L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", uiComponent, sourceId, "mousedown", clientBehaviors, "onmousedown");
        }
        if ((commonAttributesMarked & 0x10000L) != 0L || (commonEventsMarked & 0x10L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", uiComponent, sourceId, "mouseup", clientBehaviors, "onmouseup");
        }
        if ((commonAttributesMarked & 0x20000L) != 0L || (commonEventsMarked & 0x20L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", uiComponent, sourceId, "mouseover", clientBehaviors, "onmouseover");
        }
        if ((commonAttributesMarked & 0x40000L) != 0L || (commonEventsMarked & 0x40L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", uiComponent, sourceId, "mousemove", clientBehaviors, "onmousemove");
        }
        if ((commonAttributesMarked & 0x80000L) != 0L || (commonEventsMarked & 0x80L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", uiComponent, sourceId, "mouseout", clientBehaviors, "onmouseout");
        }
        if ((commonAttributesMarked & 0x100000L) != 0L || (commonEventsMarked & 0x100L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", uiComponent, sourceId, "keypress", clientBehaviors, "onkeypress");
        }
        if ((commonAttributesMarked & 0x200000L) != 0L || (commonEventsMarked & 0x200L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", uiComponent, sourceId, "keydown", clientBehaviors, "onkeydown");
        }
        if ((commonAttributesMarked & 0x400000L) != 0L || (commonEventsMarked & 0x400L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", uiComponent, sourceId, "keyup", clientBehaviors, "onkeyup");
        }
    }

    public static void renderBehaviorizedFieldEventHandlers(FacesContext facesContext, ResponseWriter writer, long commonAttributesMarked, long commonEventsMarked, UIComponent uiComponent, String sourceId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if (commonAttributesMarked == 0L && commonEventsMarked == 0L) {
            return;
        }
        if ((commonAttributesMarked & 0x800000L) != 0L || (commonEventsMarked & 0x800L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, sourceId, "focus", clientBehaviors, "onfocus");
        }
        if ((commonAttributesMarked & 0x1000000L) != 0L || (commonEventsMarked & 0x1000L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, sourceId, "blur", clientBehaviors, "onblur");
        }
        if ((commonAttributesMarked & 0x800L) != 0L || (commonEventsMarked & 0x4000L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, sourceId, "change", clientBehaviors, "onchange");
        }
        if ((commonAttributesMarked & 0x1000L) != 0L || (commonEventsMarked & 0x2000L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, sourceId, "select", clientBehaviors, "onselect");
        }
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnfocus(FacesContext facesContext, ResponseWriter writer, long commonAttributesMarked, long commonEventsMarked, UIComponent uiComponent, String sourceId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if (commonAttributesMarked == 0L && commonEventsMarked == 0L) {
            return;
        }
        if ((commonAttributesMarked & 0x1000000L) != 0L || (commonEventsMarked & 0x1000L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, sourceId, "blur", clientBehaviors, "onblur");
        }
        if ((commonAttributesMarked & 0x800L) != 0L || (commonEventsMarked & 0x4000L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, sourceId, "change", clientBehaviors, "onchange");
        }
        if ((commonAttributesMarked & 0x1000L) != 0L || (commonEventsMarked & 0x2000L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, sourceId, "select", clientBehaviors, "onselect");
        }
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchange(FacesContext facesContext, ResponseWriter writer, long commonAttributesMarked, long commonEventsMarked, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        CommonHtmlEventsUtil.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, commonAttributesMarked, commonEventsMarked, uiComponent, null, clientBehaviors);
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchange(FacesContext facesContext, ResponseWriter writer, long commonAttributesMarked, long commonEventsMarked, UIComponent uiComponent, String sourceId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if (commonAttributesMarked == 0L && commonEventsMarked == 0L) {
            return;
        }
        if ((commonAttributesMarked & 0x800000L) != 0L || (commonEventsMarked & 0x800L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, sourceId, "focus", clientBehaviors, "onfocus");
        }
        if ((commonAttributesMarked & 0x1000000L) != 0L || (commonEventsMarked & 0x1000L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, sourceId, "blur", clientBehaviors, "onblur");
        }
        if ((commonAttributesMarked & 0x1000L) != 0L || (commonEventsMarked & 0x2000L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onselect", uiComponent, sourceId, "select", clientBehaviors, "onselect");
        }
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(FacesContext facesContext, ResponseWriter writer, long commonAttributesMarked, long commonEventsMarked, UIComponent uiComponent, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        CommonHtmlEventsUtil.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonAttributesMarked, commonEventsMarked, uiComponent, null, clientBehaviors);
    }

    public static void renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(FacesContext facesContext, ResponseWriter writer, long commonAttributesMarked, long commonEventsMarked, UIComponent uiComponent, String sourceId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        if (commonAttributesMarked == 0L && commonEventsMarked == 0L) {
            return;
        }
        if ((commonAttributesMarked & 0x800000L) != 0L || (commonEventsMarked & 0x800L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onfocus", uiComponent, sourceId, "focus", clientBehaviors, "onfocus");
        }
        if ((commonAttributesMarked & 0x1000000L) != 0L || (commonEventsMarked & 0x1000L) != 0L) {
            CommonHtmlEventsUtil.renderBehaviorizedAttribute(facesContext, writer, "onblur", uiComponent, sourceId, "blur", clientBehaviors, "onblur");
        }
    }
}

