/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.NameIterator;
import io.smallrye.config.PropertyName;
import java.util.List;
import java.util.Map;

public final class PropertyNamesMatcher {
    private final Map<String, List<PropertyName>> prefixesAndNames;
    private final int maxPrefixSegments;

    private PropertyNamesMatcher(Map<String, List<PropertyName>> prefixesAndNames) {
        this.prefixesAndNames = prefixesAndNames;
        int maxPrefixSegments = 0;
        for (String prefix : prefixesAndNames.keySet()) {
            int current = PropertyNamesMatcher.countSegments(prefix);
            if (current <= maxPrefixSegments) continue;
            maxPrefixSegments = current;
        }
        this.maxPrefixSegments = maxPrefixSegments;
    }

    public boolean matches(String name) {
        String prefix = null;
        List<PropertyName> propertyNames = null;
        NameIterator iterator = new NameIterator(name);
        for (int i = 0; i < this.maxPrefixSegments && iterator.hasNext(); ++i) {
            iterator.next();
        }
        while (iterator.hasPrevious() && (propertyNames = this.prefixesAndNames.get(prefix = iterator.getAllPreviousSegments())) == null) {
            iterator.previous();
        }
        if (propertyNames == null) {
            return false;
        }
        return PropertyNamesMatcher.matches(prefix, name, propertyNames);
    }

    public boolean matches(String prefix, String name) {
        return PropertyNamesMatcher.matches(prefix, name, this.prefixesAndNames.get(prefix));
    }

    private static boolean matches(String prefix, String name, List<PropertyName> names) {
        for (PropertyName propertyName : names) {
            boolean matches = PropertyName.equals(name, prefix.length() + 1, name.length() - prefix.length() - 1, propertyName.getName(), 0, propertyName.getName().length());
            if (!matches) continue;
            return true;
        }
        return false;
    }

    private static int countSegments(String prefix) {
        if (prefix.isEmpty()) {
            return 0;
        }
        int count = 1;
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    public static PropertyNamesMatcher matcher(Map<String, List<PropertyName>> prefixesAndNames) {
        return new PropertyNamesMatcher(prefixesAndNames);
    }
}

