/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;

final class JavaTimeSerializers {
    private JavaTimeSerializers() {
    }

    static final class ZoneOffsetSerializer
    implements SerializerShim<ZoneOffset> {
        ZoneOffsetSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, ZoneOffset zoneOffset) {
            output.writeString(zoneOffset.getId());
        }

        @Override
        public <I extends InputShim> ZoneOffset read(KryoShim<I, ?> kryo, I input, Class<ZoneOffset> clazz) {
            return ZoneOffset.of(input.readString());
        }
    }

    static final class ZonedDateTimeSerializer
    implements SerializerShim<ZonedDateTime> {
        ZonedDateTimeSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, ZonedDateTime zonedDateTime) {
            output.writeInt(zonedDateTime.getYear());
            output.writeInt(zonedDateTime.getMonthValue());
            output.writeInt(zonedDateTime.getDayOfMonth());
            output.writeInt(zonedDateTime.getHour());
            output.writeInt(zonedDateTime.getMinute());
            output.writeInt(zonedDateTime.getSecond());
            output.writeInt(zonedDateTime.getNano());
            output.writeString(zonedDateTime.getZone().getId());
        }

        @Override
        public <I extends InputShim> ZonedDateTime read(KryoShim<I, ?> kryo, I input, Class<ZonedDateTime> clazz) {
            return ZonedDateTime.of(input.readInt(), input.readInt(), input.readInt(), input.readInt(), input.readInt(), input.readInt(), input.readInt(), ZoneId.of(input.readString()));
        }
    }

    static final class YearMonthSerializer
    implements SerializerShim<YearMonth> {
        YearMonthSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, YearMonth monthDay) {
            output.writeInt(monthDay.getYear());
            output.writeInt(monthDay.getMonthValue());
        }

        @Override
        public <I extends InputShim> YearMonth read(KryoShim<I, ?> kryo, I input, Class<YearMonth> clazz) {
            return YearMonth.of(input.readInt(), input.readInt());
        }
    }

    static final class YearSerializer
    implements SerializerShim<Year> {
        YearSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Year year) {
            output.writeInt(year.getValue());
        }

        @Override
        public <I extends InputShim> Year read(KryoShim<I, ?> kryo, I input, Class<Year> clazz) {
            return Year.of(input.readInt());
        }
    }

    static final class PeriodSerializer
    implements SerializerShim<Period> {
        PeriodSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Period period) {
            output.writeInt(period.getYears());
            output.writeInt(period.getMonths());
            output.writeInt(period.getDays());
        }

        @Override
        public <I extends InputShim> Period read(KryoShim<I, ?> kryo, I input, Class<Period> clazz) {
            return Period.of(input.readInt(), input.readInt(), input.readInt());
        }
    }

    static final class OffsetTimeSerializer
    implements SerializerShim<OffsetTime> {
        OffsetTimeSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, OffsetTime offsetTime) {
            kryo.writeObject(output, offsetTime.toLocalTime());
            kryo.writeObject(output, offsetTime.getOffset());
        }

        @Override
        public <I extends InputShim> OffsetTime read(KryoShim<I, ?> kryo, I input, Class<OffsetTime> clazz) {
            return OffsetTime.of(kryo.readObject(input, LocalTime.class), kryo.readObject(input, ZoneOffset.class));
        }
    }

    static final class OffsetDateTimeSerializer
    implements SerializerShim<OffsetDateTime> {
        OffsetDateTimeSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, OffsetDateTime offsetDateTime) {
            kryo.writeObject(output, offsetDateTime.toLocalDateTime());
            kryo.writeObject(output, offsetDateTime.getOffset());
        }

        @Override
        public <I extends InputShim> OffsetDateTime read(KryoShim<I, ?> kryo, I input, Class<OffsetDateTime> clazz) {
            return OffsetDateTime.of(kryo.readObject(input, LocalDateTime.class), kryo.readObject(input, ZoneOffset.class));
        }
    }

    static final class MonthDaySerializer
    implements SerializerShim<MonthDay> {
        MonthDaySerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, MonthDay monthDay) {
            output.writeInt(monthDay.getMonthValue());
            output.writeInt(monthDay.getDayOfMonth());
        }

        @Override
        public <I extends InputShim> MonthDay read(KryoShim<I, ?> kryo, I input, Class<MonthDay> clazz) {
            return MonthDay.of(input.readInt(), input.readInt());
        }
    }

    static final class LocalTimeSerializer
    implements SerializerShim<LocalTime> {
        LocalTimeSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, LocalTime localTime) {
            output.writeLong(localTime.toNanoOfDay());
        }

        @Override
        public <I extends InputShim> LocalTime read(KryoShim<I, ?> kryo, I input, Class<LocalTime> clazz) {
            return LocalTime.ofNanoOfDay(input.readLong());
        }
    }

    static final class LocalDateTimeSerializer
    implements SerializerShim<LocalDateTime> {
        LocalDateTimeSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, LocalDateTime localDateTime) {
            output.writeInt(localDateTime.getYear());
            output.writeInt(localDateTime.getMonthValue());
            output.writeInt(localDateTime.getDayOfMonth());
            output.writeInt(localDateTime.getHour());
            output.writeInt(localDateTime.getMinute());
            output.writeInt(localDateTime.getSecond());
            output.writeInt(localDateTime.getNano());
        }

        @Override
        public <I extends InputShim> LocalDateTime read(KryoShim<I, ?> kryo, I input, Class<LocalDateTime> clazz) {
            return LocalDateTime.of(input.readInt(), input.readInt(), input.readInt(), input.readInt(), input.readInt(), input.readInt(), input.readInt());
        }
    }

    static final class LocalDateSerializer
    implements SerializerShim<LocalDate> {
        LocalDateSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, LocalDate localDate) {
            output.writeLong(localDate.toEpochDay());
        }

        @Override
        public <I extends InputShim> LocalDate read(KryoShim<I, ?> kryo, I input, Class<LocalDate> clazz) {
            return LocalDate.ofEpochDay(input.readLong());
        }
    }

    static final class InstantSerializer
    implements SerializerShim<Instant> {
        InstantSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Instant instant) {
            output.writeLong(instant.getEpochSecond());
            output.writeInt(instant.getNano());
        }

        @Override
        public <I extends InputShim> Instant read(KryoShim<I, ?> kryo, I input, Class<Instant> aClass) {
            return Instant.ofEpochSecond(input.readLong(), input.readInt());
        }
    }

    static final class DurationSerializer
    implements SerializerShim<Duration> {
        DurationSerializer() {
        }

        @Override
        public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, Duration duration) {
            output.writeLong(duration.toNanos());
        }

        @Override
        public <I extends InputShim> Duration read(KryoShim<I, ?> kryo, I input, Class<Duration> durationClass) {
            return Duration.ofNanos(input.readLong());
        }
    }
}

