/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor.parameter;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.ModelDriven;
import org.apache.struts2.action.NoParameters;
import org.apache.struts2.action.ParameterNameAware;
import org.apache.struts2.action.ParameterValueAware;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.interceptor.MethodFilterInterceptor;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.apache.struts2.ognl.OgnlUtil;
import org.apache.struts2.ognl.ThreadAllowlist;
import org.apache.struts2.security.AcceptedPatternsChecker;
import org.apache.struts2.security.DefaultAcceptedPatternsChecker;
import org.apache.struts2.security.ExcludedPatternsChecker;
import org.apache.struts2.util.ClearableValueStack;
import org.apache.struts2.util.DebugUtils;
import org.apache.struts2.util.MemberAccessValueStack;
import org.apache.struts2.util.ProxyUtil;
import org.apache.struts2.util.TextParseUtil;
import org.apache.struts2.util.ValueStack;
import org.apache.struts2.util.ValueStackFactory;
import org.apache.struts2.util.reflection.ReflectionContextState;

public class ParametersInterceptor
extends MethodFilterInterceptor {
    private static final Logger LOG = LogManager.getLogger(ParametersInterceptor.class);
    protected static final int PARAM_NAME_MAX_LENGTH = 100;
    private static final Pattern DMI_IGNORED_PATTERN = Pattern.compile("^(action|method):.*", 2);
    private int paramNameMaxLength = 100;
    private boolean devMode = false;
    private boolean dmiEnabled = false;
    protected boolean ordered = false;
    protected boolean requireAnnotations = false;
    protected boolean requireAnnotationsTransitionMode = false;
    private ValueStackFactory valueStackFactory;
    private OgnlUtil ognlUtil;
    protected ThreadAllowlist threadAllowlist;
    private ExcludedPatternsChecker excludedPatterns;
    private AcceptedPatternsChecker acceptedPatterns;
    private Set<Pattern> excludedValuePatterns = null;
    private Set<Pattern> acceptedValuePatterns = null;
    static final Comparator<String> rbCollator = (s1, s2) -> {
        int l2;
        int l1 = ParametersInterceptor.countOGNLCharacters(s1);
        return l1 < (l2 = ParametersInterceptor.countOGNLCharacters(s2)) ? -1 : (l2 < l1 ? 1 : s1.compareTo((String)s2));
    };

    @Inject
    public void setValueStackFactory(ValueStackFactory valueStackFactory) {
        this.valueStackFactory = valueStackFactory;
    }

    @Inject
    public void setOgnlUtil(OgnlUtil ognlUtil) {
        this.ognlUtil = ognlUtil;
    }

    @Inject
    public void setThreadAllowlist(ThreadAllowlist threadAllowlist) {
        this.threadAllowlist = threadAllowlist;
    }

    @Inject(value="struts.devMode")
    public void setDevMode(String mode) {
        this.devMode = BooleanUtils.toBoolean((String)mode);
    }

    @Inject(value="struts.parameters.requireAnnotations", required=false)
    public void setRequireAnnotations(String requireAnnotations) {
        this.requireAnnotations = BooleanUtils.toBoolean((String)requireAnnotations);
        if (!this.requireAnnotations) {
            String msg = "@StrutsParameter annotation requirement is disabled! We strongly recommend keeping it enabled to protect against critical vulnerabilities. Set the configuration `{}=true` to enable it. Please refer to the Struts 7.0 migration guide and security documentation for further information.";
            DebugUtils.logWarningForFirstOccurrence("strutsParameter", LOG, msg, "struts.parameters.requireAnnotations");
        }
    }

    @Inject(value="struts.parameters.requireAnnotations.transitionMode", required=false)
    public void setRequireAnnotationsTransitionMode(String transitionMode) {
        this.requireAnnotationsTransitionMode = BooleanUtils.toBoolean((String)transitionMode);
    }

    @Inject
    public void setExcludedPatterns(ExcludedPatternsChecker excludedPatterns) {
        this.excludedPatterns = excludedPatterns;
    }

    @Inject
    public void setAcceptedPatterns(AcceptedPatternsChecker acceptedPatterns) {
        this.acceptedPatterns = acceptedPatterns;
    }

    @Inject(value="struts.enable.DynamicMethodInvocation", required=false)
    protected void setDynamicMethodInvocation(String dmiEnabled) {
        this.dmiEnabled = Boolean.parseBoolean(dmiEnabled);
    }

    public void setParamNameMaxLength(int paramNameMaxLength) {
        this.paramNameMaxLength = paramNameMaxLength;
    }

    private static int countOGNLCharacters(String s) {
        int count = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c != '.' && c != '[') continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof NoParameters) {
            return invocation.invoke();
        }
        ActionContext actionContext = invocation.getInvocationContext();
        HttpParameters parameters = this.retrieveParameters(actionContext);
        if (parameters == null) {
            return invocation.invoke();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting params {}", (Object)StringUtils.normalizeSpace((String)this.getParameterLogMap(parameters)));
        }
        Map<String, Object> contextMap = actionContext.getContextMap();
        this.batchApplyReflectionContextState(contextMap, true);
        try {
            this.applyParameters(action, actionContext.getValueStack(), parameters);
        }
        finally {
            this.batchApplyReflectionContextState(contextMap, false);
        }
        return invocation.invoke();
    }

    protected HttpParameters retrieveParameters(ActionContext actionContext) {
        return actionContext.getParameters();
    }

    protected void addParametersToContext(ActionContext ac, Map<String, ?> newParams) {
    }

    protected void applyParameters(Object action, ValueStack stack, HttpParameters parameters) {
        Map<String, Parameter> acceptableParameters = this.toAcceptableParameters(parameters, action);
        ValueStack newStack = this.toNewStack(stack);
        this.batchApplyReflectionContextState(newStack.getContext(), true);
        this.applyMemberAccessProperties(newStack);
        this.applyParametersOnStack(newStack, acceptableParameters, action);
        if (newStack instanceof ClearableValueStack) {
            stack.getActionContext().withConversionErrors(newStack.getActionContext().getConversionErrors());
        }
        this.addParametersToContext(ActionContext.getContext(), acceptableParameters);
    }

    protected void batchApplyReflectionContextState(Map<String, Object> context, boolean value) {
        ReflectionContextState.setCreatingNullObjects(context, value);
        ReflectionContextState.setDenyMethodExecution(context, value);
        ReflectionContextState.setReportingConversionErrors(context, value);
    }

    protected ValueStack toNewStack(ValueStack stack) {
        ValueStack newStack = this.valueStackFactory.createValueStack(stack);
        if (newStack instanceof ClearableValueStack) {
            ClearableValueStack clearable = (ClearableValueStack)((Object)newStack);
            clearable.clearContextValues();
            newStack.getActionContext().withLocale(stack.getActionContext().getLocale()).withValueStack(stack);
        }
        return newStack;
    }

    protected void applyMemberAccessProperties(ValueStack stack) {
        if (!(stack instanceof MemberAccessValueStack)) {
            return;
        }
        MemberAccessValueStack accessValueStack = (MemberAccessValueStack)((Object)stack);
        accessValueStack.useAcceptProperties(this.acceptedPatterns.getAcceptedPatterns());
        accessValueStack.useExcludeProperties(this.excludedPatterns.getExcludedPatterns());
    }

    protected Map<String, Parameter> toAcceptableParameters(HttpParameters parameters, Object action) {
        HttpParameters newParams = this.initNewHttpParameters(parameters);
        Map<String, Parameter> acceptableParameters = this.initParameterMap();
        for (Map.Entry<String, Parameter> entry : newParams.entrySet()) {
            String parameterName = entry.getKey();
            Parameter parameterValue = entry.getValue();
            if (!this.isAcceptableParameter(parameterName, action) || !this.isAcceptableParameterValue(parameterValue, action)) continue;
            acceptableParameters.put(parameterName, parameterValue);
        }
        return acceptableParameters;
    }

    protected Map<String, Parameter> initParameterMap() {
        if (this.ordered) {
            return new TreeMap<String, Parameter>(this.getOrderedComparator());
        }
        return new TreeMap<String, Parameter>();
    }

    protected HttpParameters initNewHttpParameters(HttpParameters parameters) {
        if (this.ordered) {
            return HttpParameters.create().withComparator(this.getOrderedComparator()).withParent(parameters).build();
        }
        return HttpParameters.create().withParent(parameters).build();
    }

    protected void applyParametersOnStack(ValueStack stack, Map<String, Parameter> parameters, Object action) {
        for (Map.Entry<String, Parameter> entry : parameters.entrySet()) {
            try {
                stack.setParameter(entry.getKey(), entry.getValue().getObject());
            }
            catch (RuntimeException e) {
                if (!this.devMode) continue;
                this.notifyDeveloperParameterException(action, entry.getKey(), e.getMessage());
            }
        }
    }

    protected void notifyDeveloperParameterException(Object action, String property, String message) {
        String logMsg = String.format("Unexpected Exception caught setting '%s' on '%s: %s", property, action.getClass(), message);
        DebugUtils.notifyDeveloperOfError(LOG, action, logMsg);
    }

    protected boolean isAcceptableParameter(String name, Object action) {
        return this.isAcceptableName(name) && this.isAcceptableParameterNameAware(name, action) && this.isParameterAnnotatedAndAllowlist(name, action);
    }

    protected boolean isAcceptableParameterNameAware(String name, Object action) {
        ParameterNameAware nameAware;
        return !(action instanceof ParameterNameAware) || (nameAware = (ParameterNameAware)action).acceptableParameterName(name);
    }

    protected boolean isParameterAnnotatedAndAllowlist(String name, Object action) {
        if (!this.requireAnnotations) {
            return true;
        }
        long paramDepth = name.codePoints().mapToObj(c -> Character.valueOf((char)c)).filter(DefaultAcceptedPatternsChecker.NESTING_CHARS::contains).count();
        if (action instanceof ModelDriven && !ActionContext.getContext().getValueStack().peek().equals(action)) {
            LOG.debug("Model driven Action detected, exempting from @StrutsParameter annotation requirement");
            return true;
        }
        if (this.requireAnnotationsTransitionMode && paramDepth == 0L) {
            LOG.debug("Annotation transition mode enabled, exempting non-nested parameter [{}] from @StrutsParameter annotation requirement", (Object)name);
            return true;
        }
        int nestingIndex = StringUtils.indexOfAny((CharSequence)name, (String)DefaultAcceptedPatternsChecker.NESTING_CHARS_STR);
        String rootProperty = nestingIndex == -1 ? name : name.substring(0, nestingIndex);
        String normalisedRootProperty = Character.toLowerCase(rootProperty.charAt(0)) + rootProperty.substring(1);
        return this.hasValidAnnotatedMember(normalisedRootProperty, action, paramDepth);
    }

    protected boolean hasValidAnnotatedMember(String rootProperty, Object action, long paramDepth) {
        LOG.debug("Checking Action [{}] for a matching, correctly annotated member for property [{}]", (Object)action.getClass().getSimpleName(), (Object)rootProperty);
        BeanInfo beanInfo = this.getBeanInfo(action);
        if (beanInfo == null) {
            return this.hasValidAnnotatedField(action, rootProperty, paramDepth);
        }
        Optional<PropertyDescriptor> propDescOpt = Arrays.stream(beanInfo.getPropertyDescriptors()).filter(desc -> desc.getName().equals(rootProperty)).findFirst();
        if (propDescOpt.isEmpty()) {
            return this.hasValidAnnotatedField(action, rootProperty, paramDepth);
        }
        if (this.hasValidAnnotatedPropertyDescriptor(action, propDescOpt.get(), paramDepth)) {
            return true;
        }
        return this.hasValidAnnotatedField(action, rootProperty, paramDepth);
    }

    protected boolean hasValidAnnotatedPropertyDescriptor(Object action, PropertyDescriptor propDesc, long paramDepth) {
        Method relevantMethod;
        Class<?> actionClass = this.ultimateClass(action);
        Method method = relevantMethod = paramDepth == 0L ? propDesc.getWriteMethod() : propDesc.getReadMethod();
        if (relevantMethod == null) {
            return false;
        }
        if ((long)this.getPermittedInjectionDepth(relevantMethod) < paramDepth) {
            String logMessage = String.format("Parameter injection for method [%s] on Action [%s] rejected. Ensure it is annotated with @StrutsParameter with an appropriate 'depth'.", relevantMethod.getName(), relevantMethod.getDeclaringClass().getName());
            if (this.devMode) {
                DebugUtils.notifyDeveloperOfError(LOG, action, logMessage);
            } else {
                LOG.debug(logMessage);
            }
            return false;
        }
        LOG.debug("Success: Matching annotated method [{}] found for property [{}] of depth [{}] on Action [{}]", (Object)relevantMethod.getName(), (Object)propDesc.getName(), (Object)paramDepth, (Object)actionClass.getSimpleName());
        if (paramDepth >= 1L) {
            this.allowlistClass(propDesc.getPropertyType());
        }
        if (paramDepth >= 2L) {
            this.allowlistReturnTypeIfParameterized(relevantMethod);
        }
        return true;
    }

    protected void allowlistReturnTypeIfParameterized(Method method) {
        this.allowlistParameterizedTypeArg(method.getGenericReturnType());
    }

    protected void allowlistParameterizedTypeArg(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return;
        }
        Type[] paramTypes = ((ParameterizedType)genericType).getActualTypeArguments();
        this.allowlistParamType(paramTypes[0]);
        if (paramTypes.length > 1) {
            this.allowlistParamType(paramTypes[1]);
        }
    }

    protected void allowlistParamType(Type paramType) {
        if (paramType instanceof Class) {
            Class clazz = (Class)paramType;
            this.allowlistClass(clazz);
        }
    }

    protected void allowlistClass(Class<?> clazz) {
        this.threadAllowlist.allowClassHierarchy(clazz);
    }

    protected boolean hasValidAnnotatedField(Object action, String fieldName, long paramDepth) {
        Field field;
        Class<?> actionClass = this.ultimateClass(action);
        LOG.debug("No matching annotated method found for property [{}] of depth [{}] on Action [{}], now also checking for public field", (Object)fieldName, (Object)paramDepth, (Object)actionClass.getSimpleName());
        try {
            field = actionClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            LOG.debug("Matching field for property [{}] not found on Action [{}]", (Object)fieldName, (Object)actionClass.getSimpleName());
            return false;
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            LOG.debug("Matching field [{}] is not public on Action [{}]", (Object)field.getName(), (Object)actionClass.getSimpleName());
            return false;
        }
        if ((long)this.getPermittedInjectionDepth(field) < paramDepth) {
            String logMessage = String.format("Parameter injection for field [%s] on Action [%s] rejected. Ensure it is annotated with @StrutsParameter with an appropriate 'depth'.", field.getName(), actionClass.getName());
            if (this.devMode) {
                DebugUtils.notifyDeveloperOfError(LOG, action, logMessage);
            } else {
                LOG.debug(logMessage);
            }
            return false;
        }
        LOG.debug("Success: Matching annotated public field [{}] found for property of depth [{}] on Action [{}]", (Object)field.getName(), (Object)paramDepth, (Object)actionClass.getSimpleName());
        if (paramDepth >= 1L) {
            this.allowlistClass(field.getType());
        }
        if (paramDepth >= 2L) {
            this.allowlistFieldIfParameterized(field);
        }
        return true;
    }

    protected void allowlistFieldIfParameterized(Field field) {
        this.allowlistParameterizedTypeArg(field.getGenericType());
    }

    protected int getPermittedInjectionDepth(AnnotatedElement element) {
        StrutsParameter annotation = this.getParameterAnnotation(element);
        if (annotation == null) {
            return -1;
        }
        return annotation.depth();
    }

    protected StrutsParameter getParameterAnnotation(AnnotatedElement element) {
        return element.getAnnotation(StrutsParameter.class);
    }

    protected Class<?> ultimateClass(Object action) {
        if (ProxyUtil.isProxy(action)) {
            return ProxyUtil.ultimateTargetClass(action);
        }
        return action.getClass();
    }

    protected BeanInfo getBeanInfo(Object action) {
        Class<?> actionClass = this.ultimateClass(action);
        try {
            return this.ognlUtil.getBeanInfo(actionClass);
        }
        catch (IntrospectionException e) {
            LOG.warn("Error introspecting Action {} for parameter injection validation", actionClass, (Object)e);
            return null;
        }
    }

    protected boolean isAcceptableParameterValue(Parameter param, Object action) {
        return this.isAcceptableParameterValueAware(param, action) && this.isAcceptableValue(param.getName(), param.getValue());
    }

    protected boolean isAcceptableParameterValueAware(Parameter param, Object action) {
        ParameterValueAware valueAware;
        return !(action instanceof ParameterValueAware) || (valueAware = (ParameterValueAware)action).acceptableParameterValue(param.getValue());
    }

    protected Comparator<String> getOrderedComparator() {
        return rbCollator;
    }

    protected String getParameterLogMap(HttpParameters parameters) {
        if (parameters == null) {
            return "NONE";
        }
        return parameters.entrySet().stream().map(entry -> String.format("%s => %s ", entry.getKey(), ((Parameter)entry.getValue()).getValue())).collect(Collectors.joining());
    }

    protected boolean isAcceptableName(String name) {
        boolean accepted;
        if (this.isIgnoredDMI(name)) {
            LOG.trace("DMI is enabled, ignoring DMI method: {}", (Object)name);
            return false;
        }
        boolean bl = accepted = this.isWithinLengthLimit(name) && !this.isExcluded(name) && this.isAccepted(name);
        if (this.devMode && accepted) {
            LOG.debug("Parameter [{}] was accepted and will be appended to action!", (Object)name);
        }
        return accepted;
    }

    private boolean isIgnoredDMI(String name) {
        if (!this.dmiEnabled) {
            return false;
        }
        return DMI_IGNORED_PATTERN.matcher(name).matches();
    }

    protected boolean isAcceptableValue(String name, String value) {
        boolean accepted;
        boolean bl = accepted = value == null || value.isEmpty() || !this.isParamValueExcluded(value) && this.isParamValueAccepted(value);
        if (!accepted) {
            String message = "Value [{}] of parameter [{}] was not accepted and will be dropped!";
            if (this.devMode) {
                LOG.warn(message, (Object)StringUtils.normalizeSpace((String)value), (Object)StringUtils.normalizeSpace((String)name));
            } else {
                LOG.debug(message, (Object)StringUtils.normalizeSpace((String)value), (Object)StringUtils.normalizeSpace((String)name));
            }
        }
        return accepted;
    }

    protected boolean isWithinLengthLimit(String name) {
        boolean matchLength;
        boolean bl = matchLength = name.length() <= this.paramNameMaxLength;
        if (!matchLength) {
            if (this.devMode) {
                LOG.warn("Parameter [{}] is too long, allowed length is [{}]. Use Interceptor Parameter Overriding to override the limit, see more at\nhttps://struts.apache.org/core-developers/interceptors.html#interceptor-parameter-overriding", (Object)name, (Object)this.paramNameMaxLength);
            } else {
                LOG.warn("Parameter [{}] is too long, allowed length is [{}]", (Object)name, (Object)this.paramNameMaxLength);
            }
        }
        return matchLength;
    }

    protected boolean isAccepted(String paramName) {
        AcceptedPatternsChecker.IsAccepted result = this.acceptedPatterns.isAccepted(paramName);
        if (!result.isAccepted()) {
            if (this.devMode) {
                LOG.warn("Parameter [{}] didn't match accepted pattern [{}]! See Accepted / Excluded patterns at\nhttps://struts.apache.org/security/#accepted--excluded-patterns", (Object)paramName, (Object)result.getAcceptedPattern());
            } else {
                LOG.debug("Parameter [{}] didn't match accepted pattern [{}]!", (Object)paramName, (Object)result.getAcceptedPattern());
            }
            return false;
        }
        return true;
    }

    protected boolean isExcluded(String paramName) {
        ExcludedPatternsChecker.IsExcluded result = this.excludedPatterns.isExcluded(paramName);
        if (result.isExcluded()) {
            if (this.devMode) {
                LOG.warn("Parameter [{}] matches excluded pattern [{}]! See Accepted / Excluded patterns at\nhttps://struts.apache.org/security/#accepted--excluded-patterns", (Object)paramName, (Object)result.getExcludedPattern());
            } else {
                LOG.debug("Parameter [{}] matches excluded pattern [{}]!", (Object)paramName, (Object)result.getExcludedPattern());
            }
            return true;
        }
        return false;
    }

    protected boolean isParamValueExcluded(String value) {
        if (!this.hasParamValuesToExclude()) {
            LOG.debug("'excludedValuePatterns' not defined so anything is allowed");
            return false;
        }
        for (Pattern excludedValuePattern : this.excludedValuePatterns) {
            if (!excludedValuePattern.matcher(value).matches()) continue;
            if (this.devMode) {
                LOG.warn("Parameter value [{}] matches excluded pattern [{}]! See Accepting/Excluding parameter values at\nhttps://struts.apache.org/core-developers/parameters-interceptor#excluding-parameter-values", (Object)value, this.excludedValuePatterns);
            } else {
                LOG.debug("Parameter value [{}] matches excluded pattern [{}]", (Object)value, (Object)excludedValuePattern);
            }
            return true;
        }
        return false;
    }

    protected boolean isParamValueAccepted(String value) {
        if (!this.hasParamValuesToAccept()) {
            LOG.debug("'acceptedValuePatterns' not defined so anything is allowed");
            return true;
        }
        for (Pattern acceptedValuePattern : this.acceptedValuePatterns) {
            if (!acceptedValuePattern.matcher(value).matches()) continue;
            return true;
        }
        if (this.devMode) {
            LOG.warn("Parameter value [{}] didn't match accepted pattern [{}]! See Accepting/Excluding parameter values at\nhttps://struts.apache.org/core-developers/parameters-interceptor#excluding-parameter-values", (Object)value, this.acceptedValuePatterns);
        } else {
            LOG.debug("Parameter value [{}] was not accepted!", (Object)value);
        }
        return false;
    }

    private boolean hasParamValuesToExclude() {
        return this.excludedValuePatterns != null && !this.excludedValuePatterns.isEmpty();
    }

    private boolean hasParamValuesToAccept() {
        return this.acceptedValuePatterns != null && !this.acceptedValuePatterns.isEmpty();
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setAcceptParamNames(String commaDelim) {
        this.acceptedPatterns.setAcceptedPatterns(commaDelim);
    }

    public void setExcludeParams(String commaDelim) {
        this.excludedPatterns.setExcludedPatterns(commaDelim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcceptedValuePatterns(String commaDelimitedPatterns) {
        Set<String> patterns = TextParseUtil.commaDelimitedStringToSet(commaDelimitedPatterns);
        if (this.acceptedValuePatterns == null) {
            LOG.debug("Sets accepted value patterns to [{}], note this may impact the safety of your application!", patterns);
        } else {
            LOG.warn("Replacing accepted patterns [{}] with [{}], be aware that this may impact safety of your application!", this.acceptedValuePatterns, patterns);
        }
        this.acceptedValuePatterns = new HashSet<Pattern>(patterns.size());
        try {
            for (String pattern : patterns) {
                this.acceptedValuePatterns.add(Pattern.compile(pattern, 2));
            }
        }
        finally {
            this.acceptedValuePatterns = Collections.unmodifiableSet(this.acceptedValuePatterns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExcludedValuePatterns(String commaDelimitedPatterns) {
        Set<String> patterns = TextParseUtil.commaDelimitedStringToSet(commaDelimitedPatterns);
        if (this.excludedValuePatterns == null) {
            LOG.debug("Setting excluded value patterns to [{}]", patterns);
        } else {
            LOG.warn("Replacing excluded value patterns [{}] with [{}], be aware that this may impact safety of your application!", this.excludedValuePatterns, patterns);
        }
        this.excludedValuePatterns = new HashSet<Pattern>(patterns.size());
        try {
            for (String pattern : patterns) {
                this.excludedValuePatterns.add(Pattern.compile(pattern, 2));
            }
        }
        finally {
            this.excludedValuePatterns = Collections.unmodifiableSet(this.excludedValuePatterns);
        }
    }
}

