/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.render;

import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.request.render.NoSuchRendererException;
import org.apache.tiles.request.render.Renderer;
import org.apache.tiles.request.render.RendererFactory;

public class BasicRendererFactory
implements RendererFactory {
    protected Map<String, Renderer> renderers = new HashMap<String, Renderer>();
    protected Renderer defaultRenderer;

    @Override
    public Renderer getRenderer(String name) {
        Renderer retValue;
        if (name != null) {
            retValue = this.renderers.get(name);
            if (retValue == null) {
                throw new NoSuchRendererException("Cannot find a renderer named '" + name + "'");
            }
        } else {
            retValue = this.defaultRenderer;
        }
        return retValue;
    }

    public void setDefaultRenderer(Renderer renderer) {
        this.defaultRenderer = renderer;
    }

    public void registerRenderer(String name, Renderer renderer) {
        this.renderers.put(name, renderer);
    }
}

