/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;

@Mojo(name="attach-features", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AttachFeaturesMojo
extends AbstractFeatureMojo {
    @Parameter(name="attachMainFeatures", defaultValue="true")
    private boolean attachMainFeatures;
    @Parameter(name="attachTestFeatures", defaultValue="false")
    private boolean attachTestFeatures;
    @Parameter(name="createReferenceFile", defaultValue="false")
    private boolean createReferenceFile;
    @Parameter(name="referenceFileClassifier")
    private String referenceFileClassifier;
    @Parameter(name="includeBundleMetadata", defaultValue="false")
    private boolean includeBundleMetadata;
    private static final Map<String, Map.Entry<String, String>> METADATA_CACHE = new ConcurrentHashMap<String, Map.Entry<String, String>>();
    private static final Map.Entry<String, String> NOT_FOUND = new AbstractMap.SimpleImmutableEntry<String, String>("NULL", "NULL");

    private void attach(Feature feature) throws MojoExecutionException {
        String classifier = feature.getId().getClassifier();
        boolean changed = false;
        if (this.includeBundleMetadata) {
            for (Artifact bundle : feature.getBundles()) {
                if (bundle.getMetadata().get("Bundle-SymbolicName") != null) continue;
                Map.Entry<String, String> value = METADATA_CACHE.get(bundle.getId().toMvnId());
                if (value == null) {
                    org.apache.maven.artifact.Artifact source = ProjectHelper.getOrResolveArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.repoSystem, bundle.getId());
                    try (JarFile jarFile = new JarFile(source.getFile());){
                        String symbolicName = jarFile.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
                        String version = jarFile.getManifest().getMainAttributes().getValue("Bundle-Version");
                        if (symbolicName != null && version != null) {
                            int idx = symbolicName.indexOf(";");
                            value = new AbstractMap.SimpleImmutableEntry<String, String>(idx == -1 ? symbolicName : symbolicName.substring(0, idx), version);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (value == null) {
                        value = NOT_FOUND;
                    }
                    METADATA_CACHE.put(bundle.getId().toMvnId(), value);
                }
                if (value == NOT_FOUND) continue;
                bundle.getMetadata().put("Bundle-SymbolicName", value.getKey());
                bundle.getMetadata().put("Bundle-Version", value.getValue());
                changed = true;
            }
        }
        File outputFile = ProjectHelper.createTmpFeatureFile(this.project, feature, changed);
        if (this.project.getPackaging().equals("slingosgifeature") && classifier == null) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, "slingosgifeature", classifier, outputFile);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPreconditions();
        ArrayList<String> featureUrls = new ArrayList<String>();
        this.attachClassifierFeatures(ProjectHelper.getFeatures(this.project), featureUrls, this.attachMainFeatures);
        this.attachClassifierFeatures(ProjectHelper.getTestFeatures(this.project), featureUrls, this.attachTestFeatures);
        if (this.createReferenceFile) {
            this.createReferenceFile(featureUrls);
        }
    }

    private void createReferenceFile(List<String> featureUrls) throws MojoExecutionException {
        if (featureUrls.isEmpty()) {
            this.getLog().warn((CharSequence)"Create reference file is enabled but no features are attached. Skipping reference file generation.");
        } else {
            String fileName = "references";
            if (this.referenceFileClassifier != null) {
                fileName = fileName.concat("-").concat(this.referenceFileClassifier);
            }
            fileName = fileName.concat(".ref");
            File outputFile = new File(this.getTmpDir(), fileName);
            outputFile.getParentFile().mkdirs();
            try (FileWriter w = new FileWriter(outputFile);){
                for (String url : featureUrls) {
                    w.write(url);
                    ((Writer)w).write(10);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write feature reference file to " + String.valueOf(outputFile), (Exception)e);
            }
            this.projectHelper.attachArtifact(this.project, "ref", this.referenceFileClassifier, outputFile);
        }
    }

    void attachClassifierFeatures(Map<String, Feature> features, List<String> featureUrls, boolean addSourceFeatures) throws MojoExecutionException {
        for (Map.Entry<String, Feature> entry : features.entrySet()) {
            boolean add = ProjectHelper.isAggregate(entry.getKey()) ? ProjectHelper.isAttachAggregate(entry.getKey()) : addSourceFeatures;
            if (!add) continue;
            this.attach(entry.getValue());
            featureUrls.add(entry.getValue().getId().toMvnUrl());
        }
    }
}

