/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.Analyser;
import org.apache.sling.feature.analyser.AnalyserResult;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.Scan;
import org.apache.sling.feature.scanner.Scanner;

@Mojo(name="analyse-features", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AnalyseFeaturesMojo
extends AbstractIncludingFeatureMojo {
    @Parameter
    private List<Scan> scans;
    @Parameter
    private Dependency framework;
    @Parameter(defaultValue="true")
    private boolean logWarnings;
    @Parameter(defaultValue="true", property="failon.analyser.errors")
    private boolean failOnAnalyserErrors;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Scanner scanner;
        this.checkPreconditions();
        List<Scan> list = this.scans;
        if (list == null || list.isEmpty()) {
            Scan a = new Scan();
            a.setFilesInclude("**/*.*");
            list = Collections.singletonList(a);
        }
        this.getLog().debug((CharSequence)MessageUtils.buffer().a((CharSequence)"Setting up the ").strong((Object)"Scanner").a((CharSequence)"...").toString());
        try {
            scanner = new Scanner(this.getArtifactProvider());
        }
        catch (IOException e) {
            throw new MojoExecutionException("A fatal error occurred while setting up the Scanner, see error cause:", (Exception)e);
        }
        this.getLog().debug((CharSequence)MessageUtils.buffer().strong((Object)"Scanner").a((CharSequence)" successfully set up").toString());
        FeatureProvider featureProvider = this.getFeatureProvider();
        LinkedHashMap<Feature, List> results = new LinkedHashMap<Feature, List>();
        for (Scan an : list) {
            try {
                Map<String, Map<String, String>> taskConfiguration = an.getTaskConfiguration();
                this.getLog().debug((CharSequence)MessageUtils.buffer().a((CharSequence)"Setting up the ").strong((Object)"analyser").a((CharSequence)" with following configuration:").toString());
                this.getLog().debug((CharSequence)(" * Task Configuration = " + String.valueOf(taskConfiguration)));
                Set<String> includedTasks = an.getIncludeTasks();
                if (includedTasks == null) {
                    includedTasks = new HashSet<String>();
                    includedTasks.add("bundle-packages");
                    includedTasks.add("requirements-capabilities");
                    includedTasks.add("apis-jar");
                    includedTasks.add("repoinit");
                    if (an.getExcludeTasks() != null) {
                        includedTasks.removeAll(an.getExcludeTasks());
                        if (includedTasks.isEmpty()) {
                            includedTasks = null;
                        }
                    }
                }
                this.getLog().debug((CharSequence)(" * Include Tasks = " + String.valueOf(includedTasks)));
                this.getLog().debug((CharSequence)(" * Exclude Tasks = " + String.valueOf(an.getExcludeTasks())));
                Analyser analyser = new Analyser(scanner, taskConfiguration, includedTasks, an.getExcludeTasks());
                this.getLog().debug((CharSequence)MessageUtils.buffer().strong((Object)"Analyser").a((CharSequence)" successfully set up").toString());
                this.getLog().debug((CharSequence)"Retrieving Feature files...");
                Collection<Feature> features = this.getSelectedFeatures(an).values();
                if (features.isEmpty()) {
                    this.getLog().debug((CharSequence)"There are no associated feature files to current project, plugin execution will be skipped");
                    continue;
                }
                this.getLog().debug((CharSequence)"Starting analysis of features...");
                for (Feature f : features) {
                    try {
                        this.getLog().debug((CharSequence)MessageUtils.buffer().a((CharSequence)"Analyzing feature ").strong((Object)f.getId().toMvnId()).a((CharSequence)" ...").toString());
                        Dependency fwk = an.getFramework();
                        if (fwk == null) {
                            fwk = this.framework;
                        }
                        AnalyserResult result = analyser.analyse(f, ProjectHelper.toArtifactId(fwk), featureProvider);
                        results.computeIfAbsent(f, key -> new ArrayList()).add(result);
                    }
                    catch (Exception t) {
                        throw new MojoFailureException("Exception during analysing feature " + f.getId().toMvnId() + " : " + t.getMessage(), (Throwable)t);
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("A fatal error occurred while setting up the analyzer, see error cause:", (Exception)e);
            }
            finally {
                this.getLog().debug((CharSequence)"Features analysis complete");
            }
        }
        boolean hasErrors = false;
        for (Map.Entry entry : results.entrySet()) {
            String message;
            Feature f = (Feature)entry.getKey();
            List result = (List)entry.getValue();
            List warnings = result.stream().flatMap(r -> r.getWarnings().stream()).collect(Collectors.toList());
            List errors = result.stream().flatMap(r -> r.getErrors().stream()).collect(Collectors.toList());
            if ((warnings.isEmpty() || !this.logWarnings) && errors.isEmpty()) {
                this.getLog().debug((CharSequence)MessageUtils.buffer().a((CharSequence)"feature ").project((Object)f.getId().toMvnId()).a((CharSequence)" succesfully passed all analysis").toString());
                continue;
            }
            if (!errors.isEmpty()) {
                message = this.logWarnings && !warnings.isEmpty() ? "errors and warnings" : "errors";
                hasErrors = true;
            } else {
                message = "warnings";
            }
            String m = "Analyser detected ".concat(message).concat(" on feature '").concat(f.getId().toMvnId()).concat("'.");
            if (hasErrors) {
                this.getLog().error((CharSequence)m);
            } else {
                this.getLog().warn((CharSequence)m);
            }
            if (this.logWarnings) {
                for (String msg : warnings) {
                    this.getLog().warn((CharSequence)msg);
                }
            }
            for (String msg : errors) {
                this.getLog().error((CharSequence)msg);
            }
        }
        if (hasErrors) {
            if (this.failOnAnalyserErrors) {
                throw new MojoFailureException("One or more feature analyser(s) detected feature error(s), please read the plugin log for more details");
            }
            this.getLog().warn((CharSequence)"Errors found during analyser run, but this plugin is configured to ignore errors and continue the build!");
        }
    }

    protected ArtifactProvider getArtifactProvider() {
        return new ArtifactProvider(){

            public URL provide(ArtifactId id) {
                try {
                    return ProjectHelper.getOrResolveArtifact(AnalyseFeaturesMojo.this.project, AnalyseFeaturesMojo.this.mavenSession, AnalyseFeaturesMojo.this.artifactHandlerManager, AnalyseFeaturesMojo.this.repoSystem, id).getFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    AnalyseFeaturesMojo.this.getLog().debug((CharSequence)("Malformed url " + e.getMessage()), (Throwable)e);
                    return null;
                }
            }
        };
    }

    protected FeatureProvider getFeatureProvider() {
        return new AbstractFeatureMojo.BaseFeatureProvider();
    }
}

