/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.AccessDeniedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.LongUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.CacheConfiguration;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.cache.CacheLoader;
import org.apache.jackrabbit.oak.spi.security.user.cache.CachePrincipalFactory;
import org.apache.jackrabbit.oak.spi.security.user.cache.CachedMembershipReader;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachedPrincipalMembershipReader
implements CachedMembershipReader {
    private static final Logger LOG = LoggerFactory.getLogger(CachedPrincipalMembershipReader.class);
    private static final int MAX_CACHE_TRACKING_ENTRIES = 100;
    private static final Map<UserConfiguration, Map<String, Long>> CACHE_UPDATES = new ConcurrentHashMap<UserConfiguration, Map<String, Long>>();
    private final CachePrincipalFactory principalFactory;
    private final UserConfiguration config;
    private final Root root;
    private final long expiration;
    private final long maxStale;
    private final String propertyName;
    private final int membershipThreshold;
    private final String expirationPropertyName;

    CachedPrincipalMembershipReader(@NotNull CacheConfiguration cacheConfiguration, @NotNull Root root, @NotNull CachePrincipalFactory principalFactory) {
        this.expiration = cacheConfiguration.getExpiration();
        this.maxStale = cacheConfiguration.getMaxStale();
        this.propertyName = cacheConfiguration.getPropertyName();
        this.expirationPropertyName = cacheConfiguration.getExpirationPropertyName();
        this.config = cacheConfiguration.getUserConfiguration();
        this.membershipThreshold = cacheConfiguration.getMembershipThreshold();
        this.root = root;
        this.principalFactory = principalFactory;
    }

    @Override
    public Set<Principal> readMembership(@NotNull Tree authorizableTree, CacheLoader cacheLoader) {
        if (UserUtil.isType(authorizableTree, AuthorizableType.USER)) {
            return this.readGroupsFromCache(authorizableTree, cacheLoader);
        }
        return cacheLoader.load(authorizableTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Principal> readGroupsFromCache(@NotNull Tree authorizableTree, CacheLoader loader) {
        long now;
        Set<Principal> groups = Collections.emptySet();
        String authorizablePath = authorizableTree.getPath();
        Tree principalCache = authorizableTree.getChild("rep:cache");
        long expirationTime = this.readExpirationTime(principalCache);
        if (CachedPrincipalMembershipReader.isValidCache(expirationTime, now = System.currentTimeMillis()) && this.hasPropertyCached(principalCache)) {
            LOG.debug("Reading membership from cache for '{}'", (Object)authorizablePath);
            return this.serveGroupsFromCache(principalCache);
        }
        Map<String, Long> updates = this.getCacheUpdateMap();
        long marker = Thread.currentThread().getId();
        try {
            boolean updateCache;
            Map<String, Long> map = updates;
            synchronized (map) {
                updateCache = updates.computeIfAbsent(authorizablePath, key -> marker) == marker;
            }
            if (updateCache) {
                groups = loader.load(authorizableTree);
                this.writeGroupsToCache(authorizableTree, groups);
            } else if (this.canServeStaleCache(expirationTime, now) && this.hasCacheValues(principalCache)) {
                LOG.debug("Another thread is updating the cache, returning a stale cache for '{}'.", (Object)authorizablePath);
                groups = this.serveGroupsFromCache(principalCache);
            } else {
                LOG.debug("This thread is not allowed to serve a stale cache; reading from provider without caching.");
                groups = loader.load(authorizableTree);
            }
        }
        catch (AccessDeniedException | CommitFailedException e) {
            LOG.debug("Failed to cache membership: {}", (Object)e.getMessage());
        }
        finally {
            Map<String, Long> map = updates;
            synchronized (map) {
                updates.remove(authorizablePath, marker);
            }
        }
        return groups;
    }

    private long readExpirationTime(@NotNull Tree principalCache) {
        if (!principalCache.exists() || !principalCache.hasProperty(this.expirationPropertyName)) {
            return 0L;
        }
        return TreeUtil.getLong(principalCache, this.expirationPropertyName, 0L);
    }

    private static boolean isValidCache(long expirationTime, long now) {
        return expirationTime > 0L && now < expirationTime;
    }

    private boolean canServeStaleCache(long expirationTime, long now) {
        return now - expirationTime < this.maxStale;
    }

    private boolean hasPropertyCached(Tree principalCache) {
        return principalCache.hasProperty(this.propertyName);
    }

    private boolean hasCacheValues(@NotNull Tree principalCache) {
        return principalCache.hasProperty(this.propertyName) && !StringUtils.isEmpty((CharSequence)TreeUtil.getString(principalCache, this.propertyName));
    }

    private Set<Principal> serveGroupsFromCache(@NotNull Tree principalCache) {
        String str = TreeUtil.getString(principalCache, this.propertyName, "");
        HashSet<Principal> groups = new HashSet<Principal>();
        for (String s : Text.explode(str, 44)) {
            String name = Text.unescape(s);
            groups.add(this.principalFactory.create(name));
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGroupsToCache(@NotNull Tree authorizableTree, @NotNull Set<Principal> groupPrincipals) throws AccessDeniedException, CommitFailedException {
        try {
            this.root.refresh();
            Tree cache = authorizableTree.getChild("rep:cache");
            String authorizablePath = authorizableTree.getPath();
            if (!cache.exists()) {
                if (groupPrincipals.size() < this.membershipThreshold) {
                    LOG.debug("Omit cache creation for user without membership at {}", (Object)authorizablePath);
                    return;
                }
                LOG.debug("Attempting to create new membership cache at {}", (Object)authorizablePath);
                cache = TreeUtil.addChild(authorizableTree, "rep:cache", "rep:Cache");
            }
            cache.setProperty(this.expirationPropertyName, LongUtils.calculateExpirationTime(this.expiration));
            String value = groupPrincipals.isEmpty() ? "" : String.join((CharSequence)",", IterableUtils.transform(groupPrincipals, input -> Text.escape(input.getName())));
            cache.setProperty(this.propertyName, value);
            this.root.commit(CommitMarker.asCommitAttributes());
            LOG.debug("Cached membership property '{}' at {}", (Object)this.propertyName, (Object)authorizablePath);
        }
        finally {
            this.root.refresh();
        }
    }

    @NotNull
    private Map<String, Long> getCacheUpdateMap() {
        return CACHE_UPDATES.computeIfAbsent(this.config, cfg -> new LinkedHashMap<String, Long>(){

            @Override
            protected boolean removeEldestEntry(@NotNull Map.Entry<String, Long> eldest) {
                return this.size() > 100;
            }
        });
    }

    static final class CommitMarker {
        private static final String KEY = CommitMarker.class.getName();
        private static final CommitMarker INSTANCE = new CommitMarker();

        static boolean isValidCommitInfo(@NotNull CommitInfo commitInfo) {
            return INSTANCE == commitInfo.getInfo().get(KEY);
        }

        private CommitMarker() {
        }

        static Map<String, Object> asCommitAttributes() {
            return Collections.singletonMap(KEY, INSTANCE);
        }
    }
}

