/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.AbstractConfigTypeReflectionProvider;
import org.apache.sling.testing.mock.osgi.config.ComponentPropertyParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SingleElementAnnotationReflectionProvider
extends AbstractConfigTypeReflectionProvider {
    private static final String ATTR_VALUE = "value";
    private final Class<? extends Annotation> annotationType;
    private final String prefix;

    public SingleElementAnnotationReflectionProvider(@NotNull Class<? extends Annotation> annotationType, @Nullable String prefix) {
        this.annotationType = annotationType;
        this.prefix = prefix;
    }

    @Override
    Class<?> getConfigType() {
        return this.annotationType;
    }

    @Override
    public Method[] getMethods() {
        return (Method[])Stream.of(this.annotationType.getDeclaredMethods()).toArray(Method[]::new);
    }

    @Override
    public String getPropertyName(@NotNull Method method) {
        if (ATTR_VALUE.equals(method.getName())) {
            return ComponentPropertyParser.singleElementAnnotationKey(this.annotationType.getSimpleName(), this.prefix);
        }
        throw new IllegalArgumentException("only the value method can be mapped to a config property: " + method.getName());
    }
}

