/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.sling.testing.mock.jcr.MockNodeDefinitionTemplate;
import org.apache.sling.testing.mock.jcr.MockNodeType;
import org.apache.sling.testing.mock.jcr.MockNodeTypeTemplate;
import org.apache.sling.testing.mock.jcr.MockPropertyDefinitionTemplate;

class MockNodeTypeManager
implements NodeTypeManager {
    private static final String NODETYPE_ALREADY_EXISTS = "%s already exists";
    private static final String NODETYPE_DOES_NOT_EXISTS = "%s does not exists";
    private Map<String, NodeType> registeredNTs = new HashMap<String, NodeType>();
    private ResolveMode mode = ResolveMode.MOCK_ALL;

    MockNodeTypeManager() {
    }

    public void setMode(ResolveMode mode) {
        this.mode = mode;
    }

    public boolean isMode(ResolveMode mode) {
        return this.mode.equals((Object)mode);
    }

    public NodeType getNodeType(String nodeTypeName) throws RepositoryException {
        MockNodeType nt = null;
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            nt = new MockNodeType(nodeTypeName, (NodeTypeManager)this);
        } else if (this.registeredNTs.containsKey(nodeTypeName)) {
            nt = this.registeredNTs.get(nodeTypeName);
        }
        if (nt == null) {
            throw new NoSuchNodeTypeException(String.format(NODETYPE_DOES_NOT_EXISTS, nodeTypeName));
        }
        return nt;
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            return true;
        }
        return this.registeredNTs.containsKey(name);
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        List mixins = this.registeredNTs.values().stream().collect(Collectors.toList());
        return new NodeTypeIteratorAdapter(mixins);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        List notMixins = this.registeredNTs.values().stream().filter(nt -> !nt.isMixin()).collect(Collectors.toList());
        return new NodeTypeIteratorAdapter(notMixins);
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        List mixins = this.registeredNTs.values().stream().filter(NodeTypeDefinition::isMixin).collect(Collectors.toList());
        return new NodeTypeIteratorAdapter(mixins);
    }

    public NodeTypeTemplate createNodeTypeTemplate() throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        return new MockNodeTypeTemplate();
    }

    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        return new MockNodeTypeTemplate(ntd, this);
    }

    public NodeDefinitionTemplate createNodeDefinitionTemplate() throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        return new MockNodeDefinitionTemplate(null, this);
    }

    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        return new MockPropertyDefinitionTemplate(null, this);
    }

    public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        if (!allowUpdate && this.registeredNTs.containsKey(ntd.getName())) {
            throw new NodeTypeExistsException(String.format(NODETYPE_ALREADY_EXISTS, ntd.getName()));
        }
        return this.registeredNTs.put(ntd.getName(), new MockNodeType(ntd, (NodeTypeManager)this));
    }

    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        ArrayList<NodeType> registered = new ArrayList<NodeType>();
        for (NodeTypeDefinition ntd : ntds) {
            if (!allowUpdate && this.registeredNTs.containsKey(ntd.getName())) {
                throw new NodeTypeExistsException(String.format(NODETYPE_ALREADY_EXISTS, ntd.getName()));
            }
            registered.add(this.registeredNTs.put(ntd.getName(), new MockNodeType(ntd, (NodeTypeManager)this)));
        }
        return new NodeTypeIteratorAdapter(registered);
    }

    public void unregisterNodeType(String name) throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        if (!this.registeredNTs.containsKey(name)) {
            throw new NoSuchNodeTypeException(String.format(NODETYPE_DOES_NOT_EXISTS, name));
        }
        this.registeredNTs.remove(name);
    }

    public void unregisterNodeTypes(String[] names) throws RepositoryException {
        if (ResolveMode.MOCK_ALL.equals((Object)this.mode)) {
            throw new UnsupportedOperationException();
        }
        for (String name : names) {
            if (this.registeredNTs.containsKey(name)) continue;
            throw new NoSuchNodeTypeException(String.format(NODETYPE_DOES_NOT_EXISTS, name));
        }
        for (String name : names) {
            this.registeredNTs.remove(name);
        }
    }

    static enum ResolveMode {
        MOCK_ALL,
        ONLY_REGISTERED;

    }
}

