/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager;

import javax.jcr.Session;
import org.jetbrains.annotations.NotNull;

public interface AuthorizablePrivilegesInfo {
    public boolean canAddUser(Session var1);

    public boolean canAddGroup(Session var1);

    public boolean canUpdateProperties(Session var1, String var2);

    default public boolean canUpdateProperties(Session jcrSession, String principalId, PropertyUpdateTypes ... propertyUpdateTypes) {
        throw new UnsupportedOperationException();
    }

    public boolean canRemove(Session var1, String var2);

    public boolean canUpdateGroupMembers(Session var1, String var2);

    default public boolean canDisable(Session jcrSession, String userId) {
        throw new UnsupportedOperationException();
    }

    default public boolean canChangePassword(Session jcrSession, String userId) {
        throw new UnsupportedOperationException();
    }

    default public boolean canChangePasswordWithoutOldPassword(@NotNull Session jcrSession, @NotNull String userId) {
        throw new UnsupportedOperationException();
    }

    public static enum PropertyUpdateTypes {
        addProperty,
        addNestedProperty,
        alterProperty,
        removeProperty,
        ADD_PROPERTY,
        ADD_NESTED_PROPERTY,
        ALTER_PROPERTY,
        REMOVE_PROPERTY;


        public static PropertyUpdateTypes convertDeprecated(PropertyUpdateTypes updateType) {
            PropertyUpdateTypes converted = null;
            if (addProperty.equals((Object)updateType)) {
                converted = ADD_PROPERTY;
            } else if (addNestedProperty.equals((Object)updateType)) {
                converted = ADD_NESTED_PROPERTY;
            } else if (alterProperty.equals((Object)updateType)) {
                converted = ALTER_PROPERTY;
            } else if (removeProperty.equals((Object)updateType)) {
                converted = REMOVE_PROPERTY;
            }
            if (converted == null) {
                converted = updateType;
            }
            return converted;
        }
    }
}

