/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.sling.ide.transport.ResourceProxy;

public class VltNodeType
implements NodeType {
    private NodeDefinition[] declaredChildNodeDefinitions;
    private PropertyDefinition[] declaredPropertyDefinitions;
    private String[] declaredSupertypeNames;
    private String name;
    private String primaryItemName;
    private boolean hasOrderableChildNodes;
    private boolean isAbstract;
    private boolean isMixin;
    private boolean isQueryable;
    private NodeDefinition[] childNodeDefinitions;
    private NodeType[] declaredSupertypes;
    private PropertyDefinition[] propertyDefinitions;
    private NodeType[] superTypes;
    private Set<VltNodeType> directChildTypes = new HashSet<VltNodeType>();
    private Set<String> allowedChildNodeTypes;
    private ResourceProxy resourceProxy;

    VltNodeType(ResourceProxy resourceProxy) {
        this.resourceProxy = resourceProxy;
    }

    ResourceProxy getResourceProxy() {
        return this.resourceProxy;
    }

    void addSuperType(VltNodeType aSuperType) {
        aSuperType.directChildTypes.add(this);
    }

    Set<VltNodeType> getDirectChildTypes() {
        return this.directChildTypes;
    }

    Set<VltNodeType> getAllKnownChildTypes() {
        HashSet<VltNodeType> allKnownCTs = new HashSet<VltNodeType>();
        allKnownCTs.add(this);
        for (VltNodeType simpleVltNodeType : this.directChildTypes) {
            allKnownCTs.addAll(simpleVltNodeType.getAllKnownChildTypes());
        }
        return allKnownCTs;
    }

    void setAllowedPrimaryChildNodeTypes(Set<String> allowedChildNodeTypes) {
        this.allowedChildNodeTypes = allowedChildNodeTypes;
    }

    Set<String> getAllowedPrimaryChildNodeTypes() {
        return Collections.unmodifiableSet(this.allowedChildNodeTypes);
    }

    public String toString() {
        return "[" + this.name + "]";
    }

    @Override
    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        return this.declaredChildNodeDefinitions;
    }

    void setDeclaredChildNodeDefinitions(NodeDefinition[] nodeDefinitions) {
        this.declaredChildNodeDefinitions = nodeDefinitions;
    }

    @Override
    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        return this.declaredPropertyDefinitions;
    }

    void setDeclaredPropertyDefinitions(PropertyDefinition[] pds) {
        this.propertyDefinitions = pds;
    }

    @Override
    public String[] getDeclaredSupertypeNames() {
        return this.declaredSupertypeNames;
    }

    void setDeclaredSupertypeNames(String[] supertypeNames) {
        this.declaredSupertypeNames = supertypeNames;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPrimaryItemName() {
        return this.primaryItemName;
    }

    void setPrimaryItemName(String primaryItemName) {
        this.primaryItemName = primaryItemName;
    }

    @Override
    public boolean hasOrderableChildNodes() {
        return this.hasOrderableChildNodes;
    }

    void setHasOrderableChildNodes(boolean hasOrderableChildNodes) {
        this.hasOrderableChildNodes = hasOrderableChildNodes;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    @Override
    public boolean isMixin() {
        return this.isMixin;
    }

    void setMixin(boolean isMixin) {
        this.isMixin = isMixin;
    }

    @Override
    public boolean isQueryable() {
        return this.isQueryable;
    }

    void setQueryable(boolean isQueryable) {
        this.isQueryable = isQueryable;
    }

    @Override
    public boolean canAddChildNode(String arg0) {
        throw new IllegalStateException("not yet implemented");
    }

    @Override
    public boolean canAddChildNode(String arg0, String arg1) {
        throw new IllegalStateException("not yet implemented");
    }

    @Override
    public boolean canRemoveItem(String arg0) {
        throw new IllegalStateException("not yet implemented");
    }

    @Override
    public boolean canRemoveNode(String arg0) {
        throw new IllegalStateException("not yet implemented");
    }

    @Override
    public boolean canRemoveProperty(String arg0) {
        throw new IllegalStateException("not yet implemented");
    }

    @Override
    public boolean canSetProperty(String arg0, Value arg1) {
        throw new IllegalStateException("not yet implemented");
    }

    @Override
    public boolean canSetProperty(String arg0, Value[] arg1) {
        throw new IllegalStateException("not yet implemented");
    }

    @Override
    public NodeDefinition[] getChildNodeDefinitions() {
        LinkedList<NodeDefinition> childNodeDefs = new LinkedList<NodeDefinition>();
        childNodeDefs.addAll(Arrays.asList(this.getDeclaredChildNodeDefinitions()));
        NodeType[] supers = this.getSupertypes();
        if (supers != null) {
            for (int i = 0; i < supers.length; ++i) {
                NodeType aSuperNodeType = supers[i];
                NodeDefinition[] superChildNodeDefs = aSuperNodeType.getChildNodeDefinitions();
                if (superChildNodeDefs == null) continue;
                childNodeDefs.addAll(Arrays.asList(superChildNodeDefs));
            }
        }
        return childNodeDefs.toArray(new NodeDefinition[0]);
    }

    void setChildNodeDefinitions(NodeDefinition[] childNodeDefinitions) {
        this.childNodeDefinitions = childNodeDefinitions;
    }

    @Override
    public NodeTypeIterator getDeclaredSubtypes() {
        throw new IllegalStateException("not yet implemented");
    }

    @Override
    public NodeType[] getDeclaredSupertypes() {
        return this.declaredSupertypes;
    }

    void setDeclaredSupertypes(NodeType[] declaredSupertypes) {
        this.declaredSupertypes = declaredSupertypes;
    }

    @Override
    public PropertyDefinition[] getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    PropertyDefinition getPropertyDefinition(String name) {
        for (int i = 0; i < this.propertyDefinitions.length; ++i) {
            PropertyDefinition pd = this.propertyDefinitions[i];
            if (!pd.getName().equals(name)) continue;
            return pd;
        }
        return null;
    }

    void setPropertyDefinitions(PropertyDefinition[] pds) {
        this.propertyDefinitions = pds;
    }

    @Override
    public NodeTypeIterator getSubtypes() {
        throw new IllegalStateException("not yet implemented");
    }

    @Override
    public NodeType[] getSupertypes() {
        return this.superTypes;
    }

    void setSupertypes(NodeType[] superTypes) {
        this.superTypes = superTypes;
    }

    @Override
    public boolean isNodeType(String arg0) {
        throw new IllegalStateException("not yet implemented");
    }
}

