/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.hash;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.sling.graphql.api.SlingGraphQLException;
import org.jetbrains.annotations.NotNull;

public class SHA256Hasher {
    private SHA256Hasher() {
    }

    @NotNull
    public static String getHash(@NotNull String message) {
        StringBuilder buffer = new StringBuilder();
        try {
            byte[] hash;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            for (byte b : hash = digest.digest(message.getBytes(StandardCharsets.UTF_8))) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    buffer.append('0');
                }
                buffer.append(hex);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new SlingGraphQLException("Failed hashing message.", e);
        }
        return buffer.toString();
    }
}

