/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import relocated_for_contentpackage.org.apache.commons.io.FileUtils;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.ExportRoot;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.MetaInf;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.AbstractArchive;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.Archive;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.FileInputSource;

public class FileArchive
extends AbstractArchive {
    private final File rootDirectory;
    private ExportRoot eRoot;
    private OsEntry jcrRoot;

    public FileArchive(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    @Override
    public void open(boolean strict) throws IOException {
        if (this.jcrRoot != null) {
            return;
        }
        this.eRoot = ExportRoot.findRoot(this.rootDirectory);
        if (!this.eRoot.isValid()) {
            throw new IOException("No jcr_root found.");
        }
        this.jcrRoot = new OsEntry(this.eRoot.getJcrRoot());
    }

    @Override
    public void close() {
        this.eRoot = null;
        this.jcrRoot = null;
    }

    @Override
    public Archive.Entry getJcrRoot() {
        return this.jcrRoot;
    }

    @Override
    public Archive.Entry getRoot() throws IOException {
        return new OsEntry(this.eRoot.getRoot());
    }

    @Override
    public MetaInf getMetaInf() {
        return this.eRoot.getMetaInf();
    }

    @Override
    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        File file;
        File file2 = file = entry == null ? null : ((OsEntry)entry).file;
        if (file == null || !file.isFile() || !file.canRead()) {
            return null;
        }
        return FileUtils.openInputStream(file);
    }

    @Override
    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        File file;
        File file2 = file = entry == null ? null : ((OsEntry)entry).file;
        if (file == null || !file.isFile() || !file.canRead()) {
            return null;
        }
        return new FileInputSource(file);
    }

    private static class OsEntry
    implements Archive.Entry {
        private final File file;

        private OsEntry(File file) {
            this.file = file;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        public Collection<Archive.Entry> getChildren() {
            File[] files = this.file.listFiles();
            if (files == null || files.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<Archive.Entry> ret = new ArrayList<Archive.Entry>(files.length);
            for (File file : files) {
                ret.add(new OsEntry(file));
            }
            return ret;
        }

        @Override
        public Archive.Entry getChild(String name) {
            File child = new File(this.file, name);
            return child.exists() ? new OsEntry(child) : null;
        }
    }
}

