/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner;

import java.util.Set;
import java.util.jar.Manifest;
import org.apache.sling.feature.scanner.ArtifactDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public abstract class BundleDescriptor
extends ArtifactDescriptor
implements Comparable<BundleDescriptor> {
    protected BundleDescriptor(String name) {
        super(name);
    }

    public abstract String getBundleSymbolicName();

    public abstract String getBundleVersion();

    @Override
    public abstract Manifest getManifest();

    public boolean isExportingPackage(String packageName) {
        Set<PackageInfo> exportedPackages = this.getExportedPackages(packageName);
        return exportedPackages != null && !exportedPackages.isEmpty();
    }

    public boolean isExportingPackage(PackageInfo info) {
        String packageName = info.getName();
        Set<PackageInfo> exportedPackages = this.getExportedPackages(packageName);
        if (exportedPackages == null) {
            return false;
        }
        return exportedPackages.stream().anyMatch(packageInfo -> info.getVersion() == null || info.getPackageVersionRange().includes(packageInfo.getPackageVersion()));
    }

    public boolean equals(Object obj) {
        if (obj instanceof BundleDescriptor) {
            return this.getBundleSymbolicName().equals(((BundleDescriptor)obj).getBundleSymbolicName()) && this.getBundleVersion().equals(((BundleDescriptor)obj).getBundleVersion());
        }
        return false;
    }

    public int hashCode() {
        return (this.getBundleSymbolicName() + ':' + this.getBundleVersion()).hashCode();
    }

    @Override
    public String toString() {
        return "BundleInfo [symbolicName=" + this.getBundleSymbolicName() + ", version=" + this.getBundleVersion() + "]";
    }

    @Override
    public int compareTo(BundleDescriptor o) {
        return (this.getBundleSymbolicName() + ':' + this.getBundleVersion()).compareTo(o.getBundleSymbolicName() + ':' + o.getBundleVersion());
    }
}

