/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.commons.InitDelayingTopologyEventListener;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInitDelayingTopologyEventListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private Scheduler createScheduler() {
        return new Scheduler(){

            public boolean unschedule(String jobName) {
                return false;
            }

            public boolean schedule(final Object job, ScheduleOptions options) {
                if (job instanceof Runnable) {
                    Timer t = new Timer();
                    t.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            ((Runnable)job).run();
                        }
                    }, 300L);
                    return true;
                }
                return false;
            }

            public void removeJob(String name) throws NoSuchElementException {
            }

            public boolean fireJobAt(String name, Object job, Map<String, Serializable> config, Date date, int times, long period) {
                return false;
            }

            public void fireJobAt(String name, Object job, Map<String, Serializable> config, Date date) throws Exception {
            }

            public boolean fireJob(Object job, Map<String, Serializable> config, int times, long period) {
                return false;
            }

            public void fireJob(Object job, Map<String, Serializable> config) throws Exception {
            }

            public void addPeriodicJob(String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently, boolean startImmediate) throws Exception {
            }

            public void addPeriodicJob(String name, Object job, Map<String, Serializable> config, long period, boolean canRunConcurrently) throws Exception {
            }

            public void addJob(String name, Object job, Map<String, Serializable> config, String schedulingExpression, boolean canRunConcurrently) throws Exception {
            }

            public ScheduleOptions NOW(int times, long period) {
                return null;
            }

            public ScheduleOptions NOW() {
                return null;
            }

            public ScheduleOptions EXPR(String expression) {
                return null;
            }

            public ScheduleOptions AT(Date date, int times, long period) {
                return null;
            }

            public ScheduleOptions AT(Date date) {
                return null;
            }
        };
    }

    @Test
    public void testConstructor() throws Exception {
        TopologyEventListener delegate = new TopologyEventListener(){

            public void handleTopologyEvent(TopologyEvent event) {
            }
        };
        Scheduler scheduler = this.createScheduler();
        try {
            new InitDelayingTopologyEventListener(-1L, delegate, scheduler);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new InitDelayingTopologyEventListener(0L, delegate, scheduler);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new InitDelayingTopologyEventListener(1L, null, scheduler);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new InitDelayingTopologyEventListener(-1L, delegate, scheduler, null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new InitDelayingTopologyEventListener(0L, delegate, scheduler, null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new InitDelayingTopologyEventListener(1L, null, scheduler, null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new InitDelayingTopologyEventListener(-1L, delegate, scheduler, this.logger);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new InitDelayingTopologyEventListener(0L, delegate, scheduler, this.logger);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new InitDelayingTopologyEventListener(1L, null, scheduler, this.logger);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private TopologyView createView(boolean current) {
        TopologyView view = (TopologyView)Mockito.mock(TopologyView.class);
        Mockito.when((Object)view.isCurrent()).thenReturn((Object)current);
        InstanceDescription local = (InstanceDescription)Mockito.mock(InstanceDescription.class);
        Mockito.when((Object)local.isLeader()).thenReturn((Object)true);
        Mockito.when((Object)local.isLocal()).thenReturn((Object)true);
        Mockito.when((Object)local.getSlingId()).thenReturn((Object)"id");
        Mockito.when((Object)view.getLocalInstance()).thenReturn((Object)local);
        ClusterView localView = (ClusterView)Mockito.mock(ClusterView.class);
        Mockito.when((Object)localView.getId()).thenReturn((Object)"1");
        Mockito.when((Object)localView.getInstances()).thenReturn(Collections.singletonList(local));
        Mockito.when((Object)view.getClusterViews()).thenReturn(Collections.singleton(localView));
        Mockito.when((Object)local.getClusterView()).thenReturn((Object)localView);
        return view;
    }

    private TopologyEvent createEvent(TopologyEvent.Type type) {
        TopologyView oldView = this.createView(false);
        TopologyView newView = this.createView(true);
        switch (type) {
            case TOPOLOGY_CHANGING: {
                return new TopologyEvent(type, oldView, null);
            }
            case PROPERTIES_CHANGED: 
            case TOPOLOGY_CHANGED: {
                return new TopologyEvent(type, oldView, newView);
            }
            case TOPOLOGY_INIT: {
                return new TopologyEvent(type, null, newView);
            }
        }
        throw new IllegalArgumentException("unknown type: " + String.valueOf(type));
    }

    @Test
    public void testDisposing() throws Exception {
        TestListener delegate = new TestListener();
        Scheduler scheduler = this.createScheduler();
        InitDelayingTopologyEventListener listener = new InitDelayingTopologyEventListener(1L, (TopologyEventListener)delegate, scheduler, this.logger);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_INIT));
        delegate.waitForEventCnt(1, 5000L);
        delegate.assureEventCnt(1, 500);
        listener = new InitDelayingTopologyEventListener(1L, (TopologyEventListener)delegate, scheduler, this.logger);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_INIT));
        listener.dispose();
        delegate.assureEventCnt(1, 1000);
        delegate.assureEventCnt(1, 500);
    }

    @Test
    public void testNoEvents() throws Exception {
        TestListener delegate = new TestListener();
        Scheduler scheduler = this.createScheduler();
        InitDelayingTopologyEventListener listener = new InitDelayingTopologyEventListener(1L, (TopologyEventListener)delegate, scheduler, this.logger);
        delegate.assureEventCnt(0, 1500);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_INIT));
        delegate.waitForEventCnt(1, 5000L);
        Assert.assertEquals((Object)delegate.getEvents().get(0).getType(), (Object)TopologyEvent.Type.TOPOLOGY_INIT);
        this.doTestAdditionalEventsAfterInit(delegate, listener);
    }

    private void doTestAdditionalEventsAfterInit(TestListener delegate, InitDelayingTopologyEventListener listener) throws InterruptedException {
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGING));
        delegate.waitForEventCnt(2, 5000L);
        Assert.assertEquals((Object)delegate.getEvents().get(1).getType(), (Object)TopologyEvent.Type.TOPOLOGY_CHANGING);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGED));
        delegate.waitForEventCnt(3, 5000L);
        Assert.assertEquals((Object)delegate.getEvents().get(2).getType(), (Object)TopologyEvent.Type.TOPOLOGY_CHANGED);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.PROPERTIES_CHANGED));
        delegate.waitForEventCnt(4, 5000L);
        Assert.assertEquals((Object)delegate.getEvents().get(3).getType(), (Object)TopologyEvent.Type.PROPERTIES_CHANGED);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGING));
        delegate.waitForEventCnt(5, 5000L);
        Assert.assertEquals((Object)delegate.getEvents().get(4).getType(), (Object)TopologyEvent.Type.TOPOLOGY_CHANGING);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGED));
        delegate.waitForEventCnt(6, 5000L);
        Assert.assertEquals((Object)delegate.getEvents().get(5).getType(), (Object)TopologyEvent.Type.TOPOLOGY_CHANGED);
    }

    @Test
    public void testChanging0() throws Exception {
        TestListener delegate = new TestListener();
        Scheduler scheduler = this.createScheduler();
        InitDelayingTopologyEventListener listener = new InitDelayingTopologyEventListener(1L, (TopologyEventListener)delegate, scheduler, this.logger);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_INIT));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGING));
        delegate.assureEventCnt(0, 1000);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGED));
        delegate.waitForEventCnt(1, 5000L);
        Assert.assertEquals((Object)delegate.getEvents().get(0).getType(), (Object)TopologyEvent.Type.TOPOLOGY_INIT);
        this.doTestAdditionalEventsAfterInit(delegate, listener);
    }

    @Test
    public void testChanging1() throws Exception {
        TestListener delegate = new TestListener();
        Scheduler scheduler = this.createScheduler();
        InitDelayingTopologyEventListener listener = new InitDelayingTopologyEventListener(1L, (TopologyEventListener)delegate, scheduler, this.logger);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_INIT));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGING));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGED));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGING));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGED));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGING));
        delegate.assureEventCnt(0, 1000);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGED));
        delegate.waitForEventCnt(1, 5000L);
        Assert.assertEquals((Object)delegate.getEvents().get(0).getType(), (Object)TopologyEvent.Type.TOPOLOGY_INIT);
        this.doTestAdditionalEventsAfterInit(delegate, listener);
    }

    @Test
    public void testChanged() throws Exception {
        TestListener delegate = new TestListener();
        Scheduler scheduler = this.createScheduler();
        InitDelayingTopologyEventListener listener = new InitDelayingTopologyEventListener(1L, (TopologyEventListener)delegate, scheduler, this.logger);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_INIT));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGING));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGED));
        delegate.waitForEventCnt(1, 5000L);
        Assert.assertEquals((Object)delegate.getEvents().get(0).getType(), (Object)TopologyEvent.Type.TOPOLOGY_INIT);
        this.doTestAdditionalEventsAfterInit(delegate, listener);
    }

    @Test
    public void testProperties() throws Exception {
        TestListener delegate = new TestListener();
        Scheduler scheduler = this.createScheduler();
        InitDelayingTopologyEventListener listener = new InitDelayingTopologyEventListener(1L, (TopologyEventListener)delegate, scheduler, this.logger);
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_INIT));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGING));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.TOPOLOGY_CHANGED));
        listener.handleTopologyEvent(this.createEvent(TopologyEvent.Type.PROPERTIES_CHANGED));
        delegate.waitForEventCnt(1, 5000L);
        Assert.assertEquals((Object)delegate.getEvents().get(0).getType(), (Object)TopologyEvent.Type.TOPOLOGY_INIT);
        this.doTestAdditionalEventsAfterInit(delegate, listener);
    }

    class TestListener
    implements TopologyEventListener {
        private List<TopologyEvent> events = new LinkedList<TopologyEvent>();

        TestListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTopologyEvent(TopologyEvent event) {
            List<TopologyEvent> list = this.events;
            synchronized (list) {
                this.events.add(event);
                this.events.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<TopologyEvent> getEvents() {
            List<TopologyEvent> list = this.events;
            synchronized (list) {
                return this.events;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEventCnt(int cnt, long timeout) throws InterruptedException {
            long start = System.currentTimeMillis();
            List<TopologyEvent> list = this.events;
            synchronized (list) {
                while (this.events.size() != cnt) {
                    long now = System.currentTimeMillis();
                    long remaining = start + timeout - now;
                    if (remaining > 0L) {
                        this.events.wait(remaining);
                        continue;
                    }
                    Assert.fail((String)("did not receive " + cnt + " events within " + timeout + " ms, but " + this.events.size()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void assureEventCnt(int cnt, int timeout) throws InterruptedException {
            long start = System.currentTimeMillis();
            List<TopologyEvent> list = this.events;
            synchronized (list) {
                while (this.events.size() == cnt) {
                    long now = System.currentTimeMillis();
                    long remaining = start + (long)timeout - now;
                    if (remaining > 0L) {
                        this.events.wait(remaining);
                        continue;
                    }
                    return;
                }
                Assert.fail((String)("did not receive " + cnt + " events within " + timeout + " ms, but " + this.events.size()));
            }
        }
    }
}

