/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.stacktrace;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;

public class PackageInfoCollector
implements WeavingHook {
    private final ConcurrentMap<String, Set<String>> pkgInfoMapping = new ConcurrentHashMap<String, Set<String>>();

    public void weave(@NotNull WovenClass wovenClass) {
        this.add(wovenClass.getBundleWiring().getBundle(), wovenClass.getClassName());
    }

    public int size() {
        return this.pkgInfoMapping.size();
    }

    void add(@NotNull Bundle bundle, @NotNull String className) {
        String packageName = PackageInfoCollector.getPackageName(className);
        Set infos = this.pkgInfoMapping.computeIfAbsent(packageName, k -> Collections.synchronizedSet(new HashSet()));
        infos.add(PackageInfoCollector.getInfo(bundle));
    }

    @Nullable
    String getBundleInfo(@Nullable String className) {
        if (className == null) {
            return null;
        }
        String packageName = PackageInfoCollector.getPackageName(className);
        Set infos = (Set)this.pkgInfoMapping.get(packageName);
        if (infos == null || infos.size() > 1 || infos.isEmpty()) {
            return null;
        }
        return infos.stream().findFirst().orElse(null);
    }

    @NotNull
    private static String getInfo(@NotNull Bundle bundle) {
        return bundle.getSymbolicName() + ":" + String.valueOf(bundle.getVersion());
    }

    @NotNull
    static String getPackageName(@NotNull String className) {
        int lastIndexOfDot = className.lastIndexOf(46);
        String result = "";
        if (lastIndexOfDot > 0) {
            result = className.substring(0, lastIndexOfDot);
        }
        return result;
    }
}

