/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.Inverter;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class Orthographic
extends NormalizedProjection {
    private static final long serialVersionUID = -6140156868989213344L;
    private final double sin\u03c60;
    private final double cos\u03c60;
    private final double m\u212f2_cos\u03c60;

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.referencing.operation.provider.Orthographic.LONGITUDE_OF_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.referencing.operation.provider.Orthographic.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.referencing.operation.provider.Orthographic.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, null);
    }

    public Orthographic(OperationMethod method, Parameters parameters) {
        this(Orthographic.initializer(method, parameters));
    }

    private Orthographic(Initializer initializer) {
        super(initializer, null);
        double \u03c60 = Math.toRadians(initializer.getAndStore(org.apache.sis.referencing.operation.provider.Orthographic.LATITUDE_OF_ORIGIN));
        this.sin\u03c60 = Math.sin(\u03c60);
        this.cos\u03c60 = Math.cos(\u03c60);
        this.m\u212f2_cos\u03c60 = (1.0 - this.eccentricitySquared) * this.cos\u03c60;
        if (this.eccentricity != 0.0) {
            double \u03bd0_cos\u03c60 = initializer.scaleAt\u03c6(this.sin\u03c60, this.cos\u03c60);
            MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
            denormalize.convertBefore(1, null, this.eccentricitySquared * \u03bd0_cos\u03c60 * this.sin\u03c60);
        }
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"\u03c6\u2080"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.cos\u03c60 < 0.7853981633974483 ? Math.acos(this.cos\u03c60) : Math.asin(this.sin\u03c60)};
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        Matrix2 derivative = derivate ? new Matrix2() : null;
        this.transform(srcPts, srcOff, dstPts, dstOff, derivative);
        return derivative;
    }

    final double transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, Matrix2 derivative) {
        double r\u03bd;
        double y;
        double x;
        double cos\u03c6_cos\u03bb;
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double cos\u03bb = Math.cos(\u03bb);
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03c6 = Math.cos(\u03c6);
        double sin\u03c6 = Math.sin(\u03c6);
        double sin\u03c60_sin\u03c6 = this.sin\u03c60 * sin\u03c6;
        double cosc = sin\u03c60_sin\u03c6 + this.cos\u03c60 * (cos\u03c6_cos\u03bb = cos\u03c6 * cos\u03bb);
        if (cosc >= 0.0 || derivative instanceof Inverter) {
            x = cos\u03c6 * sin\u03bb;
            y = this.m\u212f2_cos\u03c60 * sin\u03c6 - this.sin\u03c60 * cos\u03c6_cos\u03bb;
            r\u03bd = 1.0;
            if (this.eccentricity != 0.0) {
                double \u212fsin\u03c6 = this.eccentricity * sin\u03c6;
                r\u03bd = Math.sqrt(1.0 - \u212fsin\u03c6 * \u212fsin\u03c6);
                x /= r\u03bd;
                y /= r\u03bd;
            }
        } else {
            x = Double.NaN;
            y = Double.NaN;
            r\u03bd = Double.NaN;
        }
        if (dstPts != null) {
            dstPts[dstOff] = x;
            dstPts[dstOff + 1] = y;
        }
        if (derivative != null) {
            double \u03c1 = (1.0 - this.eccentricitySquared) / (r\u03bd * r\u03bd * r\u03bd);
            derivative.m00 = cos\u03c6_cos\u03bb / r\u03bd;
            derivative.m01 = -sin\u03c6 * sin\u03bb * \u03c1;
            derivative.m10 = this.sin\u03c60 * x;
            derivative.m11 = (this.cos\u03c60 * cos\u03c6 + sin\u03c60_sin\u03c6 * cos\u03bb) * \u03c1;
        }
        return cos\u03c6;
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        double \u03c12 = x * x + y * y;
        double cosc = Math.sqrt(1.0 - \u03c12);
        dstPts[dstOff] = Math.atan2(x, cosc * this.cos\u03c60 - y * this.sin\u03c60);
        dstPts[dstOff + 1] = Math.asin(cosc * this.sin\u03c60 + y * this.cos\u03c60);
        if (this.eccentricity != 0.0) {
            Inverter j = new Inverter();
            j.inverseTransform(this, x, y, dstPts, dstOff);
            dstPts[dstOff] = Math.IEEEremainder(dstPts[dstOff], Math.PI);
        }
    }
}

