/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.gdal.GDALStore;
import org.apache.sis.storage.gdal.GDALStoreProvider;
import org.apache.sis.storage.panama.NativeFunctions;
import org.apache.sis.util.logging.Logging;

final class ErrorHandler {
    private static final ThreadLocal<List<ErrorHandler>> CURRENT = new ThreadLocal();
    private static final int FAILURE = 3;
    private final int err;
    private final String message;

    private ErrorHandler(int err, String message) {
        this.err = err;
        this.message = message;
    }

    static MethodHandle getMethod() {
        try {
            return MethodHandles.lookup().findStatic(ErrorHandler.class, "errorOccurred", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE, MemorySegment.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void errorOccurred(int err, int code, MemorySegment message) {
        try {
            Object text;
            List<ErrorHandler> messages = CURRENT.get();
            if (messages == null) {
                messages = new ArrayList<ErrorHandler>();
                CURRENT.set(messages);
            }
            text = (text = NativeFunctions.toString(message)) == null || ((String)text).isBlank() ? "GDAL error #" + code : ((String)text).replace(System.lineSeparator(), " ");
            messages.add(new ErrorHandler(err, (String)text));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static void errorOccurred(int err) {
        List<ErrorHandler> messages = CURRENT.get();
        if (messages == null) {
            messages = new ArrayList<ErrorHandler>();
            CURRENT.set(messages);
        }
        messages.add(new ErrorHandler(err, null));
    }

    static void report(GDALStore store, String method) {
        List<ErrorHandler> messages = CURRENT.get();
        if (messages != null) {
            CURRENT.remove();
            for (ErrorHandler m : messages) {
                Level level;
                switch (m.err) {
                    default: {
                        level = Level.SEVERE;
                        if (store == null) break;
                        store.getProvider().fatalError();
                        break;
                    }
                    case 2: 
                    case 3: {
                        level = Level.WARNING;
                        break;
                    }
                    case 1: {
                        level = Level.FINE;
                        break;
                    }
                    case 0: {
                        return;
                    }
                }
                if (m.message == null) continue;
                LogRecord r = new LogRecord(level, m.message);
                if (store != null) {
                    store.warning(GDALStore.class, method, r);
                    continue;
                }
                Class src = method != null ? GDALStore.class : null;
                Logging.completeAndLog((Logger)GDALStoreProvider.LOGGER, src, (String)method, (LogRecord)r);
            }
        }
    }

    static void throwOnFailure(GDALStore store, String method) throws DataStoreException {
        List<ErrorHandler> messages = CURRENT.get();
        if (messages != null) {
            String error = null;
            boolean hasError = false;
            int i = messages.size();
            while (--i >= 0) {
                ErrorHandler m = messages.get(i);
                if (m.err < 3) continue;
                error = m.message;
                if (m.err == 3) {
                    messages.remove(i);
                }
                hasError = true;
                if (error == null) continue;
                break;
            }
            ErrorHandler.report(store, method);
            if (hasError) {
                throw new DataStoreException(error);
            }
        }
    }

    static boolean checkCPLErr(int err) throws DataStoreException {
        if (err > 3) {
            throw new InternalDataStoreException("GDAL fatal error.");
        }
        return err < 3;
    }
}

