/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.measure.Quantity;
import org.apache.sis.coverage.RegionOfInterest;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.BandAggregateGridCoverage;
import org.apache.sis.coverage.grid.ClippedGridCoverage;
import org.apache.sis.coverage.grid.ConvertedGridCoverage;
import org.apache.sis.coverage.grid.DerivedGridCoverage;
import org.apache.sis.coverage.grid.DimensionAppender;
import org.apache.sis.coverage.grid.DimensionalityReduction;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.coverage.grid.ResampledGridCoverage;
import org.apache.sis.coverage.grid.TranslatedGridCoverage;
import org.apache.sis.coverage.internal.shared.BandAggregateArgument;
import org.apache.sis.coverage.internal.shared.SampleDimensions;
import org.apache.sis.image.Colorizer;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridCoverageProcessor
implements Cloneable {
    private static final WeakHashSet<ImageProcessor> PROCESSORS = new WeakHashSet(ImageProcessor.class);
    protected final ImageProcessor imageProcessor;
    protected final EnumSet<Optimization> optimizations = EnumSet.allOf(Optimization.class);

    static ImageProcessor unique(ImageProcessor clone) {
        return (ImageProcessor)PROCESSORS.unique((Object)clone);
    }

    private ImageProcessor snapshot() {
        ImageProcessor shared = (ImageProcessor)PROCESSORS.get((Object)this.imageProcessor);
        if (shared == null) {
            shared = GridCoverageProcessor.unique(this.imageProcessor.clone());
        }
        return shared;
    }

    public GridCoverageProcessor() {
        this.imageProcessor = new ImageProcessor();
    }

    public GridCoverageProcessor(ImageProcessor processor) {
        this.imageProcessor = processor.clone();
    }

    public Interpolation getInterpolation() {
        return this.imageProcessor.getInterpolation();
    }

    public void setInterpolation(Interpolation method) {
        this.imageProcessor.setInterpolation(method);
    }

    public Number[] getFillValues() {
        return this.imageProcessor.getFillValues();
    }

    public void setFillValues(Number ... values) {
        this.imageProcessor.setFillValues(values);
    }

    public Colorizer getColorizer() {
        return this.imageProcessor.getColorizer();
    }

    public void setColorizer(Colorizer colorizer) {
        this.imageProcessor.setColorizer(colorizer);
    }

    public Quantity<?>[] getPositionalAccuracyHints() {
        return this.imageProcessor.getPositionalAccuracyHints();
    }

    public void setPositionalAccuracyHints(Quantity<?> ... hints) {
        this.imageProcessor.setPositionalAccuracyHints(hints);
    }

    public synchronized Set<Optimization> getOptimizations() {
        return this.optimizations.clone();
    }

    public synchronized void setOptimizations(Set<Optimization> enabled) {
        ArgumentChecks.ensureNonNull((String)"enabled", enabled);
        this.optimizations.clear();
        this.optimizations.addAll(enabled);
    }

    private static GridGeometry getImageGeometry(RenderedImage image, GridCoverage coverage) {
        Object value = image.getProperty("org.apache.sis.GridGeometry");
        if (value instanceof GridGeometry) {
            return (GridGeometry)value;
        }
        return new ImageRenderer(coverage, null).getImageGeometry(2);
    }

    public GridCoverage mask(GridCoverage source, RegionOfInterest mask, boolean maskInside) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"mask", (Object)mask);
        RenderedImage data = source.render(null);
        Shape roi = mask.toShape2D(GridCoverageProcessor.getImageGeometry(data, source));
        data = this.imageProcessor.mask(data, roi, maskInside);
        return new GridCoverage2D(source, data);
    }

    public GridCoverage convert(GridCoverage source, MathTransform1D[] converters, Function<SampleDimension.Builder, SampleDimension> sampleDimensionModifier) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"converters", (Object)converters);
        List<SampleDimension> sourceBands = source.getSampleDimensions();
        ArgumentChecks.ensureCountBetween((String)"converters", (boolean)true, (int)1, (int)sourceBands.size(), (int)converters.length);
        SampleDimension[] targetBands = new SampleDimension[converters.length];
        SampleDimension.Builder builder = new SampleDimension.Builder();
        if (sampleDimensionModifier == null) {
            sampleDimensionModifier = SampleDimension.Builder::build;
        }
        for (int i = 0; i < converters.length; ++i) {
            MathTransform1D converter = converters[i];
            ArgumentChecks.ensureNonNullElement((String)"converters", (int)i, (Object)converter);
            SampleDimension band = sourceBands.get(i);
            band.getBackground().ifPresent(builder::setBackground);
            band.getCategories().forEach(category -> {
                if (category.isQuantitative()) {
                    builder.addQuantitative((CharSequence)category.getName(), category.getSampleRange(), converter, null);
                } else {
                    builder.addQualitative((CharSequence)category.getName(), category.getSampleRange());
                }
            });
            targetBands[i] = sampleDimensionModifier.apply(builder.setName(band.getName())).forConvertedValues(true);
            builder.clear();
        }
        return new ConvertedGridCoverage(source, Arrays.asList(targetBands), converters, true, this.snapshot(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage shiftGrid(GridCoverage source, long ... translation) {
        boolean allowSourceReplacement;
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"translation", (Object)translation);
        GridCoverageProcessor gridCoverageProcessor = this;
        synchronized (gridCoverageProcessor) {
            allowSourceReplacement = this.optimizations.contains((Object)Optimization.REPLACE_SOURCE);
        }
        return TranslatedGridCoverage.create(source, null, translation, allowSourceReplacement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage clip(GridCoverage source, GridExtent clip) {
        boolean allowSourceReplacement;
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"clip", (Object)clip);
        GridCoverageProcessor gridCoverageProcessor = this;
        synchronized (gridCoverageProcessor) {
            allowSourceReplacement = this.optimizations.contains((Object)Optimization.REPLACE_SOURCE);
        }
        return ClippedGridCoverage.create(source, clip, allowSourceReplacement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage resample(GridCoverage source, GridGeometry target) throws TransformException {
        GridCoverage resampled;
        boolean isConverted;
        boolean allowOperationReplacement;
        boolean allowSourceReplacement;
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"target", (Object)target);
        GridCoverageProcessor gridCoverageProcessor = this;
        synchronized (gridCoverageProcessor) {
            allowSourceReplacement = this.optimizations.contains((Object)Optimization.REPLACE_SOURCE);
            allowOperationReplacement = this.optimizations.contains((Object)Optimization.REPLACE_OPERATION);
        }
        boolean bl = isConverted = source == source.forConvertedValues(true);
        while (true) {
            DerivedGridCoverage derived;
            if (ResampledGridCoverage.equivalent(source.getGridGeometry(), target)) {
                return source;
            }
            if (!allowSourceReplacement || !(source instanceof DerivedGridCoverage) || (derived = (DerivedGridCoverage)source).isNotRepleacable()) break;
            source = derived.source;
        }
        if (this.imageProcessor.getInterpolation() != Interpolation.NEAREST) {
            source = source.forConvertedValues(true);
        }
        try {
            resampled = ResampledGridCoverage.create(source, target, this.imageProcessor, allowOperationReplacement);
        }
        catch (IllegalGridGeometryException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TransformException) {
                throw (TransformException)cause;
            }
            throw e;
        }
        catch (FactoryException e) {
            throw new TransformException(e.getMessage(), (Throwable)e);
        }
        return resampled.forConvertedValues(isConverted);
    }

    public GridCoverage resample(GridCoverage source, CoordinateReferenceSystem target) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"target", (Object)target);
        return this.resample(source, new GridGeometry(null, PixelInCell.CELL_CENTER, null, target));
    }

    public GridCoverage appendDimensions(GridCoverage source, GridGeometry dimToAdd) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"dimToAdd", (Object)dimToAdd);
        try {
            return DimensionAppender.create(source, dimToAdd);
        }
        catch (IllegalGridGeometryException e) {
            throw e;
        }
        catch (IllegalArgumentException | FactoryException e) {
            throw new IllegalGridGeometryException(e.getMessage(), e);
        }
    }

    public GridCoverage appendDimension(GridCoverage source, double lower, double span, SingleCRS crs) {
        long index = Numerics.roundAndClamp((double)(lower / span));
        long[] indices = new long[]{index};
        GridExtent extent = new GridExtent(GridExtent.typeFromAxes((CoordinateReferenceSystem)crs, 1), indices, indices, true);
        LinearTransform gridToCRS = MathTransforms.linear((double)span, (double)Math.fma((double)index, -span, lower));
        return this.appendDimensions(source, new GridGeometry(extent, PixelInCell.CELL_CORNER, (MathTransform)gridToCRS, (CoordinateReferenceSystem)crs));
    }

    public GridCoverage appendDimension(GridCoverage source, Instant lower, Duration span) {
        DefaultTemporalCRS crs = DefaultTemporalCRS.castOrCopy((TemporalCRS)CommonCRS.defaultTemporal());
        double scale = crs.toValue(span);
        double offset = crs.toValue(lower);
        long index = Numerics.roundAndClamp((double)(offset / scale));
        offset = crs.toValue(lower.minus(span.multipliedBy(index)));
        GridExtent extent = new GridExtent(DimensionNameType.TIME, index, index, true);
        LinearTransform gridToCRS = MathTransforms.linear((double)scale, (double)offset);
        return this.appendDimensions(source, new GridGeometry(extent, PixelInCell.CELL_CORNER, (MathTransform)gridToCRS, (CoordinateReferenceSystem)crs));
    }

    public GridCoverage reduceDimensionality(GridCoverage source) {
        return DimensionalityReduction.reduce(source.getGridGeometry()).apply(source);
    }

    public GridCoverage removeGridDimensions(GridCoverage source, int ... gridAxesToRemove) {
        DimensionalityReduction reduction = DimensionalityReduction.remove(source.getGridGeometry(), gridAxesToRemove);
        reduction.ensureIsSlice();
        return reduction.apply(source);
    }

    public GridCoverage selectGridDimensions(GridCoverage source, int ... gridAxesToPass) {
        DimensionalityReduction reduction = DimensionalityReduction.select(source.getGridGeometry(), gridAxesToPass);
        reduction.ensureIsSlice();
        return reduction.apply(source);
    }

    public GridCoverage selectSampleDimensions(GridCoverage source, int ... bands) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        return this.aggregateRanges(new GridCoverage[]{source}, new int[][]{bands});
    }

    public GridCoverage aggregateRanges(GridCoverage ... sources) {
        return this.aggregateRanges(sources, (int[][])null);
    }

    public GridCoverage aggregateRanges(GridCoverage[] sources, int[][] bandsPerSource) {
        BandAggregateArgument<GridCoverage> aggregate = new BandAggregateArgument<GridCoverage>(sources, bandsPerSource);
        aggregate.unwrap(BandAggregateGridCoverage::unwrap);
        aggregate.completeAndValidate(GridCoverage::getSampleDimensions);
        aggregate.mergeConsecutiveSources();
        if (aggregate.isIdentity()) {
            return aggregate.sources()[0];
        }
        return new BandAggregateGridCoverage(aggregate, this.snapshot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage visualize(GridCoverage source, GridExtent slice) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        List<SampleDimension> ranges = source.getSampleDimensions();
        RenderedImage image = source.render(slice);
        try {
            SampleDimensions.IMAGE_PROCESSOR_ARGUMENT.set(ranges);
            RenderedImage renderedImage = this.imageProcessor.visualize(image);
            return renderedImage;
        }
        finally {
            SampleDimensions.IMAGE_PROCESSOR_ARGUMENT.remove();
        }
    }

    static void recoverableException(String caller, Exception ex) {
        Logging.recoverableException((Logger)GridExtent.LOGGER, GridCoverageProcessor.class, (String)caller, (Throwable)ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            GridCoverageProcessor other = (GridCoverageProcessor)object;
            if (this.imageProcessor.equals(other.imageProcessor)) {
                Object optimizations;
                GridCoverageProcessor gridCoverageProcessor = this;
                synchronized (gridCoverageProcessor) {
                    optimizations = this.optimizations.clone();
                }
                gridCoverageProcessor = other;
                synchronized (gridCoverageProcessor) {
                    return ((AbstractSet)optimizations).equals(other.optimizations);
                }
            }
        }
        return false;
    }

    public synchronized int hashCode() {
        return Objects.hash(this.getClass(), this.imageProcessor, this.optimizations);
    }

    public GridCoverageProcessor clone() {
        try {
            GridCoverageProcessor clone = (GridCoverageProcessor)super.clone();
            Field f = GridCoverageProcessor.class.getDeclaredField("imageProcessor");
            f.setAccessible(true);
            f.set(clone, this.imageProcessor.clone());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ReflectiveOperationException e) {
            throw (InaccessibleObjectException)new InaccessibleObjectException().initCause(e);
        }
    }

    public static enum Optimization {
        REPLACE_OPERATION,
        REPLACE_SOURCE;

    }
}

