/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.pending.geoapi.filter;

import java.util.AbstractList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.pending.geoapi.filter.Name;
import org.apache.sis.util.iso.Names;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

final class FilterExpressions<R>
extends AbstractList<Expression<R, ?>> {
    private final List<Filter<R>> filters;

    FilterExpressions(List<Filter<R>> filters) {
        this.filters = Objects.requireNonNull(filters);
    }

    @Override
    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    @Override
    public int size() {
        return this.filters.size();
    }

    @Override
    public Expression<R, ?> get(int index) {
        return new Element<R>(this.filters.get(index));
    }

    private static final class Element<R>
    implements Expression<R, Boolean> {
        private final Filter<R> filter;

        Element(Filter<R> filter) {
            this.filter = Objects.requireNonNull(filter);
        }

        @Override
        public ScopedName getFunctionName() {
            Enum<?> type = this.filter.getOperatorType();
            String identifier = type.name().toLowerCase(Locale.US);
            if (identifier != null) {
                return Names.createScopedName((GenericName)Name.STANDARD, null, (CharSequence)identifier);
            }
            return Names.createScopedName((GenericName)Name.EXTENSION, null, (CharSequence)type.name());
        }

        @Override
        public Class<? super R> getResourceClass() {
            return this.filter.getResourceClass();
        }

        @Override
        public List<Expression<R, ?>> getParameters() {
            return this.filter.getExpressions();
        }

        @Override
        public Boolean apply(R input) {
            return this.filter.test(input);
        }

        @Override
        public <N> Expression<R, N> toValueType(Class<N> type) {
            if (type.isAssignableFrom(Boolean.class)) {
                return this;
            }
            throw new ClassCastException();
        }

        public int hashCode() {
            return ~this.filter.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Element && this.filter.equals(((Element)obj).filter);
        }

        public String toString() {
            return "Expression[" + this.filter.toString() + "]";
        }
    }
}

