/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.route;

import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;
import org.apache.rocketmq.shaded.com.google.common.base.Objects;

public class Address {
    private final String host;
    private final int port;

    public Address(apache.rocketmq.v2.Address address) {
        this.host = address.getHost();
        this.port = address.getPort();
    }

    public Address(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getAddress() {
        return this.host + ":" + this.port;
    }

    public apache.rocketmq.v2.Address toProtobuf() {
        return apache.rocketmq.v2.Address.newBuilder().setHost(this.host).setPort(this.port).build();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.port == address.port && Objects.equal(this.host, address.host);
    }

    public int hashCode() {
        return Objects.hashCode(this.host, this.port);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("host", this.host).add("port", this.port).toString();
    }
}

