/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.topic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.TopicAttributes;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.attribute.Attribute;
import org.apache.rocketmq.common.attribute.AttributeUtil;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.sysflag.TopicSysFlag;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.body.KVTable;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigAndMappingSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingInfo;
import org.apache.rocketmq.tieredstore.TieredMessageStore;
import org.apache.rocketmq.tieredstore.metadata.MetadataStore;
import org.apache.rocketmq.tieredstore.metadata.entity.TopicMetadata;

public class TopicConfigManager
extends ConfigManager {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private static final int SCHEDULE_TOPIC_QUEUE_NUM = 18;
    private final transient Lock topicConfigTableLock = new ReentrantLock();
    protected ConcurrentMap<String, TopicConfig> topicConfigTable = new ConcurrentHashMap<String, TopicConfig>(1024);
    protected DataVersion dataVersion = new DataVersion();
    protected transient BrokerController brokerController;

    public TopicConfigManager() {
    }

    public TopicConfigManager(BrokerController brokerController) {
        this(brokerController, true);
    }

    public TopicConfigManager(BrokerController brokerController, boolean init) {
        this.brokerController = brokerController;
        if (init) {
            this.init();
        }
    }

    protected void init() {
        int perm;
        String topic = "SELF_TEST_TOPIC";
        TopicConfig topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.putTopicConfig(topicConfig);
        if (this.brokerController.getBrokerConfig().isAutoCreateTopicEnable()) {
            topic = "TBW102";
            topicConfig = new TopicConfig(topic);
            TopicValidator.addSystemTopic((String)topic);
            topicConfig.setReadQueueNums(this.brokerController.getBrokerConfig().getDefaultTopicQueueNums());
            topicConfig.setWriteQueueNums(this.brokerController.getBrokerConfig().getDefaultTopicQueueNums());
            perm = 7;
            topicConfig.setPerm(perm);
            this.putTopicConfig(topicConfig);
        }
        topic = "BenchmarkTest";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1024);
        topicConfig.setWriteQueueNums(1024);
        this.putTopicConfig(topicConfig);
        topic = this.brokerController.getBrokerConfig().getBrokerClusterName();
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        perm = 1;
        if (this.brokerController.getBrokerConfig().isClusterTopicEnable()) {
            perm |= 6;
        }
        topicConfig.setPerm(perm);
        this.putTopicConfig(topicConfig);
        topic = this.brokerController.getBrokerConfig().getBrokerName();
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        perm = 1;
        if (this.brokerController.getBrokerConfig().isBrokerTopicEnable()) {
            perm |= 6;
        }
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        topicConfig.setPerm(perm);
        this.putTopicConfig(topicConfig);
        topic = "OFFSET_MOVED_EVENT";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.putTopicConfig(topicConfig);
        topic = "SCHEDULE_TOPIC_XXXX";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(18);
        topicConfig.setWriteQueueNums(18);
        this.putTopicConfig(topicConfig);
        if (this.brokerController.getBrokerConfig().isTraceTopicEnable()) {
            topic = this.brokerController.getBrokerConfig().getMsgTraceTopicName();
            topicConfig = new TopicConfig(topic);
            TopicValidator.addSystemTopic((String)topic);
            topicConfig.setReadQueueNums(1);
            topicConfig.setWriteQueueNums(1);
            this.putTopicConfig(topicConfig);
        }
        topic = this.brokerController.getBrokerConfig().getBrokerClusterName() + "_" + "REPLY_TOPIC";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.putTopicConfig(topicConfig);
        topic = PopAckConstants.buildClusterReviveTopic((String)this.brokerController.getBrokerConfig().getBrokerClusterName());
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(this.brokerController.getBrokerConfig().getReviveQueueNum());
        topicConfig.setWriteQueueNums(this.brokerController.getBrokerConfig().getReviveQueueNum());
        this.putTopicConfig(topicConfig);
        topic = "rmq_sys_SYNC_BROKER_MEMBER_" + this.brokerController.getBrokerConfig().getBrokerName();
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        topicConfig.setPerm(1);
        this.putTopicConfig(topicConfig);
        topic = "RMQ_SYS_TRANS_HALF_TOPIC";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.putTopicConfig(topicConfig);
        topic = "RMQ_SYS_TRANS_OP_HALF_TOPIC";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.putTopicConfig(topicConfig);
        topic = "RMQ_SYS_ROCKSDB_TRANS_HALF_TOPIC";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.putTopicConfig(topicConfig);
        topic = "RMQ_SYS_ROCKSDB_TRANS_OP_HALF_TOPIC";
        topicConfig = new TopicConfig(topic);
        TopicValidator.addSystemTopic((String)topic);
        topicConfig.setReadQueueNums(1);
        topicConfig.setWriteQueueNums(1);
        this.putTopicConfig(topicConfig);
        if (this.brokerController.getMessageStoreConfig().isTimerWheelEnable()) {
            topic = "rmq_sys_wheel_timer";
            topicConfig = new TopicConfig(topic);
            TopicValidator.addSystemTopic((String)topic);
            topicConfig.setReadQueueNums(1);
            topicConfig.setWriteQueueNums(1);
            this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        }
    }

    public TopicConfig putTopicConfig(TopicConfig topicConfig) {
        return this.topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
    }

    protected TopicConfig getTopicConfig(String topicName) {
        return (TopicConfig)this.topicConfigTable.get(topicName);
    }

    protected TopicConfig removeTopicConfig(String topicName) {
        return (TopicConfig)this.topicConfigTable.remove(topicName);
    }

    public TopicConfig selectTopicConfig(String topic) {
        return this.getTopicConfig(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicConfig createTopicInSendMessageMethod(String topic, String defaultTopic, String remoteAddress, int clientDefaultTopicQueueNums, int topicSysFlag) {
        boolean createNew;
        TopicConfig topicConfig;
        block14: {
            topicConfig = null;
            createNew = false;
            try {
                if (!this.topicConfigTableLock.tryLock(3000L, TimeUnit.MILLISECONDS)) break block14;
                try {
                    topicConfig = this.getTopicConfig(topic);
                    if (topicConfig != null) {
                        TopicConfig topicConfig2 = topicConfig;
                        return topicConfig2;
                    }
                    TopicConfig defaultTopicConfig = this.getTopicConfig(defaultTopic);
                    if (defaultTopicConfig != null) {
                        if (defaultTopic.equals("TBW102") && !this.brokerController.getBrokerConfig().isAutoCreateTopicEnable()) {
                            defaultTopicConfig.setPerm(6);
                        }
                        if (PermName.isInherited((int)defaultTopicConfig.getPerm())) {
                            topicConfig = new TopicConfig(topic);
                            int queueNums = Math.min(clientDefaultTopicQueueNums, defaultTopicConfig.getWriteQueueNums());
                            if (queueNums < 0) {
                                queueNums = 0;
                            }
                            topicConfig.setReadQueueNums(queueNums);
                            topicConfig.setWriteQueueNums(queueNums);
                            int perm = defaultTopicConfig.getPerm();
                            topicConfig.setPerm(perm &= 0xFFFFFFFE);
                            topicConfig.setTopicSysFlag(topicSysFlag);
                            topicConfig.setTopicFilterType(defaultTopicConfig.getTopicFilterType());
                        } else {
                            log.warn("Create new topic failed, because the default topic[{}] has no perm [{}] producer:[{}]", new Object[]{defaultTopic, defaultTopicConfig.getPerm(), remoteAddress});
                        }
                    } else {
                        log.warn("Create new topic failed, because the default topic[{}] not exist. producer:[{}]", (Object)defaultTopic, (Object)remoteAddress);
                    }
                    if (topicConfig != null) {
                        log.info("Create new topic by default topic:[{}] config:[{}] producer:[{}]", new Object[]{defaultTopic, topicConfig, remoteAddress});
                        this.putTopicConfig(topicConfig);
                        this.updateDataVersion();
                        createNew = true;
                        this.persist();
                    }
                }
                finally {
                    this.topicConfigTableLock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("createTopicInSendMessageMethod exception", (Throwable)e);
            }
        }
        if (!createNew) return topicConfig;
        this.registerBrokerData(topicConfig);
        return topicConfig;
    }

    public TopicConfig createTopicIfAbsent(TopicConfig topicConfig) {
        return this.createTopicIfAbsent(topicConfig, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicConfig createTopicIfAbsent(TopicConfig topicConfig, boolean register) {
        boolean createNew;
        block9: {
            createNew = false;
            if (topicConfig == null) {
                throw new NullPointerException("TopicConfig");
            }
            if (StringUtils.isEmpty((CharSequence)topicConfig.getTopicName())) {
                throw new IllegalArgumentException("TopicName");
            }
            try {
                if (!this.topicConfigTableLock.tryLock(3000L, TimeUnit.MILLISECONDS)) break block9;
                try {
                    TopicConfig existedTopicConfig = this.getTopicConfig(topicConfig.getTopicName());
                    if (existedTopicConfig != null) {
                        TopicConfig topicConfig2 = existedTopicConfig;
                        return topicConfig2;
                    }
                    log.info("Create new topic [{}] config:[{}]", (Object)topicConfig.getTopicName(), (Object)topicConfig);
                    this.putTopicConfig(topicConfig);
                    this.updateDataVersion();
                    createNew = true;
                    this.persist();
                }
                finally {
                    this.topicConfigTableLock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("createTopicIfAbsent ", (Throwable)e);
            }
        }
        if (!createNew) return this.getTopicConfig(topicConfig.getTopicName());
        if (!register) return this.getTopicConfig(topicConfig.getTopicName());
        this.registerBrokerData(topicConfig);
        return this.getTopicConfig(topicConfig.getTopicName());
    }

    public TopicConfig createTopicInSendMessageBackMethod(String topic, int clientDefaultTopicQueueNums, int perm, int topicSysFlag) {
        return this.createTopicInSendMessageBackMethod(topic, clientDefaultTopicQueueNums, perm, false, topicSysFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicConfig createTopicInSendMessageBackMethod(String topic, int clientDefaultTopicQueueNums, int perm, boolean isOrder, int topicSysFlag) {
        boolean createNew;
        TopicConfig topicConfig;
        block8: {
            topicConfig = this.getTopicConfig(topic);
            if (topicConfig != null) {
                if (isOrder == topicConfig.isOrder()) return topicConfig;
                topicConfig.setOrder(isOrder);
                this.updateTopicConfig(topicConfig);
                return topicConfig;
            }
            createNew = false;
            try {
                if (!this.topicConfigTableLock.tryLock(3000L, TimeUnit.MILLISECONDS)) break block8;
                try {
                    topicConfig = this.getTopicConfig(topic);
                    if (topicConfig != null) {
                        TopicConfig topicConfig2 = topicConfig;
                        return topicConfig2;
                    }
                    topicConfig = new TopicConfig(topic);
                    topicConfig.setReadQueueNums(clientDefaultTopicQueueNums);
                    topicConfig.setWriteQueueNums(clientDefaultTopicQueueNums);
                    topicConfig.setPerm(perm);
                    topicConfig.setTopicSysFlag(topicSysFlag);
                    topicConfig.setOrder(isOrder);
                    log.info("create new topic {}", (Object)topicConfig);
                    this.putTopicConfig(topicConfig);
                    createNew = true;
                    this.updateDataVersion();
                    this.persist();
                }
                finally {
                    this.topicConfigTableLock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("createTopicInSendMessageBackMethod exception", (Throwable)e);
            }
        }
        if (!createNew) return topicConfig;
        this.registerBrokerData(topicConfig);
        return topicConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicConfig createTopicOfTranCheckMaxTime(int clientDefaultTopicQueueNums, int perm) {
        boolean createNew;
        TopicConfig topicConfig;
        block8: {
            topicConfig = this.getTopicConfig("TRANS_CHECK_MAX_TIME_TOPIC");
            if (topicConfig != null) {
                return topicConfig;
            }
            createNew = false;
            try {
                if (!this.topicConfigTableLock.tryLock(3000L, TimeUnit.MILLISECONDS)) break block8;
                try {
                    topicConfig = this.getTopicConfig("TRANS_CHECK_MAX_TIME_TOPIC");
                    if (topicConfig != null) {
                        TopicConfig topicConfig2 = topicConfig;
                        return topicConfig2;
                    }
                    topicConfig = new TopicConfig("TRANS_CHECK_MAX_TIME_TOPIC");
                    topicConfig.setReadQueueNums(clientDefaultTopicQueueNums);
                    topicConfig.setWriteQueueNums(clientDefaultTopicQueueNums);
                    topicConfig.setPerm(perm);
                    topicConfig.setTopicSysFlag(0);
                    log.info("create new topic {}", (Object)topicConfig);
                    this.putTopicConfig(topicConfig);
                    createNew = true;
                    this.updateDataVersion();
                    this.persist();
                }
                finally {
                    this.topicConfigTableLock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("create TRANS_CHECK_MAX_TIME_TOPIC exception", (Throwable)e);
            }
        }
        if (!createNew) return topicConfig;
        this.registerBrokerData(topicConfig);
        return topicConfig;
    }

    public void updateTopicUnitFlag(String topic, boolean unit) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig != null) {
            int oldTopicSysFlag = topicConfig.getTopicSysFlag();
            if (unit) {
                topicConfig.setTopicSysFlag(TopicSysFlag.setUnitFlag((int)oldTopicSysFlag));
            } else {
                topicConfig.setTopicSysFlag(TopicSysFlag.clearUnitFlag((int)oldTopicSysFlag));
            }
            log.info("update topic sys flag. oldTopicSysFlag={}, newTopicSysFlag={}", (Object)oldTopicSysFlag, (Object)topicConfig.getTopicSysFlag());
            this.putTopicConfig(topicConfig);
            this.updateDataVersion();
            this.persist();
            this.registerBrokerData(topicConfig);
        }
    }

    public void updateTopicUnitSubFlag(String topic, boolean hasUnitSub) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig != null) {
            int oldTopicSysFlag = topicConfig.getTopicSysFlag();
            if (hasUnitSub) {
                topicConfig.setTopicSysFlag(TopicSysFlag.setUnitSubFlag((int)oldTopicSysFlag));
            } else {
                topicConfig.setTopicSysFlag(TopicSysFlag.clearUnitSubFlag((int)oldTopicSysFlag));
            }
            log.info("update topic sys flag. oldTopicSysFlag={}, newTopicSysFlag={}", (Object)oldTopicSysFlag, (Object)topicConfig.getTopicSysFlag());
            this.putTopicConfig(topicConfig);
            this.updateDataVersion();
            this.persist();
            this.registerBrokerData(topicConfig);
        }
    }

    public void updateSingleTopicConfigWithoutPersist(TopicConfig topicConfig) {
        Preconditions.checkNotNull((Object)topicConfig, (Object)"topicConfig shouldn't be null");
        Map<String, String> newAttributes = this.request(topicConfig);
        Map<String, String> currentAttributes = this.current(topicConfig.getTopicName());
        Map finalAttributes = AttributeUtil.alterCurrentAttributes((this.topicConfigTable.get(topicConfig.getTopicName()) == null ? 1 : 0) != 0, (Map)TopicAttributes.ALL, (ImmutableMap)ImmutableMap.copyOf(currentAttributes), (ImmutableMap)ImmutableMap.copyOf(newAttributes));
        topicConfig.setAttributes(finalAttributes);
        this.updateTieredStoreTopicMetadata(topicConfig, newAttributes);
        TopicConfig old = this.putTopicConfig(topicConfig);
        if (old != null) {
            log.info("update topic config, old:[{}] new:[{}]", (Object)old, (Object)topicConfig);
        } else {
            log.info("create new topic [{}]", (Object)topicConfig);
        }
        this.updateDataVersion();
    }

    public void updateTopicConfig(TopicConfig topicConfig) {
        this.updateSingleTopicConfigWithoutPersist(topicConfig);
        this.persist(topicConfig.getTopicName(), topicConfig);
    }

    public void updateTopicConfigList(List<TopicConfig> topicConfigList) {
        topicConfigList.forEach(this::updateSingleTopicConfigWithoutPersist);
        this.persist();
    }

    private synchronized void updateTieredStoreTopicMetadata(TopicConfig topicConfig, Map<String, String> newAttributes) {
        if (!(this.brokerController.getMessageStore() instanceof TieredMessageStore)) {
            if (newAttributes.get(TopicAttributes.TOPIC_RESERVE_TIME_ATTRIBUTE.getName()) != null) {
                throw new IllegalArgumentException("Update topic reserveTime not supported");
            }
            return;
        }
        String topic = topicConfig.getTopicName();
        long reserveTime = TopicAttributes.TOPIC_RESERVE_TIME_ATTRIBUTE.getDefaultValue();
        String attr = (String)topicConfig.getAttributes().get(TopicAttributes.TOPIC_RESERVE_TIME_ATTRIBUTE.getName());
        if (attr != null) {
            reserveTime = Long.parseLong(attr);
        }
        log.info("Update tiered storage metadata, topic {}, reserveTime {}", (Object)topic, (Object)reserveTime);
        TieredMessageStore tieredMessageStore = (TieredMessageStore)this.brokerController.getMessageStore();
        MetadataStore metadataStore = tieredMessageStore.getMetadataStore();
        TopicMetadata topicMetadata = metadataStore.getTopic(topic);
        if (topicMetadata == null) {
            metadataStore.addTopic(topic, reserveTime);
        } else if (topicMetadata.getReserveTime() != reserveTime) {
            topicMetadata.setReserveTime(reserveTime);
            metadataStore.updateTopic(topicMetadata);
        }
    }

    public void updateOrderTopicConfig(KVTable orderKVTableFromNs) {
        if (orderKVTableFromNs != null && orderKVTableFromNs.getTable() != null) {
            boolean isChange = false;
            Set orderTopics = orderKVTableFromNs.getTable().keySet();
            for (String topic : orderTopics) {
                TopicConfig topicConfig = this.getTopicConfig(topic);
                if (topicConfig == null || topicConfig.isOrder()) continue;
                topicConfig.setOrder(true);
                isChange = true;
                log.info("update order topic config, topic={}, order={}", (Object)topic, (Object)true);
            }
            if (isChange) {
                this.updateDataVersion();
                this.persist();
            }
        }
    }

    public Map<String, Attribute> allAttributes() {
        return TopicAttributes.ALL;
    }

    public boolean isOrderTopic(String topic) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig == null) {
            return false;
        }
        return topicConfig.isOrder();
    }

    public void deleteTopicConfig(String topic) {
        TopicConfig old = this.removeTopicConfig(topic);
        if (old != null) {
            log.info("delete topic config OK, topic: {}", (Object)old);
            this.updateDataVersion();
            this.persist();
        } else {
            log.warn("delete topic config failed, topic: {} not exists", (Object)topic);
        }
    }

    public TopicConfigSerializeWrapper buildTopicConfigSerializeWrapper() {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = new TopicConfigSerializeWrapper();
        topicConfigSerializeWrapper.setTopicConfigTable(this.topicConfigTable);
        DataVersion dataVersionCopy = new DataVersion();
        dataVersionCopy.assignNewOne(this.dataVersion);
        topicConfigSerializeWrapper.setDataVersion(dataVersionCopy);
        return topicConfigSerializeWrapper;
    }

    public TopicConfigAndMappingSerializeWrapper buildSerializeWrapper(ConcurrentMap<String, TopicConfig> topicConfigTable) {
        return this.buildSerializeWrapper(topicConfigTable, Maps.newHashMap());
    }

    public TopicConfigAndMappingSerializeWrapper buildSerializeWrapper(ConcurrentMap<String, TopicConfig> topicConfigTable, Map<String, TopicQueueMappingInfo> topicQueueMappingInfoMap) {
        TopicConfigAndMappingSerializeWrapper topicConfigWrapper = new TopicConfigAndMappingSerializeWrapper();
        topicConfigWrapper.setTopicConfigTable(topicConfigTable);
        topicConfigWrapper.setTopicQueueMappingInfoMap(topicQueueMappingInfoMap);
        topicConfigWrapper.setDataVersion(this.getDataVersion());
        return topicConfigWrapper;
    }

    public String encode() {
        return this.encode(false);
    }

    public boolean loadDataVersion() {
        String fileName = null;
        try {
            TopicConfigSerializeWrapper topicConfigSerializeWrapper;
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String((String)fileName);
            if (jsonString != null && (topicConfigSerializeWrapper = (TopicConfigSerializeWrapper)TopicConfigSerializeWrapper.fromJson((String)jsonString, TopicConfigSerializeWrapper.class)) != null) {
                this.dataVersion.assignNewOne(topicConfigSerializeWrapper.getDataVersion());
                log.info("load topic metadata dataVersion success {}, {}", (Object)fileName, (Object)topicConfigSerializeWrapper.getDataVersion());
            }
            return true;
        }
        catch (Exception e) {
            log.error("load topic metadata dataVersion failed" + fileName, (Throwable)e);
            return false;
        }
    }

    public String configFilePath() {
        return BrokerPathConfigHelper.getTopicConfigPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper;
        if (jsonString != null && (topicConfigSerializeWrapper = (TopicConfigSerializeWrapper)TopicConfigSerializeWrapper.fromJson((String)jsonString, TopicConfigSerializeWrapper.class)) != null) {
            this.topicConfigTable.putAll(topicConfigSerializeWrapper.getTopicConfigTable());
            this.dataVersion.assignNewOne(topicConfigSerializeWrapper.getDataVersion());
            this.printLoadDataWhenFirstBoot(topicConfigSerializeWrapper);
        }
    }

    public String encode(boolean prettyFormat) {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = new TopicConfigSerializeWrapper();
        topicConfigSerializeWrapper.setTopicConfigTable(this.topicConfigTable);
        topicConfigSerializeWrapper.setDataVersion(this.getDataVersion());
        return topicConfigSerializeWrapper.toJson(prettyFormat);
    }

    private void printLoadDataWhenFirstBoot(TopicConfigSerializeWrapper tcs) {
        for (Map.Entry next : tcs.getTopicConfigTable().entrySet()) {
            log.info("load exist local topic, {}", (Object)((TopicConfig)next.getValue()).toString());
        }
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void setTopicConfigTable(ConcurrentMap<String, TopicConfig> topicConfigTable) {
        this.topicConfigTable = topicConfigTable;
    }

    public ConcurrentMap<String, TopicConfig> getTopicConfigTable() {
        return this.topicConfigTable;
    }

    public ConcurrentHashMap<String, TopicConfig> subTopicConfigTable(String dataVersion, int topicSeq, int maxTopicNum) {
        int beginIndex = topicSeq;
        if (StringUtils.isBlank((CharSequence)dataVersion) || !Objects.equals(DataVersion.fromJson((String)dataVersion, DataVersion.class), this.dataVersion)) {
            beginIndex = 0;
            log.info("get sub topic config table from {} due to {}", (Object)beginIndex, (Object)(StringUtils.isBlank((CharSequence)dataVersion) ? "DataVersion Empty" : "DataVersion Changed"));
        }
        ConcurrentHashMap<String, TopicConfig> subTopicConfigTable = new ConcurrentHashMap<String, TopicConfig>();
        if (beginIndex < this.topicConfigTable.size()) {
            int endIndex = Math.min(beginIndex + maxTopicNum, this.topicConfigTable.size());
            ImmutableSortedMap sortedMap = ImmutableSortedMap.copyOf(this.topicConfigTable);
            subTopicConfigTable.putAll((Map<String, TopicConfig>)sortedMap.subMap(sortedMap.keySet().asList().get(beginIndex), true, sortedMap.keySet().asList().get(endIndex - 1), true));
        }
        return subTopicConfigTable;
    }

    private Map<String, String> request(TopicConfig topicConfig) {
        return topicConfig.getAttributes() == null ? new HashMap() : topicConfig.getAttributes();
    }

    private Map<String, String> current(String topic) {
        TopicConfig topicConfig = this.getTopicConfig(topic);
        if (topicConfig == null) {
            return new HashMap<String, String>();
        }
        Map attributes = topicConfig.getAttributes();
        if (attributes == null) {
            return new HashMap<String, String>();
        }
        return attributes;
    }

    private void registerBrokerData(TopicConfig topicConfig) {
        if (this.brokerController.getBrokerConfig().isEnableSingleTopicRegister()) {
            this.brokerController.registerSingleTopicAll(topicConfig);
        } else {
            this.brokerController.registerIncrementBrokerData(topicConfig, this.dataVersion);
        }
    }

    public boolean containsTopic(String topic) {
        return this.topicConfigTable.containsKey(topic);
    }

    public void updateDataVersion() {
        long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
        this.dataVersion.nextVersion(stateMachineVersion);
    }
}

