/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.qpid.server.user.connection.limits.config.Rule;
import org.apache.qpid.server.user.connection.limits.config.RuleSet;

public final class RuleSetCreator
extends ArrayList<Rule> {
    private static final long serialVersionUID = -7L;
    private Long _defaultFrequencyPeriod = null;
    private boolean _logAllMessages = false;

    public RuleSetCreator() {
        super(new ArrayList());
    }

    public void setDefaultFrequencyPeriod(long defaultFrequencyPeriod) {
        this._defaultFrequencyPeriod = defaultFrequencyPeriod;
    }

    public Long getDefaultFrequencyPeriod() {
        return this._defaultFrequencyPeriod;
    }

    public boolean isDefaultFrequencyPeriodSet() {
        return this._defaultFrequencyPeriod != null;
    }

    public void setLogAllMessages(boolean logAllMessages) {
        this._logAllMessages = logAllMessages;
    }

    public boolean isLogAllMessages() {
        return this._logAllMessages;
    }

    public RuleSet getLimiter(String name) {
        long period = Optional.ofNullable(this._defaultFrequencyPeriod).orElse(60000L);
        if (period > 0L) {
            Duration defaultFrequencyPeriod = Duration.ofMillis(period);
            this.updateRulesWithDefaultFrequencyPeriod(defaultFrequencyPeriod);
            return RuleSet.newBuilder(name, defaultFrequencyPeriod).logAllMessages(this._logAllMessages).addRules(this).build();
        }
        return RuleSet.newBuilder(name, null).logAllMessages(this._logAllMessages).addRules(this).build();
    }

    public RuleSetCreator updateRulesWithDefaultFrequencyPeriod() {
        if (this._defaultFrequencyPeriod != null && this._defaultFrequencyPeriod > 0L) {
            this.updateRulesWithDefaultFrequencyPeriod(Duration.ofMillis(this._defaultFrequencyPeriod));
        }
        return this;
    }

    @Override
    public boolean add(Rule rule) {
        return this.addImpl(rule);
    }

    @Override
    public boolean addAll(Collection<? extends Rule> c) {
        boolean changed = false;
        if (c != null) {
            for (Rule rule : c) {
                changed = this.add(rule) || changed;
            }
        }
        return changed;
    }

    private boolean addImpl(Rule rule) {
        if (rule != null && !rule.isEmpty()) {
            return super.add(rule);
        }
        return false;
    }

    private void updateRulesWithDefaultFrequencyPeriod(Duration defaultFrequencyPeriod) {
        this.forEach((? super E r) -> r.updateWithDefaultFrequencyPeriod(defaultFrequencyPeriod));
    }
}

