/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.txn.TxnEnd;
import java.nio.ByteBuffer;
import javax.transaction.xa.Xid;

public class TxnPrepare
extends TxnEnd
implements Loggable {
    private Xid xid;

    public TxnPrepare(long id, Xid xid) {
        super(id, -1L, 0, 0L);
        this.xid = xid;
    }

    public TxnPrepare() {
    }

    public Xid getXid() {
        return this.xid;
    }

    @Override
    protected String getTagName() {
        return "TxnPrepare";
    }

    @Override
    public int getLogSize() {
        return LogUtils.getPackedLongLogSize(this.id) + LogUtils.getTimestampLogSize(this.time) + LogUtils.getXidSize(this.xid);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writePackedLong(logBuffer, this.id);
        LogUtils.writeTimestamp(logBuffer, this.time);
        LogUtils.writeXid(logBuffer, this.xid);
    }

    @Override
    public void readFromLog(ByteBuffer logBuffer, int entryVersion) {
        boolean unpacked = entryVersion < 6;
        this.id = LogUtils.readLong(logBuffer, unpacked);
        this.time = LogUtils.readTimestamp(logBuffer, unpacked);
        this.xid = LogUtils.readXid(logBuffer);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<").append(this.getTagName());
        sb.append(" id=\"").append(this.id);
        sb.append("\" time=\"").append(this.time);
        sb.append("\">");
        sb.append(this.xid);
        sb.append("</").append(this.getTagName()).append(">");
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }
}

