/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.jdk;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.jdk.AtomicBooleanDeserializer;
import tools.jackson.databind.deser.jdk.AtomicIntegerDeserializer;
import tools.jackson.databind.deser.jdk.AtomicLongDeserializer;
import tools.jackson.databind.deser.jdk.ByteBufferDeserializer;
import tools.jackson.databind.deser.jdk.JDKFromStringDeserializer;
import tools.jackson.databind.deser.jdk.StackTraceElementDeserializer;
import tools.jackson.databind.deser.jdk.ThreadGroupDeserializer;
import tools.jackson.databind.deser.jdk.UUIDDeserializer;
import tools.jackson.databind.deser.std.NullifyingDeserializer;

public class JDKMiscDeserializers {
    private static final HashSet<String> _classNames = new HashSet();

    public static ValueDeserializer<?> find(DeserializationContext ctxt, Class<?> rawType, String clsName) {
        if (_classNames.contains(clsName)) {
            JDKFromStringDeserializer d = JDKFromStringDeserializer.findDeserializer(rawType);
            if (d != null) {
                return d;
            }
            if (rawType == UUID.class) {
                return new UUIDDeserializer();
            }
            if (rawType == StackTraceElement.class) {
                return StackTraceElementDeserializer.construct(ctxt);
            }
            if (rawType == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (rawType == AtomicInteger.class) {
                return new AtomicIntegerDeserializer();
            }
            if (rawType == AtomicLong.class) {
                return new AtomicLongDeserializer();
            }
            if (rawType == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
            if (rawType == Void.class) {
                return NullifyingDeserializer.instance;
            }
            if (rawType == ThreadGroup.class) {
                return new ThreadGroupDeserializer();
            }
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> rawType) {
        return _classNames.contains(rawType.getName());
    }

    static {
        _classNames.add(UUID.class.getName());
        _classNames.add(AtomicBoolean.class.getName());
        _classNames.add(AtomicInteger.class.getName());
        _classNames.add(AtomicLong.class.getName());
        _classNames.add(StackTraceElement.class.getName());
        _classNames.add(ByteBuffer.class.getName());
        _classNames.add(Void.class.getName());
        _classNames.add(ThreadGroup.class.getName());
        for (Class<?> cls : JDKFromStringDeserializer.types()) {
            _classNames.add(cls.getName());
        }
    }
}

