/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.util.Strings;
import org.jspecify.annotations.Nullable;

public class SslSocketManager
extends TcpSocketManager {
    public static final int DEFAULT_PORT = 6514;
    private static final SslSocketManagerFactory FACTORY = new SslSocketManagerFactory();
    private final SslConfiguration sslConfig;

    @Deprecated
    public SslSocketManager(String name, OutputStream os, Socket sock, SslConfiguration sslConfig, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int reconnectionDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        super(name, os, sock, inetAddress, host, port, connectTimeoutMillis, reconnectionDelayMillis, immediateFail, layout, bufferSize, null);
        this.sslConfig = sslConfig;
    }

    public SslSocketManager(String name, OutputStream os, Socket sock, SslConfiguration sslConfig, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int reconnectionDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        super(name, os, sock, inetAddress, host, port, connectTimeoutMillis, reconnectionDelayMillis, immediateFail, layout, bufferSize, socketOptions);
        this.sslConfig = sslConfig;
    }

    @Deprecated
    public static SslSocketManager getSocketManager(SslConfiguration sslConfig, String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        return SslSocketManager.getSocketManager(sslConfig, host, port, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, null);
    }

    public static SslSocketManager getSocketManager(SslConfiguration sslConfig, String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        if (Strings.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (port <= 0) {
            port = 6514;
        }
        if (reconnectDelayMillis == 0) {
            reconnectDelayMillis = 30000;
        }
        String sslConfigId = SslSocketManager.createSslConfigurationId(sslConfig);
        String name = String.format("%s:%s:%d:%s", sslConfig.getProtocol(), host, port, sslConfigId);
        return (SslSocketManager)SslSocketManager.getManager(name, new SslFactoryData(sslConfig, host, port, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, socketOptions), FACTORY);
    }

    private static String createSslConfigurationId(SslConfiguration sslConfig) {
        return String.valueOf(Stream.of(sslConfig.getKeyStoreConfig(), sslConfig.getTrustStoreConfig()).filter(Objects::nonNull).flatMap(keyStoreConfig -> {
            Enumeration<String> aliases;
            try {
                aliases = keyStoreConfig.getKeyStore().aliases();
            }
            catch (KeyStoreException error) {
                LOGGER.error("Failed reading the aliases for the key store located at `{}`", (Object)keyStoreConfig.getLocation(), (Object)error);
                return Stream.empty();
            }
            return Collections.list(aliases).stream().sorted().flatMap(alias -> {
                X509Certificate certificate;
                try {
                    certificate = (X509Certificate)keyStoreConfig.getKeyStore().getCertificate((String)alias);
                }
                catch (KeyStoreException error) {
                    LOGGER.error("Failed reading the certificate of alias `{}` for the key store located at `{}`", alias, (Object)keyStoreConfig.getLocation(), (Object)error);
                    return Stream.empty();
                }
                String issuer = certificate.getIssuerX500Principal().getName();
                String serialNumber = certificate.getSerialNumber().toString();
                return Stream.of(issuer, serialNumber);
            });
        }).collect(Collectors.toList()).hashCode());
    }

    @Override
    protected Socket createSocket(InetSocketAddress socketAddress) throws IOException {
        return SslSocketManager.createSocket(this.getHost(), socketAddress, this.getConnectTimeoutMillis(), this.sslConfig, this.getSocketOptions());
    }

    private static SSLSocketFactory createSslSocketFactory(SslConfiguration sslConf) {
        SSLContext sslContext;
        if (sslConf != null && (sslContext = sslConf.getSslContext()) != null) {
            return sslContext.getSocketFactory();
        }
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    private static Socket createSocket(String hostName, InetSocketAddress socketAddress, int connectTimeoutMillis, SslConfiguration sslConfiguration, SocketOptions socketOptions) throws IOException {
        SSLSocketFactory socketFactory = SslSocketManager.createSslSocketFactory(sslConfiguration);
        SSLSocket socket = (SSLSocket)socketFactory.createSocket();
        if (socketOptions != null) {
            socketOptions.apply(socket);
        }
        socket.connect(socketAddress, connectTimeoutMillis);
        if (sslConfiguration.isVerifyHostName()) {
            SSLParameters sslParameters = socket.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            SNIHostName serverName = SslSocketManager.createSniHostName(hostName);
            if (serverName != null) {
                sslParameters.setServerNames(Collections.singletonList(serverName));
            }
            socket.setSSLParameters(sslParameters);
        }
        socket.startHandshake();
        return socket;
    }

    static @Nullable SNIHostName createSniHostName(String hostName) {
        if (!hostName.matches("\\d+[.]\\d+[.]\\d+[.]\\d+")) {
            try {
                return new SNIHostName(hostName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class SslFactoryData
    extends TcpSocketManager.FactoryData {
        protected SslConfiguration sslConfiguration;

        public SslFactoryData(SslConfiguration sslConfiguration, String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
            super(host, port, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, socketOptions);
            this.sslConfiguration = sslConfiguration;
        }

        @Override
        public String toString() {
            return "SslFactoryData [sslConfiguration=" + this.sslConfiguration + ", host=" + this.host + ", port=" + this.port + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", reconnectDelayMillis=" + this.reconnectDelayMillis + ", immediateFail=" + this.immediateFail + ", layout=" + this.layout + ", bufferSize=" + this.bufferSize + ", socketOptions=" + this.socketOptions + "]";
        }
    }

    private static class SslSocketManagerFactory
    extends TcpSocketManager.TcpSocketManagerFactory<SslSocketManager, SslFactoryData> {
        private SslSocketManagerFactory() {
        }

        @Override
        SslSocketManager createManager(String name, OutputStream os, Socket socket, InetAddress inetAddress, SslFactoryData data) {
            return new SslSocketManager(name, os, socket, data.sslConfiguration, inetAddress, data.host, data.port, data.connectTimeoutMillis, data.reconnectDelayMillis, data.immediateFail, data.layout, data.bufferSize, data.socketOptions);
        }

        @Override
        Socket createSocket(SslFactoryData data) throws IOException {
            List<InetSocketAddress> socketAddresses = RESOLVER.resolveHost(data.host, data.port);
            IOException ioe = null;
            for (InetSocketAddress socketAddress : socketAddresses) {
                try {
                    return SslSocketManager.createSocket(data.host, socketAddress, data.connectTimeoutMillis, data.sslConfiguration, data.socketOptions);
                }
                catch (IOException ex) {
                    String message = String.format("failed create a socket to `%s:%s` that is resolved to address `%s`", data.host, data.port, socketAddress);
                    IOException newEx = new IOException(message, ex);
                    if (ioe == null) {
                        ioe = newEx;
                        continue;
                    }
                    ioe.addSuppressed(newEx);
                }
            }
            throw new IOException(this.errorMessage(data, socketAddresses), ioe);
        }
    }
}

