/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum FirmwareType {
  SYSTEM_1((int) 0x0010),
  SYSTEM_2((int) 0x0020),
  SYSTEM_300((int) 0x0300),
  SYSTEM_7((int) 0x0700),
  SYSTEM_B((int) 0x07B0),
  IR_DECODER((int) 0x0810),
  COUPLER((int) 0x0910),
  NONE((int) 0x0AF0),
  SYSTEM_1_PL110((int) 0x10B0),
  SYSTEM_B_PL110((int) 0x17B0),
  MEDIA_COUPLER_PL_TP((int) 0x1900),
  RF_BI_DIRECTIONAL_DEVICES((int) 0x2000),
  RF_UNI_DIRECTIONAL_DEVICES((int) 0x2100),
  SYSTEM_1_TP0((int) 0x3000),
  SYSTEM_1_PL132((int) 0x4000),
  SYSTEM_7_KNX_NET_IP((int) 0x5700);
  private static final Map<Integer, FirmwareType> map;

  static {
    map = new HashMap<>();
    for (FirmwareType value : FirmwareType.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  FirmwareType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static FirmwareType enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
