/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataScheduleDefault is the corresponding interface of BACnetConstructedDataScheduleDefault
type BACnetConstructedDataScheduleDefault interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetScheduleDefault returns ScheduleDefault (property field)
	GetScheduleDefault() BACnetConstructedDataElement
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetConstructedDataElement
	// IsBACnetConstructedDataScheduleDefault is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataScheduleDefault()
	// CreateBuilder creates a BACnetConstructedDataScheduleDefaultBuilder
	CreateBACnetConstructedDataScheduleDefaultBuilder() BACnetConstructedDataScheduleDefaultBuilder
}

// _BACnetConstructedDataScheduleDefault is the data-structure of this message
type _BACnetConstructedDataScheduleDefault struct {
	BACnetConstructedDataContract
	ScheduleDefault BACnetConstructedDataElement
}

var _ BACnetConstructedDataScheduleDefault = (*_BACnetConstructedDataScheduleDefault)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataScheduleDefault)(nil)

// NewBACnetConstructedDataScheduleDefault factory function for _BACnetConstructedDataScheduleDefault
func NewBACnetConstructedDataScheduleDefault(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, scheduleDefault BACnetConstructedDataElement, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataScheduleDefault {
	if scheduleDefault == nil {
		panic("scheduleDefault of type BACnetConstructedDataElement for BACnetConstructedDataScheduleDefault must not be nil")
	}
	_result := &_BACnetConstructedDataScheduleDefault{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ScheduleDefault:               scheduleDefault,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataScheduleDefaultBuilder is a builder for BACnetConstructedDataScheduleDefault
type BACnetConstructedDataScheduleDefaultBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(scheduleDefault BACnetConstructedDataElement) BACnetConstructedDataScheduleDefaultBuilder
	// WithScheduleDefault adds ScheduleDefault (property field)
	WithScheduleDefault(BACnetConstructedDataElement) BACnetConstructedDataScheduleDefaultBuilder
	// WithScheduleDefaultBuilder adds ScheduleDefault (property field) which is build by the builder
	WithScheduleDefaultBuilder(func(BACnetConstructedDataElementBuilder) BACnetConstructedDataElementBuilder) BACnetConstructedDataScheduleDefaultBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataScheduleDefault or returns an error if something is wrong
	Build() (BACnetConstructedDataScheduleDefault, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataScheduleDefault
}

// NewBACnetConstructedDataScheduleDefaultBuilder() creates a BACnetConstructedDataScheduleDefaultBuilder
func NewBACnetConstructedDataScheduleDefaultBuilder() BACnetConstructedDataScheduleDefaultBuilder {
	return &_BACnetConstructedDataScheduleDefaultBuilder{_BACnetConstructedDataScheduleDefault: new(_BACnetConstructedDataScheduleDefault)}
}

type _BACnetConstructedDataScheduleDefaultBuilder struct {
	*_BACnetConstructedDataScheduleDefault

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataScheduleDefaultBuilder) = (*_BACnetConstructedDataScheduleDefaultBuilder)(nil)

func (b *_BACnetConstructedDataScheduleDefaultBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataScheduleDefault
}

func (b *_BACnetConstructedDataScheduleDefaultBuilder) WithMandatoryFields(scheduleDefault BACnetConstructedDataElement) BACnetConstructedDataScheduleDefaultBuilder {
	return b.WithScheduleDefault(scheduleDefault)
}

func (b *_BACnetConstructedDataScheduleDefaultBuilder) WithScheduleDefault(scheduleDefault BACnetConstructedDataElement) BACnetConstructedDataScheduleDefaultBuilder {
	b.ScheduleDefault = scheduleDefault
	return b
}

func (b *_BACnetConstructedDataScheduleDefaultBuilder) WithScheduleDefaultBuilder(builderSupplier func(BACnetConstructedDataElementBuilder) BACnetConstructedDataElementBuilder) BACnetConstructedDataScheduleDefaultBuilder {
	builder := builderSupplier(b.ScheduleDefault.CreateBACnetConstructedDataElementBuilder())
	var err error
	b.ScheduleDefault, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetConstructedDataElementBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataScheduleDefaultBuilder) Build() (BACnetConstructedDataScheduleDefault, error) {
	if b.ScheduleDefault == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'scheduleDefault' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataScheduleDefault.deepCopy(), nil
}

func (b *_BACnetConstructedDataScheduleDefaultBuilder) MustBuild() BACnetConstructedDataScheduleDefault {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataScheduleDefaultBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataScheduleDefaultBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataScheduleDefaultBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataScheduleDefaultBuilder().(*_BACnetConstructedDataScheduleDefaultBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataScheduleDefaultBuilder creates a BACnetConstructedDataScheduleDefaultBuilder
func (b *_BACnetConstructedDataScheduleDefault) CreateBACnetConstructedDataScheduleDefaultBuilder() BACnetConstructedDataScheduleDefaultBuilder {
	if b == nil {
		return NewBACnetConstructedDataScheduleDefaultBuilder()
	}
	return &_BACnetConstructedDataScheduleDefaultBuilder{_BACnetConstructedDataScheduleDefault: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataScheduleDefault) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataScheduleDefault) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_SCHEDULE_DEFAULT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataScheduleDefault) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataScheduleDefault) GetScheduleDefault() BACnetConstructedDataElement {
	return m.ScheduleDefault
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataScheduleDefault) GetActualValue() BACnetConstructedDataElement {
	ctx := context.Background()
	_ = ctx
	return CastBACnetConstructedDataElement(m.GetScheduleDefault())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataScheduleDefault(structType any) BACnetConstructedDataScheduleDefault {
	if casted, ok := structType.(BACnetConstructedDataScheduleDefault); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataScheduleDefault); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataScheduleDefault) GetTypeName() string {
	return "BACnetConstructedDataScheduleDefault"
}

func (m *_BACnetConstructedDataScheduleDefault) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (scheduleDefault)
	lengthInBits += m.ScheduleDefault.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataScheduleDefault) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataScheduleDefault) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataScheduleDefault BACnetConstructedDataScheduleDefault, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataScheduleDefault"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataScheduleDefault")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	scheduleDefault, err := ReadSimpleField[BACnetConstructedDataElement](ctx, "scheduleDefault", ReadComplex[BACnetConstructedDataElement](BACnetConstructedDataElementParseWithBufferProducer((BACnetObjectType)(objectTypeArgument), (BACnetPropertyIdentifier)(propertyIdentifierArgument), (BACnetTagPayloadUnsignedInteger)(nil)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'scheduleDefault' field"))
	}
	m.ScheduleDefault = scheduleDefault

	actualValue, err := ReadVirtualField[BACnetConstructedDataElement](ctx, "actualValue", (*BACnetConstructedDataElement)(nil), scheduleDefault)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataScheduleDefault"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataScheduleDefault")
	}

	return m, nil
}

func (m *_BACnetConstructedDataScheduleDefault) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataScheduleDefault) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataScheduleDefault"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataScheduleDefault")
		}

		if err := WriteSimpleField[BACnetConstructedDataElement](ctx, "scheduleDefault", m.GetScheduleDefault(), WriteComplex[BACnetConstructedDataElement](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'scheduleDefault' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataScheduleDefault"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataScheduleDefault")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataScheduleDefault) IsBACnetConstructedDataScheduleDefault() {}

func (m *_BACnetConstructedDataScheduleDefault) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataScheduleDefault) deepCopy() *_BACnetConstructedDataScheduleDefault {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataScheduleDefaultCopy := &_BACnetConstructedDataScheduleDefault{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetConstructedDataElement](m.ScheduleDefault),
	}
	_BACnetConstructedDataScheduleDefaultCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataScheduleDefaultCopy
}

func (m *_BACnetConstructedDataScheduleDefault) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
