/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.openjpa.persistence.jdbc.common.apps;


import java.io.Serializable;
import java.util.StringTokenizer;


/**
 *	Application object ID class for MappingTest2.
 *	Auto-generated by kodo.enhance.ApplicationIdTool.
 */
public class MappingTest2ID	implements Serializable
{
    private static final long serialVersionUID = 1L;
    // each pk field in MappingTest2
	// must be listed as a public field here
	public int         pk1;
	public int         pk2;


	/**
	 *	Default constructor.
	 */
	public MappingTest2ID ()
	{
	}


	/**
	 *	String constructor.
	 */
	public MappingTest2ID (String str)
	{
		StringTokenizer toke = new StringTokenizer (str, "::");

		str = toke.nextToken ();
		this.pk1 = Integer.parseInt (str);
		str = toke.nextToken ();
		this.pk2 = Integer.parseInt (str);
	}


	/**
	 *	Implementation of equals method.
	 */
	@Override
    public boolean equals (Object ob)
	{
		if (this == ob)
			return true;
		if (!(ob instanceof MappingTest2ID))
			return false;

		MappingTest2ID other = (MappingTest2ID) ob;
		return (this.pk1 == other.pk1)
			&& (this.pk2 == other.pk2);
	}


	/**
	 *	Implementation of hashCode method that supports the
	 *	equals-hashCode contract.
	 */
	@Override
    public int hashCode ()
	{
		return this.pk1
			+ this.pk2;
	}


	/**
	 *	Implementation of toString that outputs this object id's
	 *	primary key values.
	 */
	@Override
    public String toString ()
	{
		return this.pk1
			+ "::" + this.pk2;
	}
}
