/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;

public class ExpandSelectTreeNodeImpl
extends ExpandSelectTreeNode {
    private AllKinds isAll = AllKinds.IMPLICITLYTRUE;
    private boolean isExplicitlySelected = false;
    private boolean isExpanded = false;
    private final List<EdmProperty> properties = new ArrayList<EdmProperty>();
    private final Map<String, ExpandSelectTreeNodeImpl> links = new HashMap<String, ExpandSelectTreeNodeImpl>();
    private final List<ExpandSelectTreeNode> expandselectTreeNodes = new ArrayList<ExpandSelectTreeNode>();

    public boolean isAll() {
        return this.isAll.getBoolean();
    }

    public List<EdmProperty> getProperties() {
        return this.properties;
    }

    public Map<String, ExpandSelectTreeNode> getLinks() {
        return Collections.unmodifiableMap(this.links);
    }

    public List<ExpandSelectTreeNode> getExpandedList() {
        return this.expandselectTreeNodes;
    }

    public void putLink(String name, ExpandSelectTreeNodeImpl node) {
        this.links.put(name, node);
    }

    public void removeLink(String name) {
        this.links.remove(name);
    }

    public boolean isExplicitlySelected() {
        return this.isExplicitlySelected;
    }

    public void setExplicitlySelected() {
        this.isExplicitlySelected = true;
        this.setAllExplicitly();
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded() {
        this.isExpanded = true;
    }

    public void addProperty(EdmProperty property) {
        if (property != null && this.isAll != AllKinds.EXPLICITLYTRUE && !this.properties.contains(property)) {
            this.properties.add(property);
            this.isAll = AllKinds.FALSE;
        }
    }

    public void setAllExplicitly() {
        this.properties.clear();
        this.isAll = AllKinds.EXPLICITLYTRUE;
    }

    public AllKinds getAllKind() {
        return this.isAll;
    }

    public void setAllKindFalse() {
        this.isAll = AllKinds.FALSE;
    }

    public String toJsonString() {
        try {
            StringWriter writer = new StringWriter();
            JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
            jsonStreamWriter.beginObject().name("all").unquotedValue(Boolean.toString(this.isAll())).separator().name("properties").beginArray();
            boolean first = true;
            for (EdmProperty edmProperty : this.properties) {
                if (first) {
                    first = false;
                } else {
                    jsonStreamWriter.separator();
                }
                jsonStreamWriter.stringValueRaw(edmProperty.getName());
            }
            jsonStreamWriter.endArray().separator().name("links").beginArray();
            first = true;
            for (Map.Entry entry : this.links.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    jsonStreamWriter.separator();
                }
                String nodeString = entry.getValue() == null ? null : ((ExpandSelectTreeNodeImpl)((Object)entry.getValue())).toJsonString();
                jsonStreamWriter.beginObject().name((String)entry.getKey()).unquotedValue(nodeString).endObject();
            }
            jsonStreamWriter.endArray().endObject();
            writer.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new ODataRuntimeException("IOException: ", e);
        }
        catch (EdmException e) {
            throw new ODataRuntimeException("EdmException: ", e);
        }
    }

    public static enum AllKinds {
        IMPLICITLYTRUE(true),
        EXPLICITLYTRUE(true),
        FALSE(false);

        private boolean booleanRepresentation;

        private AllKinds(boolean booleanRepresentation) {
            this.booleanRepresentation = booleanRepresentation;
        }

        public boolean getBoolean() {
            return this.booleanRepresentation;
        }
    }

    public class ExpandSelectTreeNodeBuilderImpl
    extends ExpandSelectTreeNode.ExpandSelectTreeNodeBuilder {
        private EdmEntitySet entitySet;
        private List<String> selectedPropertyNames;
        private List<String> selectedNavigationPropertyNames;
        private Map<String, ExpandSelectTreeNode> customExpandedNavigationProperties;
        private List<String> expandedNavigationPropertyNames;

        public ExpandSelectTreeNode.ExpandSelectTreeNodeBuilder entitySet(EdmEntitySet entitySet) {
            this.entitySet = entitySet;
            return this;
        }

        public ExpandSelectTreeNode build() throws EdmException {
            EdmEntityType entityType = this.entitySet.getEntityType();
            if (this.selectedPropertyNames != null) {
                this.handleProperties(entityType);
            }
            if (this.selectedNavigationPropertyNames != null) {
                ExpandSelectTreeNodeImpl.this.setAllKindFalse();
                this.handleLinks(entityType, this.selectedNavigationPropertyNames, null);
            }
            if (this.expandedNavigationPropertyNames != null) {
                ExpandSelectTreeNodeImpl subNode = new ExpandSelectTreeNodeImpl();
                subNode.setExplicitlySelected();
                this.handleLinks(entityType, this.expandedNavigationPropertyNames, subNode);
            }
            if (this.customExpandedNavigationProperties != null) {
                this.handleCustomLinks(entityType);
            }
            return ExpandSelectTreeNodeImpl.this;
        }

        private void handleCustomLinks(EdmEntityType entityType) throws EdmException {
            for (Map.Entry<String, ExpandSelectTreeNode> entry : this.customExpandedNavigationProperties.entrySet()) {
                EdmTyped navigationProperty = entityType.getProperty(entry.getKey());
                if (navigationProperty == null) {
                    throw new EdmException(EdmException.NAVIGATIONPROPERTYNOTFOUND.addContent(new Object[]{entry.getKey()}));
                }
                if (!(navigationProperty instanceof EdmNavigationProperty)) {
                    throw new EdmException(EdmException.MUSTBENAVIGATIONPROPERTY.addContent(new Object[]{entry.getKey()}));
                }
                ExpandSelectTreeNodeImpl.this.putLink(entry.getKey(), (ExpandSelectTreeNodeImpl)entry.getValue());
            }
        }

        private void handleLinks(EdmEntityType entityType, List<String> names, ExpandSelectTreeNodeImpl subNode) throws EdmException {
            for (String navigationPropertyName : names) {
                EdmTyped navigationProperty = entityType.getProperty(navigationPropertyName);
                if (navigationProperty == null) {
                    throw new EdmException(EdmException.NAVIGATIONPROPERTYNOTFOUND.addContent(new Object[]{navigationPropertyName}));
                }
                if (!(navigationProperty instanceof EdmNavigationProperty)) {
                    throw new EdmException(EdmException.MUSTBENAVIGATIONPROPERTY.addContent(new Object[]{navigationPropertyName}));
                }
                ExpandSelectTreeNodeImpl.this.putLink(navigationPropertyName, subNode);
            }
        }

        private void handleProperties(EdmEntityType entityType) throws EdmException {
            for (String propertyName : this.selectedPropertyNames) {
                EdmTyped property = entityType.getProperty(propertyName);
                if (property == null) {
                    throw new EdmException(EdmException.PROPERTYNOTFOUND.addContent(new Object[]{propertyName}));
                }
                if (!(property instanceof EdmProperty)) {
                    throw new EdmException(EdmException.MUSTBEPROPERTY.addContent(new Object[]{propertyName}));
                }
                ExpandSelectTreeNodeImpl.this.addProperty((EdmProperty)property);
            }
        }

        public ExpandSelectTreeNode.ExpandSelectTreeNodeBuilder selectedProperties(List<String> selectedPropertyNames) {
            this.selectedPropertyNames = selectedPropertyNames;
            return this;
        }

        public ExpandSelectTreeNode.ExpandSelectTreeNodeBuilder selectedLinks(List<String> selectedNavigationPropertyNames) {
            this.selectedNavigationPropertyNames = selectedNavigationPropertyNames;
            return this;
        }

        public ExpandSelectTreeNode.ExpandSelectTreeNodeBuilder customExpandedLink(String navigationPropertyName, ExpandSelectTreeNode expandNode) {
            if (expandNode == null) {
                throw new ODataRuntimeException("ExpandNode must not be null");
            }
            if (this.customExpandedNavigationProperties == null) {
                this.customExpandedNavigationProperties = new HashMap<String, ExpandSelectTreeNode>();
            }
            this.customExpandedNavigationProperties.put(navigationPropertyName, expandNode);
            return this;
        }

        public ExpandSelectTreeNode.ExpandSelectTreeNodeBuilder expandedLinks(List<String> navigationPropertyNames) {
            this.expandedNavigationPropertyNames = navigationPropertyNames;
            return this;
        }
    }
}

